/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyRandomBase;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Random;

@JRubyClass(name={"Random"})
public class RubyRandom
extends RubyRandomBase {
    private static final int DEFAULT_SEED_CNT = 4;

    public static BigInteger randomSeedBigInteger(java.util.Random random) {
        byte[] seed2 = new byte[16];
        random.nextBytes(seed2);
        return new BigInteger(seed2).abs();
    }

    public static RubyBignum randomSeed(Ruby runtime2) {
        return RubyBignum.newBignum(runtime2, RubyRandom.randomSeedBigInteger(runtime2.random));
    }

    public static RubyClass createRandomClass(ThreadContext context, RubyClass Object2) {
        RubyClass RandomBase = (RubyClass)((RubyModule)((RubyModule)RubyClass.newClass(context, Object2, null).allocator(ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).baseName("Base")).defineMethods(context, RubyRandomBase.class);
        RubyClass Random2 = (RubyClass)((RubyModule)Define.defineClass(context, "Random", RandomBase, RubyRandom::new).defineConstant(context, "Base", RandomBase)).defineMethods(context, RubyRandom.class);
        Object RandomFormatter2 = Random2.defineModuleUnder(context, "Formatter").defineMethods(context, RandomFormatter.class);
        RandomBase.include(context, (RubyModule)RandomFormatter2);
        ((RubyModule)RandomFormatter2).extend_object(context, RandomBase);
        return Random2;
    }

    @Deprecated(since="10.0")
    public static RubyRandom newRandom(Ruby runtime2, RubyClass randomClass, IRubyObject seed2) {
        return RubyRandom.newRandom(runtime2.getCurrentContext(), randomClass, seed2);
    }

    public static RubyRandom newRandom(ThreadContext context, RubyClass randomClass, IRubyObject seed2) {
        return new RubyRandom(context.runtime, randomClass, new RandomType(context, seed2));
    }

    public RandomType getRandomType() {
        return this.random;
    }

    RubyRandom(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    RubyRandom(Ruby runtime2, RubyClass rubyClass, RandomType randomType) {
        super(runtime2, rubyClass);
        this.random = randomType;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject seed(ThreadContext context, IRubyObject self2) {
        return RubyRandom.getDefaultRand(context).getSeed();
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject orig) {
        if (!(orig instanceof RubyRandom)) {
            throw Error.typeError(context, orig, "Random");
        }
        RubyRandom rand2 = (RubyRandom)orig;
        this.checkFrozen();
        this.random = new RandomType(rand2.random);
        return this;
    }

    @JRubyMethod(name={"rand"}, meta=true)
    public static IRubyObject randDefault(ThreadContext context, IRubyObject recv2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        return RubyRandom.randFloat(context, random);
    }

    @JRubyMethod(name={"rand"}, meta=true)
    public static IRubyObject randDefault(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        IRubyObject v = RubyRandom.randRandom(context, recv2, random, arg2);
        RubyRandom.checkRandomNumber(context, v, arg2);
        return v;
    }

    static IRubyObject randKernel(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        if (arg2 == context.nil) {
            return RubyRandom.randFloat(context, random);
        }
        if (arg2 instanceof RubyRange) {
            return RubyRandom.randRandom(context, self2, random, arg2);
        }
        RubyInteger max2 = Convert.toInteger(context, arg2);
        if (max2.isZero(context)) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject r = RubyRandom.randInt(context, self2, random, max2, false);
        return r == context.nil ? RubyRandom.randFloat(context, random) : r;
    }

    @JRubyMethod(name={"default"}, meta=true)
    public static IRubyObject rbDefault(ThreadContext context, IRubyObject self2) {
        return context.runtime.getDefaultRandom();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srandCommon(context, recv2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2, IRubyObject seed2) {
        return RubyRandom.srandCommon(context, recv2, seed2);
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srandCommon(context, recv2, RubyRandom.randomSeed(context.runtime));
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv2, IRubyObject newSeed2) {
        Ruby runtime2 = context.runtime;
        RubyRandom defaultRandom = RubyRandom.getDefaultRandom(runtime2);
        RubyInteger previousSeed = defaultRandom.getRandomType().getSeed();
        defaultRandom = RubyRandom.newRandom(context, runtime2.getRandomClass(), newSeed2);
        context.runtime.setDefaultRandom(defaultRandom);
        return previousSeed;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        if (!this.getType().equals(obj.getType())) {
            return context.fals;
        }
        return Convert.asBoolean(context, this.random.equals(((RubyRandom)obj).random));
    }

    @JRubyMethod(name={"state"}, visibility=Visibility.PRIVATE)
    public IRubyObject stateObj(ThreadContext context) {
        return this.random.getState();
    }

    @JRubyMethod(name={"left"}, visibility=Visibility.PRIVATE)
    public IRubyObject leftObj(ThreadContext context) {
        return Convert.asFixnum(context, this.random.getLeft());
    }

    @JRubyMethod(name={"state"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject state(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.getDefaultRand(context).getState();
    }

    @JRubyMethod(name={"left"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject left(ThreadContext context, IRubyObject recv2) {
        return Convert.asFixnum(context, RubyRandom.getDefaultRand(context).getLeft());
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyBignum state2 = this.random.getState();
        RubyFixnum left2 = Convert.asFixnum(context, (long)this.random.getLeft());
        RubyArray<?> dump2 = Create.newArray(context, (IRubyObject)state2, (IRubyObject)left2, (IRubyObject)this.random.getSeed());
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        if (load2.size() != 3) {
            throw Error.argumentError(context, "wrong dump data");
        }
        RubyBignum state2 = Convert.castAsBignum(context, load2.eltInternal(0));
        int left2 = Convert.toInt(context, load2.eltInternal(1));
        Object seed2 = load2.eltInternal(2);
        this.checkFrozen();
        this.random = new RandomType(context, (IRubyObject)seed2, state2, left2);
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        this.setFrozen(true);
        return this;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject bytes(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyRandom.bytesCommon(context, RubyRandom.getDefaultRand(context), arg2);
    }

    @JRubyMethod(name={"new_seed"}, meta=true)
    public static IRubyObject newSeed(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.randomSeed(context.runtime);
    }

    @JRubyMethod(name={"urandom"}, meta=true)
    public static IRubyObject urandom(ThreadContext context, IRubyObject recv2, IRubyObject num) {
        int n = Convert.toInt(context, num);
        if (n < 0) {
            throw Error.argumentError(context, "negative string size (or size too big)");
        }
        if (n == 0) {
            return Create.newEmptyString(context);
        }
        byte[] seed2 = new byte[n];
        context.runtime.random.nextBytes(seed2);
        return Create.newString(context, seed2);
    }

    @Deprecated
    static IRubyObject randKernel(ThreadContext context, IRubyObject[] args2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        if (args2.length == 0) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject arg2 = args2[0];
        return RubyRandom.randKernel(context, context.runtime.getRandomClass(), arg2);
    }

    @Deprecated
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> RubyRandom.randDefault(context, recv2);
            case 1 -> RubyRandom.randDefault(context, recv2, args2[0]);
            default -> throw Error.argumentError(context, args2.length, 0, 1);
        };
    }

    @Deprecated
    public IRubyObject randObj(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.rand(context) : this.rand(context, args2[0]);
    }

    public static class RandomFormatter {
        @JRubyMethod(name={"rand", "random_number"})
        public static IRubyObject randomNumber(ThreadContext context, IRubyObject self2) {
            RandomType rnd = RandomFormatter.tryGetRnd(context, self2);
            IRubyObject v = RubyRandomBase.randRandom(context, self2, rnd);
            return v;
        }

        @JRubyMethod(name={"rand", "random_number"})
        public static IRubyObject randomNumber(ThreadContext context, IRubyObject self2, IRubyObject arg0) {
            RandomType rnd = RubyRandomBase.tryGetRandomType(context, self2);
            IRubyObject v = RubyRandomBase.randRandom(context, self2, rnd, arg0);
            if (v.isNil()) {
                v = RubyRandomBase.randRandom(context, self2, rnd);
            } else if (v == context.fals) {
                RubyRandomBase.invalidArgument(context, arg0);
            }
            return v;
        }

        static RandomType tryGetRnd(ThreadContext context, IRubyObject obj) {
            if (obj == context.runtime.getRandomClass()) {
                return RubyRandomBase.getDefaultRand(context);
            }
            if (!(obj instanceof RubyRandom)) {
                return null;
            }
            return ((RubyRandom)obj).getRandomType();
        }
    }

    static final class RandomType {
        final RubyInteger seed;
        final Random impl;

        @Deprecated(since="10.0")
        RandomType(IRubyObject seed2) {
            this(((RubyBasicObject)seed2).getCurrentContext(), seed2);
        }

        RandomType(ThreadContext context, IRubyObject seed2) {
            RubyInteger rubyInteger = this.seed = Convert.toInteger(context, seed2);
            if (rubyInteger instanceof RubyFixnum) {
                RubyFixnum fixnum = (RubyFixnum)rubyInteger;
                this.impl = RandomType.randomFromFixnum(fixnum);
            } else {
                rubyInteger = this.seed;
                if (rubyInteger instanceof RubyBignum) {
                    RubyBignum bignum = (RubyBignum)rubyInteger;
                    this.impl = RandomType.randomFromBignum(bignum);
                } else {
                    throw Error.typeError(context, "failed to convert ", seed2, " into Integer");
                }
            }
        }

        public static Random randomFromFixnum(RubyFixnum seed2) {
            return RandomType.randomFromLong(seed2.getValue());
        }

        public static Random randomFromLong(long seed2) {
            long v = Math.abs(seed2);
            if (v == (v & 0xFFFFFFFFL)) {
                return new Random((int)v);
            }
            int[] ints = new int[]{(int)v, (int)(v >> 32)};
            return new Random(ints);
        }

        public static Random randomFromBignum(RubyBignum seed2) {
            BigInteger big = seed2.asBigInteger(seed2.getRuntime().getCurrentContext());
            return RandomType.randomFromBigInteger(big);
        }

        public static Random randomFromBigInteger(BigInteger big) {
            if (big.signum() < 0) {
                big = big.abs();
            }
            byte[] buf = big.toByteArray();
            int buflen = buf.length;
            if (buf[0] == 0) {
                --buflen;
            }
            int len = Math.min((buflen + 3) / 4, 624);
            int[] ints = RandomType.bigEndianToInts(buf, len);
            if (len <= 1) {
                return new Random(ints[0]);
            }
            return new Random(ints);
        }

        @Deprecated(since="10.0")
        RandomType(IRubyObject vseed, RubyBignum state2, int left2) {
            this(((RubyBasicObject)vseed).getCurrentContext(), vseed, state2, left2);
        }

        RandomType(ThreadContext context, IRubyObject vseed, RubyBignum state2, int left2) {
            this.seed = vseed.convertToInteger();
            byte[] bytes2 = state2.asBigInteger(context).toByteArray();
            int[] ints = new int[bytes2.length / 4];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                ints[i2] = RubyRandomBase.getIntBigIntegerBuffer(bytes2, i2);
            }
            this.impl = new Random(ints, left2);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RandomType)) {
                return false;
            }
            RandomType rhs = (RandomType)obj;
            return this.seed.op_equal(this.seed.getRuntime().getCurrentContext(), rhs.seed).isTrue() && this.impl.equals(rhs.impl);
        }

        public int hashCode() {
            return (629 + this.seed.hashCode()) * 37 + this.impl.hashCode();
        }

        RandomType(RandomType orig) {
            this.seed = orig.seed;
            this.impl = new Random(orig.impl);
        }

        int genrandInt32() {
            return this.impl.genrandInt32();
        }

        double genrandReal() {
            return this.impl.genrandReal();
        }

        double genrandReal(boolean excl) {
            if (excl) {
                return this.impl.genrandReal();
            }
            return this.impl.genrandReal2();
        }

        double genrandReal2() {
            return this.impl.genrandReal2();
        }

        RubyInteger getSeed() {
            return this.seed;
        }

        RubyBignum getState() {
            int[] ints = this.impl.getState();
            byte[] bytes2 = new byte[ints.length * 4];
            for (int idx = 0; idx < ints.length; ++idx) {
                RubyRandomBase.setIntBigIntegerBuffer(bytes2, idx, ints[idx]);
            }
            return RubyBignum.newBignum(this.seed.getRuntime(), new BigInteger(bytes2));
        }

        int getLeft() {
            return this.impl.getLeft();
        }

        private static int[] bigEndianToInts(byte[] buf, int initKeyLen) {
            int[] initKey = new int[initKeyLen];
            for (int idx = 0; idx < initKey.length; ++idx) {
                initKey[idx] = RubyRandomBase.getIntBigIntegerBuffer(buf, idx);
            }
            return initKey;
        }
    }
}

