/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma;

import org.multiverse.api.Txn;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.exceptions.TxnMandatoryException;
import org.multiverse.stms.gamma.transactionalobjects.GammaObject;
import org.multiverse.stms.gamma.transactions.GammaTxn;

public final class GammaStmUtils {
    public static String toDebugString(GammaObject o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + '@' + System.identityHashCode(o);
    }

    public static GammaTxn getRequiredThreadLocalGammaTxn() {
        Txn tx = TxnThreadLocal.getThreadLocalTxn();
        if (tx == null) {
            throw new TxnMandatoryException();
        }
        return GammaStmUtils.asGammaTxn(tx);
    }

    public static GammaTxn asGammaTxn(Txn tx) {
        if (tx instanceof GammaTxn) {
            return (GammaTxn)tx;
        }
        if (tx == null) {
            throw new NullPointerException("Txn can't be null");
        }
        tx.abort();
        throw new ClassCastException(String.format("Expected Txn of class %s, found %s", GammaTxn.class.getName(), tx.getClass().getName()));
    }

    public static boolean longAsBoolean(long value) {
        return value == 1L;
    }

    public static long booleanAsLong(boolean b) {
        return b ? 1L : 0L;
    }

    public static double longAsDouble(long value) {
        return Double.longBitsToDouble(value);
    }

    public static long doubleAsLong(double value) {
        return Double.doubleToLongBits(value);
    }

    private GammaStmUtils() {
    }
}

