/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Objects;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.ProjectDependencySpec;
import org.gradle.platform.base.ProjectDependencySpecBuilder;
import org.jspecify.annotations.Nullable;

public class DefaultProjectDependencySpec
implements ProjectDependencySpec {
    private final String projectPath;
    private final String libraryName;

    public DefaultProjectDependencySpec(String libraryName, String projectPath) {
        if (libraryName == null && projectPath == null) {
            throw new IllegalDependencyNotation("A project dependency must have at least a project or library name specified.");
        }
        this.libraryName = libraryName;
        this.projectPath = projectPath;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public @Nullable String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public String getDisplayName() {
        ArrayList<String> parts = new ArrayList<String>();
        if (this.getProjectPath() != null) {
            parts.add("project '" + this.getProjectPath() + "'");
        }
        if (this.getLibraryName() != null) {
            parts.add("library '" + this.getLibraryName() + "'");
        }
        return Joiner.on((char)' ').join(parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDependencySpec that = (DefaultProjectDependencySpec)o;
        return Objects.equals(this.projectPath, that.projectPath) && Objects.equals(this.libraryName, that.libraryName);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.projectPath);
        result = 31 * result + Objects.hashCode(this.libraryName);
        return result;
    }

    public static class Builder
    implements ProjectDependencySpecBuilder {
        private String projectPath;
        private String libraryName;

        @Override
        public ProjectDependencySpecBuilder project(String path) {
            this.checkNotSet("project", this.projectPath);
            this.projectPath = path;
            return this;
        }

        @Override
        public ProjectDependencySpecBuilder library(String name) {
            this.checkNotSet("library", this.libraryName);
            this.libraryName = name;
            return this;
        }

        private void checkNotSet(String name, String value) {
            if (value != null) {
                throw new IllegalDependencyNotation(String.format("Cannot set '%s' multiple times for project dependency.", name));
            }
        }

        @Override
        public DependencySpec build() {
            this.validate();
            return new DefaultProjectDependencySpec(this.libraryName, this.projectPath);
        }

        private void validate() {
            if (this.projectPath == null && this.libraryName != null && this.libraryName.contains(":")) {
                throw new IllegalDependencyNotation(String.format("'%s' is not a valid library name. Did you mean to refer to a module instead?", this.libraryName));
            }
        }
    }
}

