/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.extendable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.util.extendable.ExtendableItem;

public class UnmodifiableExtendableItem
implements ExtendableItem {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, String> unmodifiableAttributesView = Collections.unmodifiableMap(this.attributes);
    private final Map<String, String> extraAttributes = new HashMap<String, String>();
    private final Map<String, String> unmodifiableExtraAttributesView = Collections.unmodifiableMap(this.extraAttributes);
    private final Map<String, String> qualifiedExtraAttributes = new HashMap<String, String>();
    private final Map<String, String> unmodifiableQualifiedExtraAttributesView = Collections.unmodifiableMap(this.qualifiedExtraAttributes);

    public UnmodifiableExtendableItem(Map<String, String> stdAttributes, Map<String, String> extraAttributes) {
        if (stdAttributes != null) {
            this.attributes.putAll(stdAttributes);
        }
        if (extraAttributes != null) {
            for (Map.Entry<String, String> extraAtt : extraAttributes.entrySet()) {
                this.setExtraAttribute(extraAtt.getKey(), extraAtt.getValue());
            }
        }
    }

    @Override
    public String getAttribute(String attName) {
        return this.attributes.get(attName);
    }

    @Override
    public String getExtraAttribute(String attName) {
        String v = this.qualifiedExtraAttributes.get(attName);
        if (v == null) {
            v = this.extraAttributes.get(attName);
        }
        return v;
    }

    protected void setExtraAttribute(String attName, String attValue) {
        this.qualifiedExtraAttributes.put(attName, attValue);
        int index = attName.indexOf(58);
        if (index != -1) {
            attName = attName.substring(index + 1);
        }
        this.extraAttributes.put(attName, attValue);
        this.attributes.put(attName, attValue);
    }

    protected void setStandardAttribute(String attName, String attValue) {
        this.attributes.put(attName, attValue);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.unmodifiableAttributesView;
    }

    @Override
    public Map<String, String> getExtraAttributes() {
        return this.unmodifiableExtraAttributesView;
    }

    @Override
    public Map<String, String> getQualifiedExtraAttributes() {
        return this.unmodifiableQualifiedExtraAttributesView;
    }
}

