﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitectedRequest.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace WellArchitected {
namespace Model {

/**
 * <p>Input to get answer.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswerInput">AWS
 * API Reference</a></p>
 */
class GetAnswerRequest : public WellArchitectedRequest {
 public:
  AWS_WELLARCHITECTED_API GetAnswerRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetAnswer"; }

  AWS_WELLARCHITECTED_API Aws::String SerializePayload() const override;

  AWS_WELLARCHITECTED_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{

  inline const Aws::String& GetWorkloadId() const { return m_workloadId; }
  inline bool WorkloadIdHasBeenSet() const { return m_workloadIdHasBeenSet; }
  template <typename WorkloadIdT = Aws::String>
  void SetWorkloadId(WorkloadIdT&& value) {
    m_workloadIdHasBeenSet = true;
    m_workloadId = std::forward<WorkloadIdT>(value);
  }
  template <typename WorkloadIdT = Aws::String>
  GetAnswerRequest& WithWorkloadId(WorkloadIdT&& value) {
    SetWorkloadId(std::forward<WorkloadIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetLensAlias() const { return m_lensAlias; }
  inline bool LensAliasHasBeenSet() const { return m_lensAliasHasBeenSet; }
  template <typename LensAliasT = Aws::String>
  void SetLensAlias(LensAliasT&& value) {
    m_lensAliasHasBeenSet = true;
    m_lensAlias = std::forward<LensAliasT>(value);
  }
  template <typename LensAliasT = Aws::String>
  GetAnswerRequest& WithLensAlias(LensAliasT&& value) {
    SetLensAlias(std::forward<LensAliasT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetQuestionId() const { return m_questionId; }
  inline bool QuestionIdHasBeenSet() const { return m_questionIdHasBeenSet; }
  template <typename QuestionIdT = Aws::String>
  void SetQuestionId(QuestionIdT&& value) {
    m_questionIdHasBeenSet = true;
    m_questionId = std::forward<QuestionIdT>(value);
  }
  template <typename QuestionIdT = Aws::String>
  GetAnswerRequest& WithQuestionId(QuestionIdT&& value) {
    SetQuestionId(std::forward<QuestionIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline int GetMilestoneNumber() const { return m_milestoneNumber; }
  inline bool MilestoneNumberHasBeenSet() const { return m_milestoneNumberHasBeenSet; }
  inline void SetMilestoneNumber(int value) {
    m_milestoneNumberHasBeenSet = true;
    m_milestoneNumber = value;
  }
  inline GetAnswerRequest& WithMilestoneNumber(int value) {
    SetMilestoneNumber(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_workloadId;

  Aws::String m_lensAlias;

  Aws::String m_questionId;

  int m_milestoneNumber{0};
  bool m_workloadIdHasBeenSet = false;
  bool m_lensAliasHasBeenSet = false;
  bool m_questionIdHasBeenSet = false;
  bool m_milestoneNumberHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
