﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotevents/IoTEvents_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTEvents {
namespace Model {

/**
 * <p>Information about the detector model.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DetectorModelSummary">AWS
 * API Reference</a></p>
 */
class DetectorModelSummary {
 public:
  AWS_IOTEVENTS_API DetectorModelSummary() = default;
  AWS_IOTEVENTS_API DetectorModelSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTEVENTS_API DetectorModelSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTEVENTS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the detector model.</p>
   */
  inline const Aws::String& GetDetectorModelName() const { return m_detectorModelName; }
  inline bool DetectorModelNameHasBeenSet() const { return m_detectorModelNameHasBeenSet; }
  template <typename DetectorModelNameT = Aws::String>
  void SetDetectorModelName(DetectorModelNameT&& value) {
    m_detectorModelNameHasBeenSet = true;
    m_detectorModelName = std::forward<DetectorModelNameT>(value);
  }
  template <typename DetectorModelNameT = Aws::String>
  DetectorModelSummary& WithDetectorModelName(DetectorModelNameT&& value) {
    SetDetectorModelName(std::forward<DetectorModelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A brief description of the detector model.</p>
   */
  inline const Aws::String& GetDetectorModelDescription() const { return m_detectorModelDescription; }
  inline bool DetectorModelDescriptionHasBeenSet() const { return m_detectorModelDescriptionHasBeenSet; }
  template <typename DetectorModelDescriptionT = Aws::String>
  void SetDetectorModelDescription(DetectorModelDescriptionT&& value) {
    m_detectorModelDescriptionHasBeenSet = true;
    m_detectorModelDescription = std::forward<DetectorModelDescriptionT>(value);
  }
  template <typename DetectorModelDescriptionT = Aws::String>
  DetectorModelSummary& WithDetectorModelDescription(DetectorModelDescriptionT&& value) {
    SetDetectorModelDescription(std::forward<DetectorModelDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the detector model was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DetectorModelSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_detectorModelName;

  Aws::String m_detectorModelDescription;

  Aws::Utils::DateTime m_creationTime{};
  bool m_detectorModelNameHasBeenSet = false;
  bool m_detectorModelDescriptionHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTEvents
}  // namespace Aws
