﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appflow/Appflow_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Appflow {
namespace Model {

/**
 * <p>Contains information about the configuration of the lambda which is being
 * registered as the connector.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/LambdaConnectorProvisioningConfig">AWS
 * API Reference</a></p>
 */
class LambdaConnectorProvisioningConfig {
 public:
  AWS_APPFLOW_API LambdaConnectorProvisioningConfig() = default;
  AWS_APPFLOW_API LambdaConnectorProvisioningConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFLOW_API LambdaConnectorProvisioningConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFLOW_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Lambda ARN of the connector being registered.</p>
   */
  inline const Aws::String& GetLambdaArn() const { return m_lambdaArn; }
  inline bool LambdaArnHasBeenSet() const { return m_lambdaArnHasBeenSet; }
  template <typename LambdaArnT = Aws::String>
  void SetLambdaArn(LambdaArnT&& value) {
    m_lambdaArnHasBeenSet = true;
    m_lambdaArn = std::forward<LambdaArnT>(value);
  }
  template <typename LambdaArnT = Aws::String>
  LambdaConnectorProvisioningConfig& WithLambdaArn(LambdaArnT&& value) {
    SetLambdaArn(std::forward<LambdaArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_lambdaArn;
  bool m_lambdaArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace Appflow
}  // namespace Aws
