/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.perl.inline.java.InlineJavaCallback;
import org.perl.inline.java.InlineJavaCallbackQueue;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlException;
import org.perl.inline.java.InlineJavaPerlObject;
import org.perl.inline.java.InlineJavaServer;
import org.perl.inline.java.InlineJavaServerThread;
import org.perl.inline.java.InlineJavaUtils;

public class InlineJavaPerlCaller {
    private InlineJavaServer ijs = InlineJavaServer.GetInstance();
    private Thread creator = null;
    private static Map<Thread, InlineJavaCallbackQueue> thread_callback_queues = Collections.synchronizedMap(new HashMap());
    private static ResourceBundle resources = null;
    private static boolean inited = false;

    public InlineJavaPerlCaller() throws InlineJavaException {
        InlineJavaPerlCaller.init();
        Thread t = Thread.currentThread();
        if (!this.ijs.IsThreadPerlContact(t)) {
            throw new InlineJavaException("InlineJavaPerlCaller objects can only be created by threads that communicate directly with Perl");
        }
        this.creator = t;
    }

    protected static synchronized void init() throws InlineJavaException {
        if (!inited) {
            try {
                resources = ResourceBundle.getBundle("InlineJava");
                inited = true;
            }
            catch (MissingResourceException mre) {
                throw new InlineJavaException("Error loading InlineJava.properties: " + mre.getMessage());
            }
        }
    }

    protected static ResourceBundle GetBundle() {
        return resources;
    }

    public Object CallPerlSub(String sub, Object[] args) throws InlineJavaException, InlineJavaPerlException {
        return this.CallPerlSub(sub, args, null);
    }

    public Object CallPerlSub(String sub, Object[] args, Class cast) throws InlineJavaException, InlineJavaPerlException {
        InlineJavaCallback ijc = new InlineJavaCallback((String)null, sub, args, cast);
        return this.CallPerl(ijc);
    }

    public Object CallPerlMethod(InlineJavaPerlObject obj, String method, Object[] args) throws InlineJavaException, InlineJavaPerlException {
        return this.CallPerlMethod(obj, method, args, null);
    }

    public Object CallPerlMethod(InlineJavaPerlObject obj, String method, Object[] args, Class cast) throws InlineJavaException, InlineJavaPerlException {
        InlineJavaCallback ijc = new InlineJavaCallback(obj, method, args, cast);
        return this.CallPerl(ijc);
    }

    public Object CallPerlStaticMethod(String pkg, String method, Object[] args) throws InlineJavaException, InlineJavaPerlException {
        return this.CallPerlStaticMethod(pkg, method, args, null);
    }

    public Object CallPerlStaticMethod(String pkg, String method, Object[] args, Class cast) throws InlineJavaException, InlineJavaPerlException {
        InlineJavaCallback ijc = new InlineJavaCallback(pkg, method, args, cast);
        return this.CallPerl(ijc);
    }

    public Object eval(String code) throws InlineJavaPerlException, InlineJavaException {
        return this.eval(code, null);
    }

    public Object eval(String code, Class cast) throws InlineJavaPerlException, InlineJavaException {
        return this.CallPerlSub("Inline::Java::Callback::java_eval", new Object[]{code}, cast);
    }

    public Object require(String module_or_file) throws InlineJavaPerlException, InlineJavaException {
        return this.CallPerlSub("Inline::Java::Callback::java_require", new Object[]{module_or_file});
    }

    public Object require_file(String file) throws InlineJavaPerlException, InlineJavaException {
        return this.CallPerlSub("Inline::Java::Callback::java_require", new Object[]{file, Boolean.TRUE});
    }

    public Object require_module(String module) throws InlineJavaPerlException, InlineJavaException {
        return this.CallPerlSub("Inline::Java::Callback::java_require", new Object[]{module, Boolean.FALSE});
    }

    private Object CallPerl(InlineJavaCallback ijc) throws InlineJavaException, InlineJavaPerlException {
        Thread t = Thread.currentThread();
        if (t == this.creator) {
            ijc.Process();
            return ijc.GetResponse();
        }
        ijc.ClearResponse();
        InlineJavaCallbackQueue q = InlineJavaPerlCaller.GetQueue(this.creator);
        InlineJavaUtils.debug(3, "enqueing callback for processing for " + this.creator.getName() + " in " + t.getName() + "...");
        q.EnqueueCallback(ijc);
        InlineJavaUtils.debug(3, "notifying that a callback request is available for " + this.creator.getName() + " in " + t.getName());
        return ijc.WaitForResponse(t);
    }

    public void OpenCallbackStream() throws InlineJavaException {
        Thread t = Thread.currentThread();
        if (!this.ijs.IsThreadPerlContact(t)) {
            throw new InlineJavaException("InlineJavaPerlCaller.OpenCallbackStream() can only be called by threads that communicate directly with Perl");
        }
        InlineJavaCallbackQueue q = InlineJavaPerlCaller.GetQueue(t);
        q.OpenCallbackStream();
    }

    public int WaitForCallback(double timeout) throws InlineJavaException {
        Thread t = Thread.currentThread();
        if (!this.ijs.IsThreadPerlContact(t)) {
            throw new InlineJavaException("InlineJavaPerlCaller.WaitForCallback() can only be called by threads that communicate directly with Perl");
        }
        InlineJavaCallbackQueue q = InlineJavaPerlCaller.GetQueue(t);
        if (timeout == 0.0) {
            return q.GetSize();
        }
        if (timeout == -1.0) {
            timeout = 0.0;
        }
        return q.WaitForCallback(timeout);
    }

    public boolean ProcessNextCallback() throws InlineJavaException, InlineJavaPerlException {
        Thread t = Thread.currentThread();
        if (!this.ijs.IsThreadPerlContact(t)) {
            throw new InlineJavaException("InlineJavaPerlCaller.ProcessNextCallback() can only be called by threads that communicate directly with Perl");
        }
        InlineJavaCallbackQueue q = InlineJavaPerlCaller.GetQueue(t);
        return q.ProcessNextCallback();
    }

    public void CloseCallbackStream() throws InlineJavaException {
        InlineJavaCallbackQueue q = InlineJavaPerlCaller.GetQueue(this.creator);
        q.CloseCallbackStream();
    }

    public void StartCallbackLoop() throws InlineJavaException, InlineJavaPerlException {
        Thread t = Thread.currentThread();
        if (!this.ijs.IsThreadPerlContact(t)) {
            throw new InlineJavaException("InlineJavaPerlCaller.StartCallbackLoop() can only be called by threads that communicate directly with Perl");
        }
        InlineJavaCallbackQueue q = InlineJavaPerlCaller.GetQueue(t);
        InlineJavaUtils.debug(3, "starting callback loop for " + this.creator.getName() + " in " + t.getName());
        q.OpenCallbackStream();
        while (q.IsStreamOpen()) {
            q.ProcessNextCallback();
        }
    }

    public void StopCallbackLoop() throws InlineJavaException {
        Thread t = Thread.currentThread();
        InlineJavaCallbackQueue q = InlineJavaPerlCaller.GetQueue(this.creator);
        InlineJavaUtils.debug(3, "stopping callback loop for " + this.creator.getName() + " in " + t.getName());
        q.CloseCallbackStream();
    }

    static synchronized void AddThread(Thread t) {
        thread_callback_queues.put(t, new InlineJavaCallbackQueue());
    }

    static synchronized void RemoveThread(InlineJavaServerThread t) {
        thread_callback_queues.remove(t);
    }

    private static InlineJavaCallbackQueue GetQueue(Thread t) throws InlineJavaException {
        InlineJavaCallbackQueue q = thread_callback_queues.get(t);
        if (q == null) {
            throw new InlineJavaException("Can't find thread " + t.getName() + "!");
        }
        return q;
    }
}

