/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.sql.datasource.client.DataSourceClient;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.datasource.query.QueryHandler;
import org.opensearch.sql.directquery.rest.model.ExecuteDirectQueryRequest;
import org.opensearch.sql.directquery.rest.model.GetDirectQueryResourcesRequest;
import org.opensearch.sql.directquery.rest.model.GetDirectQueryResourcesResponse;
import org.opensearch.sql.directquery.rest.model.WriteDirectQueryResourcesRequest;
import org.opensearch.sql.directquery.rest.model.WriteDirectQueryResourcesResponse;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.exception.PrometheusClientException;
import org.opensearch.sql.prometheus.model.MetricMetadata;
import org.opensearch.sql.prometheus.model.PrometheusOptions;
import org.opensearch.sql.prometheus.model.PrometheusQueryType;

public class PrometheusQueryHandler
implements QueryHandler<PrometheusClient> {
    private static final Logger LOG = LogManager.getLogger(PrometheusQueryHandler.class);

    @Override
    public DataSourceType getSupportedDataSourceType() {
        return DataSourceType.PROMETHEUS;
    }

    @Override
    public boolean canHandle(DataSourceClient client) {
        return client instanceof PrometheusClient;
    }

    @Override
    public Class<PrometheusClient> getClientClass() {
        return PrometheusClient.class;
    }

    @Override
    public String executeQuery(PrometheusClient client, ExecuteDirectQueryRequest request) throws IOException {
        try {
            PrometheusOptions options = request.getPrometheusOptions();
            PrometheusQueryType queryType = options.getQueryType();
            if (queryType == null) {
                return this.createErrorJson("Query type is required for Prometheus queries");
            }
            String startTimeStr = options.getStart();
            String endTimeStr = options.getEnd();
            Integer limit = request.getMaxResults();
            Integer timeout = request.getTimeout();
            if (queryType == PrometheusQueryType.RANGE && (startTimeStr == null || endTimeStr == null)) {
                return this.createErrorJson("Start and end times are required for Prometheus queries");
            }
            if (queryType == PrometheusQueryType.INSTANT && options.getTime() == null) {
                return this.createErrorJson("Time is required for instant Prometheus queries");
            }
            switch (queryType) {
                case RANGE: {
                    JSONObject metricData = client.queryRange(request.getQuery(), Long.parseLong(startTimeStr), Long.parseLong(endTimeStr), options.getStep(), limit, timeout);
                    return metricData.toString();
                }
            }
            JSONObject metricData = client.query(request.getQuery(), Long.parseLong(options.getTime()), limit, timeout);
            return metricData.toString();
        }
        catch (NumberFormatException e) {
            return this.createErrorJson("Invalid time format: " + e.getMessage());
        }
        catch (PrometheusClientException e) {
            LOG.error("Prometheus client error executing query", (Throwable)e);
            return this.createErrorJson(e.getMessage());
        }
        catch (IOException e) {
            LOG.error("Error executing query", (Throwable)e);
            return this.createErrorJson(e.getMessage());
        }
    }

    private String createErrorJson(String message) {
        return new JSONObject().put("error", (Object)message).toString();
    }

    @Override
    public GetDirectQueryResourcesResponse<?> getResources(PrometheusClient client, GetDirectQueryResourcesRequest request) {
        try {
            if (request.getResourceType() == null) {
                throw new IllegalArgumentException("Resource type cannot be null");
            }
            switch (request.getResourceType()) {
                case LABELS: {
                    List<String> labels = client.getLabels(request.getQueryParams());
                    return GetDirectQueryResourcesResponse.withStringList(labels);
                }
                case LABEL: {
                    List<String> labelValues = client.getLabel(request.getResourceName(), request.getQueryParams());
                    return GetDirectQueryResourcesResponse.withStringList(labelValues);
                }
                case METADATA: {
                    Map<String, List<MetricMetadata>> metadata = client.getAllMetrics(request.getQueryParams());
                    return GetDirectQueryResourcesResponse.withMap(metadata);
                }
                case SERIES: {
                    List<Map<String, String>> series = client.getSeries(request.getQueryParams());
                    return GetDirectQueryResourcesResponse.withList(series);
                }
                case ALERTS: {
                    JSONObject alerts = client.getAlerts();
                    return GetDirectQueryResourcesResponse.withMap(alerts.toMap());
                }
                case RULES: {
                    JSONObject rules = client.getRules(request.getQueryParams());
                    return GetDirectQueryResourcesResponse.withMap(rules.toMap());
                }
                case ALERTMANAGER_ALERTS: {
                    JSONArray alerts = client.getAlertmanagerAlerts(request.getQueryParams());
                    return GetDirectQueryResourcesResponse.withList(alerts.toList());
                }
                case ALERTMANAGER_ALERT_GROUPS: {
                    JSONArray alertGroups = client.getAlertmanagerAlertGroups(request.getQueryParams());
                    return GetDirectQueryResourcesResponse.withList(alertGroups.toList());
                }
                case ALERTMANAGER_RECEIVERS: {
                    JSONArray receivers = client.getAlertmanagerReceivers();
                    return GetDirectQueryResourcesResponse.withList(receivers.toList());
                }
                case ALERTMANAGER_SILENCES: {
                    JSONArray silences = client.getAlertmanagerSilences();
                    return GetDirectQueryResourcesResponse.withList(silences.toList());
                }
            }
            throw new IllegalArgumentException("Invalid prometheus resource type: " + String.valueOf((Object)request.getResourceType()));
        }
        catch (IOException e) {
            LOG.error("Error getting resources", (Throwable)e);
            throw new PrometheusClientException(String.format("Error while getting resources for %s: %s", new Object[]{request.getResourceType(), e.getMessage()}));
        }
    }

    @Override
    public WriteDirectQueryResourcesResponse<?> writeResources(PrometheusClient client, WriteDirectQueryResourcesRequest request) {
        try {
            if (request.getResourceType() == null) {
                throw new IllegalArgumentException("Resource type cannot be null");
            }
            switch (request.getResourceType()) {
                case ALERTMANAGER_SILENCES: {
                    String createdSilence = client.createAlertmanagerSilences(request.getRequest());
                    return WriteDirectQueryResourcesResponse.withList(List.of(createdSilence));
                }
            }
            throw new IllegalArgumentException("Invalid prometheus resource type: " + String.valueOf((Object)request.getResourceType()));
        }
        catch (IOException e) {
            LOG.error("Error getting resources", (Throwable)e);
            throw new PrometheusClientException(String.format("Error while getting resources for %s: %s", new Object[]{request.getResourceType(), e.getMessage()}));
        }
    }
}

