/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GraphMergeStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GraphMergeStats> {
    @Nullable
    private final Long current;
    @Nullable
    private final Long currentDocs;
    @Nullable
    private final Long currentSizeInBytes;
    @Nullable
    private final Long total;
    @Nullable
    private final Long totalDocs;
    @Nullable
    private final Long totalSizeInBytes;
    @Nullable
    private final Long totalTimeInMillis;
    public static final JsonpDeserializer<GraphMergeStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GraphMergeStats::setupGraphMergeStatsDeserializer);

    private GraphMergeStats(Builder builder) {
        this.current = builder.current;
        this.currentDocs = builder.currentDocs;
        this.currentSizeInBytes = builder.currentSizeInBytes;
        this.total = builder.total;
        this.totalDocs = builder.totalDocs;
        this.totalSizeInBytes = builder.totalSizeInBytes;
        this.totalTimeInMillis = builder.totalTimeInMillis;
    }

    public static GraphMergeStats of(Function<Builder, ObjectBuilder<GraphMergeStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long current() {
        return this.current;
    }

    @Nullable
    public final Long currentDocs() {
        return this.currentDocs;
    }

    @Nullable
    public final Long currentSizeInBytes() {
        return this.currentSizeInBytes;
    }

    @Nullable
    public final Long total() {
        return this.total;
    }

    @Nullable
    public final Long totalDocs() {
        return this.totalDocs;
    }

    @Nullable
    public final Long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @Nullable
    public final Long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.current != null) {
            generator.writeKey("current");
            generator.write(this.current.longValue());
        }
        if (this.currentDocs != null) {
            generator.writeKey("current_docs");
            generator.write(this.currentDocs.longValue());
        }
        if (this.currentSizeInBytes != null) {
            generator.writeKey("current_size_in_bytes");
            generator.write(this.currentSizeInBytes.longValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total.longValue());
        }
        if (this.totalDocs != null) {
            generator.writeKey("total_docs");
            generator.write(this.totalDocs.longValue());
        }
        if (this.totalSizeInBytes != null) {
            generator.writeKey("total_size_in_bytes");
            generator.write(this.totalSizeInBytes.longValue());
        }
        if (this.totalTimeInMillis != null) {
            generator.writeKey("total_time_in_millis");
            generator.write(this.totalTimeInMillis.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGraphMergeStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::currentDocs, JsonpDeserializer.longDeserializer(), "current_docs");
        op.add(Builder::currentSizeInBytes, JsonpDeserializer.longDeserializer(), "current_size_in_bytes");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::totalDocs, JsonpDeserializer.longDeserializer(), "total_docs");
        op.add(Builder::totalSizeInBytes, JsonpDeserializer.longDeserializer(), "total_size_in_bytes");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.current);
        result = 31 * result + Objects.hashCode(this.currentDocs);
        result = 31 * result + Objects.hashCode(this.currentSizeInBytes);
        result = 31 * result + Objects.hashCode(this.total);
        result = 31 * result + Objects.hashCode(this.totalDocs);
        result = 31 * result + Objects.hashCode(this.totalSizeInBytes);
        result = 31 * result + Objects.hashCode(this.totalTimeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphMergeStats other = (GraphMergeStats)o;
        return Objects.equals(this.current, other.current) && Objects.equals(this.currentDocs, other.currentDocs) && Objects.equals(this.currentSizeInBytes, other.currentSizeInBytes) && Objects.equals(this.total, other.total) && Objects.equals(this.totalDocs, other.totalDocs) && Objects.equals(this.totalSizeInBytes, other.totalSizeInBytes) && Objects.equals(this.totalTimeInMillis, other.totalTimeInMillis);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GraphMergeStats> {
        @Nullable
        private Long current;
        @Nullable
        private Long currentDocs;
        @Nullable
        private Long currentSizeInBytes;
        @Nullable
        private Long total;
        @Nullable
        private Long totalDocs;
        @Nullable
        private Long totalSizeInBytes;
        @Nullable
        private Long totalTimeInMillis;

        public Builder() {
        }

        private Builder(GraphMergeStats o) {
            this.current = o.current;
            this.currentDocs = o.currentDocs;
            this.currentSizeInBytes = o.currentSizeInBytes;
            this.total = o.total;
            this.totalDocs = o.totalDocs;
            this.totalSizeInBytes = o.totalSizeInBytes;
            this.totalTimeInMillis = o.totalTimeInMillis;
        }

        private Builder(Builder o) {
            this.current = o.current;
            this.currentDocs = o.currentDocs;
            this.currentSizeInBytes = o.currentSizeInBytes;
            this.total = o.total;
            this.totalDocs = o.totalDocs;
            this.totalSizeInBytes = o.totalSizeInBytes;
            this.totalTimeInMillis = o.totalTimeInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder current(@Nullable Long value) {
            this.current = value;
            return this;
        }

        @Nonnull
        public final Builder currentDocs(@Nullable Long value) {
            this.currentDocs = value;
            return this;
        }

        @Nonnull
        public final Builder currentSizeInBytes(@Nullable Long value) {
            this.currentSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder total(@Nullable Long value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder totalDocs(@Nullable Long value) {
            this.totalDocs = value;
            return this;
        }

        @Nonnull
        public final Builder totalSizeInBytes(@Nullable Long value) {
            this.totalSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder totalTimeInMillis(@Nullable Long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public GraphMergeStats build() {
            this._checkSingleUse();
            return new GraphMergeStats(this);
        }
    }
}

