/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CjkAnalyzer
implements AnalyzerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, CjkAnalyzer> {
    @Nonnull
    private final List<String> stopwords;
    @Nullable
    private final String stopwordsPath;
    public static final JsonpDeserializer<CjkAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CjkAnalyzer::setupCjkAnalyzerDeserializer);

    private CjkAnalyzer(Builder builder) {
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
        this.stopwordsPath = builder.stopwordsPath;
    }

    public static CjkAnalyzer of(Function<Builder, ObjectBuilder<CjkAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Cjk;
    }

    @Nonnull
    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Nullable
    public final String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "cjk");
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.stopwordsPath != null) {
            generator.writeKey("stopwords_path");
            generator.write(this.stopwordsPath);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCjkAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.stopwords);
        result = 31 * result + Objects.hashCode(this.stopwordsPath);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CjkAnalyzer other = (CjkAnalyzer)o;
        return Objects.equals(this.stopwords, other.stopwords) && Objects.equals(this.stopwordsPath, other.stopwordsPath);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CjkAnalyzer> {
        @Nullable
        private List<String> stopwords;
        @Nullable
        private String stopwordsPath;

        public Builder() {
        }

        private Builder(CjkAnalyzer o) {
            this.stopwords = Builder._listCopy(o.stopwords);
            this.stopwordsPath = o.stopwordsPath;
        }

        private Builder(Builder o) {
            this.stopwords = Builder._listCopy(o.stopwords);
            this.stopwordsPath = o.stopwordsPath;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        @Nonnull
        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        @Nonnull
        public final Builder stopwordsPath(@Nullable String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Override
        @Nonnull
        public CjkAnalyzer build() {
            this._checkSingleUse();
            return new CjkAnalyzer(this);
        }
    }
}

