/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;

public class DiscoveryFilter {
    private final List<String> accountIds;
    private final String partition;

    protected DiscoveryFilter(BuilderImpl builder) {
        this.accountIds = builder.accountIds();
        this.partition = builder.partition();
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public String partition() {
        return this.partition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected List<String> accountIds;
        protected String partition;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DiscoveryFilter model) {
            this.accountIds = model.accountIds();
            this.partition = model.partition();
        }

        @Override
        public Builder accountIds(List<String> accountIds) {
            this.accountIds = accountIds;
            return this;
        }

        @Override
        public List<String> accountIds() {
            return this.accountIds;
        }

        @Override
        public Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        @Override
        public String partition() {
            return this.partition;
        }

        @Override
        public DiscoveryFilter build() {
            if (Objects.isNull(this.accountIds())) {
                throw new IllegalArgumentException("Missing value for required field `accountIds`");
            }
            if (Objects.isNull(this.partition())) {
                throw new IllegalArgumentException("Missing value for required field `partition`");
            }
            return new DiscoveryFilter(this);
        }
    }

    public static interface Builder {
        public Builder accountIds(List<String> var1);

        public List<String> accountIds();

        public Builder partition(String var1);

        public String partition();

        public DiscoveryFilter build();
    }
}

