/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.la;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ToDoubleBiFunction;
import java.util.stream.Collectors;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.Output;
import org.tribuo.math.la.DenseMatrix;
import org.tribuo.math.la.DenseSparseMatrix;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.la.Matrix;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.Tensor;
import org.tribuo.math.la.VectorIterator;
import org.tribuo.math.la.VectorTuple;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.util.IntDoublePair;
import org.tribuo.util.Util;

public class SparseVector
implements SGDVector {
    private static final long serialVersionUID = 1L;
    private final int[] shape;
    protected final int[] indices;
    protected final double[] values;
    private final int size;

    SparseVector(int size) {
        this.indices = new int[0];
        this.values = new double[0];
        this.size = size;
        this.shape = new int[]{size};
    }

    SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.shape = new int[]{size};
        this.indices = indices;
        this.values = values;
    }

    private SparseVector(SparseVector other) {
        this.size = other.size;
        int numActiveElements = other.numActiveElements();
        this.indices = new int[numActiveElements];
        this.values = new double[numActiveElements];
        int i = 0;
        for (VectorTuple tuple : other) {
            this.indices[i] = tuple.index;
            this.values[i] = tuple.value;
            ++i;
        }
        this.shape = new int[]{this.size};
    }

    public SparseVector(int size, int[] indices, double value) {
        this.indices = Arrays.copyOf(indices, indices.length);
        this.values = new double[indices.length];
        Arrays.fill(this.values, value);
        this.size = size;
        this.shape = new int[]{size};
    }

    public static <T extends Output<T>> SparseVector createSparseVector(Example<T> example, ImmutableFeatureMap featureInfo, boolean addBias) {
        int size;
        int numFeatures = example.size();
        if (addBias) {
            size = featureInfo.size() + 1;
            ++numFeatures;
        } else {
            size = featureInfo.size();
        }
        int[] tmpIndices = new int[numFeatures];
        double[] tmpValues = new double[numFeatures];
        int i = 0;
        int prevIdx = -1;
        for (Feature f : example) {
            int index = featureInfo.getID(f.getName());
            if (index > prevIdx) {
                prevIdx = index;
                tmpIndices[i] = index;
                tmpValues[i] = f.getValue();
                if (Double.isNaN(tmpValues[i])) {
                    throw new IllegalArgumentException("Example contained a NaN feature, " + f.toString());
                }
                ++i;
                continue;
            }
            if (index <= -1) continue;
            int collisionIdx = Arrays.binarySearch(tmpIndices, 0, i, index);
            if (collisionIdx < 0) {
                collisionIdx = -(collisionIdx + 1);
                System.arraycopy(tmpIndices, collisionIdx, tmpIndices, collisionIdx + 1, i - collisionIdx);
                System.arraycopy(tmpValues, collisionIdx, tmpValues, collisionIdx + 1, i - collisionIdx);
                tmpIndices[collisionIdx] = index;
                tmpValues[collisionIdx] = f.getValue();
                if (Double.isNaN(tmpValues[collisionIdx])) {
                    throw new IllegalArgumentException("Example contained a NaN feature, " + f.toString());
                }
                ++i;
                continue;
            }
            int n = collisionIdx;
            tmpValues[n] = tmpValues[n] + f.getValue();
            if (!Double.isNaN(tmpValues[collisionIdx])) continue;
            throw new IllegalArgumentException("Example contained a NaN feature, " + f.toString());
        }
        if (addBias) {
            tmpIndices[i] = size - 1;
            tmpValues[i] = 1.0;
            ++i;
        }
        return new SparseVector(size, Arrays.copyOf(tmpIndices, i), Arrays.copyOf(tmpValues, i));
    }

    public static SparseVector createSparseVector(int dimension, int[] indices, double[] values) {
        if (indices.length != values.length) {
            throw new IllegalArgumentException("Indices and values must be the same length, found indices.length = " + indices.length + " and values.length = " + values.length);
        }
        if (indices.length == 0) {
            return new SparseVector(dimension, indices, values);
        }
        IntDoublePair[] pairArray = new IntDoublePair[indices.length];
        for (int i = 0; i < pairArray.length; ++i) {
            pairArray[i] = new IntDoublePair(indices[i], values[i]);
        }
        Arrays.sort(pairArray, IntDoublePair.pairIndexComparator());
        int[] newIndices = new int[indices.length];
        double[] newValues = new double[values.length];
        for (int i = 0; i < pairArray.length; ++i) {
            newIndices[i] = pairArray[i].index;
            newValues[i] = pairArray[i].value;
        }
        if (dimension < newIndices[newIndices.length - 1]) {
            throw new IllegalArgumentException("Number of dimensions is less than the maximum index, dimensions = " + dimension + ", max index = " + newIndices[newIndices.length - 1]);
        }
        return new SparseVector(dimension, newIndices, newValues);
    }

    public static SparseVector createSparseVector(int dimension, Map<Integer, Double> indexMap) {
        if (indexMap.isEmpty()) {
            return new SparseVector(dimension, new int[0], new double[0]);
        }
        List sortedEntries = indexMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        int[] indices = new int[sortedEntries.size()];
        double[] values = new double[sortedEntries.size()];
        for (int i = 0; i < sortedEntries.size(); ++i) {
            indices[i] = (Integer)((Map.Entry)sortedEntries.get(i)).getKey();
            values[i] = (Double)((Map.Entry)sortedEntries.get(i)).getValue();
        }
        if (dimension < indices[indices.length - 1]) {
            throw new IllegalArgumentException("Number of dimensions is less than the maximum index, dimensions = " + dimension + ", max index = " + indices[indices.length - 1]);
        }
        return new SparseVector(dimension, indices, values);
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this);
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public Tensor reshape(int[] newShape) {
        throw new UnsupportedOperationException("Reshape not supported on sparse Tensors.");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int numActiveElements() {
        return this.values.length;
    }

    public boolean equals(Object other) {
        if (other instanceof SGDVector) {
            VectorIterator ourItr = this.iterator();
            Iterator otherItr = ((SGDVector)other).iterator();
            while (ourItr.hasNext() && otherItr.hasNext()) {
                VectorTuple otherTuple;
                VectorTuple ourTuple = (VectorTuple)ourItr.next();
                if (ourTuple.equals(otherTuple = (VectorTuple)otherItr.next())) continue;
                return false;
            }
            return !ourItr.hasNext() && !otherItr.hasNext();
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.size);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    public SGDVector add(SGDVector other) {
        if (other.size() != this.size) {
            throw new IllegalArgumentException("Can't add two vectors of different dimension, this = " + this.size + ", other = " + other.size());
        }
        if (other instanceof DenseVector) {
            return other.add(this);
        }
        if (other instanceof SparseVector) {
            HashMap<Integer, Double> values = new HashMap<Integer, Double>();
            for (VectorTuple tuple : this) {
                values.put(tuple.index, tuple.value);
            }
            for (VectorTuple tuple : other) {
                values.merge(tuple.index, tuple.value, Double::sum);
            }
            return SparseVector.createSparseVector(this.size, values);
        }
        throw new IllegalArgumentException("Vector other is not dense or sparse.");
    }

    @Override
    public SGDVector subtract(SGDVector other) {
        if (other.size() != this.size) {
            throw new IllegalArgumentException("Can't subtract two vectors of different dimension, this = " + this.size + ", other = " + other.size());
        }
        if (other instanceof DenseVector) {
            DenseVector output = ((DenseVector)other).copy();
            for (VectorTuple tuple : this) {
                output.set(tuple.index, tuple.value - output.get(tuple.index));
            }
            return output;
        }
        if (other instanceof SparseVector) {
            HashMap<Integer, Double> values = new HashMap<Integer, Double>();
            for (VectorTuple tuple : this) {
                values.put(tuple.index, tuple.value);
            }
            for (VectorTuple tuple : other) {
                values.merge(tuple.index, -tuple.value, Double::sum);
            }
            return SparseVector.createSparseVector(this.size, values);
        }
        throw new IllegalArgumentException("Vector other is not dense or sparse.");
    }

    @Override
    public void intersectAndAddInPlace(Tensor other, DoubleUnaryOperator f) {
        if (other instanceof SparseVector) {
            SparseVector otherVec = (SparseVector)other;
            if (otherVec.size() != this.size) {
                throw new IllegalArgumentException("Can't intersect two vectors of different dimension, this = " + this.size + ", other = " + otherVec.size());
            }
            if (otherVec.numActiveElements() > 0) {
                int i = 0;
                VectorIterator otherItr = otherVec.iterator();
                VectorTuple tuple = (VectorTuple)otherItr.next();
                while (i < this.indices.length - 1 && otherItr.hasNext()) {
                    if (this.indices[i] == tuple.index) {
                        int n = i++;
                        this.values[n] = this.values[n] + f.applyAsDouble(tuple.value);
                        tuple = (VectorTuple)otherItr.next();
                        continue;
                    }
                    if (this.indices[i] < tuple.index) {
                        ++i;
                        continue;
                    }
                    tuple = (VectorTuple)otherItr.next();
                }
                while (i < this.indices.length - 1) {
                    if (this.indices[i] == tuple.index) {
                        int n = i;
                        this.values[n] = this.values[n] + f.applyAsDouble(tuple.value);
                    }
                    ++i;
                }
                while (otherItr.hasNext()) {
                    if (this.indices[i] == tuple.index) {
                        int n = i;
                        this.values[n] = this.values[n] + f.applyAsDouble(tuple.value);
                    }
                    tuple = (VectorTuple)otherItr.next();
                }
                if (this.indices[i] == tuple.index) {
                    int n = i;
                    this.values[n] = this.values[n] + f.applyAsDouble(tuple.value);
                }
            }
        } else if (other instanceof DenseVector) {
            DenseVector otherVec = (DenseVector)other;
            if (otherVec.size() != this.size) {
                throw new IllegalArgumentException("Can't intersect two vectors of different dimension, this = " + this.size + ", other = " + otherVec.size());
            }
            for (int i = 0; i < this.indices.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] + f.applyAsDouble(otherVec.get(this.indices[i]));
            }
        } else {
            throw new IllegalStateException("Unknown Tensor subclass " + other.getClass().getCanonicalName() + " for input");
        }
    }

    @Override
    public void hadamardProductInPlace(Tensor other, DoubleUnaryOperator f) {
        if (other instanceof SparseVector) {
            SparseVector otherVec = (SparseVector)other;
            if (otherVec.size() != this.size) {
                throw new IllegalArgumentException("Can't hadamard product two vectors of different dimension, this = " + this.size + ", other = " + otherVec.size());
            }
            if (otherVec.numActiveElements() > 0) {
                int i = 0;
                VectorIterator otherItr = otherVec.iterator();
                VectorTuple tuple = (VectorTuple)otherItr.next();
                while (i < this.indices.length - 1 && otherItr.hasNext()) {
                    if (this.indices[i] == tuple.index) {
                        int n = i++;
                        this.values[n] = this.values[n] * f.applyAsDouble(tuple.value);
                        tuple = (VectorTuple)otherItr.next();
                        continue;
                    }
                    if (this.indices[i] < tuple.index) {
                        ++i;
                        continue;
                    }
                    tuple = (VectorTuple)otherItr.next();
                }
                while (i < this.indices.length - 1) {
                    if (this.indices[i] == tuple.index) {
                        int n = i;
                        this.values[n] = this.values[n] * f.applyAsDouble(tuple.value);
                    }
                    ++i;
                }
                while (otherItr.hasNext()) {
                    if (this.indices[i] == tuple.index) {
                        int n = i;
                        this.values[n] = this.values[n] * f.applyAsDouble(tuple.value);
                    }
                    tuple = (VectorTuple)otherItr.next();
                }
                if (this.indices[i] == tuple.index) {
                    int n = i;
                    this.values[n] = this.values[n] * f.applyAsDouble(tuple.value);
                }
            }
        } else if (other instanceof DenseVector) {
            DenseVector otherVec = (DenseVector)other;
            if (otherVec.size() != this.size) {
                throw new IllegalArgumentException("Can't hadamard product two vectors of different dimension, this = " + this.size + ", other = " + otherVec.size());
            }
            for (int i = 0; i < this.indices.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] * f.applyAsDouble(otherVec.get(this.indices[i]));
            }
        } else {
            throw new IllegalArgumentException("Invalid Tensor subclass " + other.getClass().getCanonicalName() + " for input");
        }
    }

    @Override
    public void foreachInPlace(DoubleUnaryOperator f) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = f.applyAsDouble(this.values[i]);
        }
    }

    @Override
    public void foreachIndexedInPlace(ToDoubleBiFunction<Integer, Double> f) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = f.applyAsDouble(this.indices[i], this.values[i]);
        }
    }

    @Override
    public SparseVector scale(double coefficient) {
        double[] newValues = Arrays.copyOf(this.values, this.values.length);
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            newValues[n] = newValues[n] * coefficient;
        }
        return new SparseVector(this.size, Arrays.copyOf(this.indices, this.indices.length), newValues);
    }

    @Override
    public void add(int index, double value) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        if (foundIndex < 0) {
            throw new IllegalArgumentException("SparseVector cannot have new elements added.");
        }
        int n = foundIndex;
        this.values[n] = this.values[n] + value;
    }

    @Override
    public double dot(SGDVector other) {
        if (other.size() != this.size) {
            throw new IllegalArgumentException("Can't dot two vectors of different lengths, this = " + this.size + ", other = " + other.size());
        }
        if (other instanceof SparseVector) {
            double score = 0.0;
            if (other.numActiveElements() != 0 && this.indices.length != 0) {
                VectorIterator itr = this.iterator();
                Iterator otherItr = other.iterator();
                VectorTuple tuple = (VectorTuple)itr.next();
                VectorTuple otherTuple = (VectorTuple)otherItr.next();
                while (itr.hasNext() && otherItr.hasNext()) {
                    if (tuple.index == otherTuple.index) {
                        score += tuple.value * otherTuple.value;
                        tuple = (VectorTuple)itr.next();
                        otherTuple = (VectorTuple)otherItr.next();
                        continue;
                    }
                    if (tuple.index < otherTuple.index) {
                        tuple = (VectorTuple)itr.next();
                        continue;
                    }
                    otherTuple = (VectorTuple)otherItr.next();
                }
                while (itr.hasNext()) {
                    if (tuple.index == otherTuple.index) {
                        score += tuple.value * otherTuple.value;
                    }
                    tuple = (VectorTuple)itr.next();
                }
                while (otherItr.hasNext()) {
                    if (tuple.index == otherTuple.index) {
                        score += tuple.value * otherTuple.value;
                    }
                    otherTuple = (VectorTuple)otherItr.next();
                }
                if (tuple.index == otherTuple.index) {
                    score += tuple.value * otherTuple.value;
                }
            }
            return score;
        }
        if (other instanceof DenseVector) {
            double score = 0.0;
            for (int i = 0; i < this.indices.length; ++i) {
                score += other.get(this.indices[i]) * this.values[i];
            }
            return score;
        }
        throw new IllegalArgumentException("Unknown vector subclass " + other.getClass().getCanonicalName() + " for input");
    }

    @Override
    public Matrix outer(SGDVector other) {
        if (other instanceof SparseVector) {
            SparseVector otherVec = (SparseVector)other;
            SparseVector[] output = new SparseVector[this.size];
            int i = 0;
            for (VectorTuple tuple : this) {
                while (i < tuple.index) {
                    output[i] = new SparseVector(other.size(), new int[0], new double[0]);
                    ++i;
                }
                output[tuple.index] = otherVec.scale(tuple.value);
                ++i;
            }
            while (i < output.length) {
                output[i] = new SparseVector(other.size(), new int[0], new double[0]);
                ++i;
            }
            return new DenseSparseMatrix(output);
        }
        if (other instanceof DenseVector) {
            DenseVector otherVec = (DenseVector)other;
            int otherSize = otherVec.size();
            double[][] output = new double[this.size][];
            int i = 0;
            for (VectorTuple tuple : this) {
                while (i < tuple.index) {
                    output[i] = new double[otherSize];
                    ++i;
                }
                DenseVector tmp = otherVec.scale(tuple.value);
                output[tuple.index] = tmp.elements;
                ++i;
            }
            while (i < output.length) {
                output[i] = new double[otherSize];
                ++i;
            }
            return new DenseMatrix(output);
        }
        throw new IllegalArgumentException("Unknown vector subclass " + other.getClass().getCanonicalName() + " for input");
    }

    @Override
    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            sum += this.values[i];
        }
        return sum;
    }

    @Override
    public double twoNorm() {
        double sum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            sum += this.values[i] * this.values[i];
        }
        return Math.sqrt(sum);
    }

    @Override
    public double oneNorm() {
        double sum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            sum += Math.abs(this.values[i]);
        }
        return sum;
    }

    @Override
    public double get(int index) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        if (foundIndex < 0) {
            return 0.0;
        }
        return this.values[foundIndex];
    }

    @Override
    public void set(int index, double value) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        if (foundIndex < 0) {
            throw new IllegalArgumentException("SparseVector cannot have new elements added.");
        }
        this.values[foundIndex] = value;
    }

    @Override
    public int indexOfMax() {
        int index = 0;
        double value = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.values.length; ++i) {
            double tmp = this.values[i];
            if (!(tmp > value)) continue;
            index = i;
            value = tmp;
        }
        return this.indices[index];
    }

    @Override
    public double maxValue() {
        double value = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.values.length; ++i) {
            double tmp = this.values[i];
            if (!(tmp > value)) continue;
            value = tmp;
        }
        return value;
    }

    @Override
    public double minValue() {
        double value = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.values.length; ++i) {
            double tmp = this.values[i];
            if (!(tmp < value)) continue;
            value = tmp;
        }
        return value;
    }

    public int[] difference(SparseVector other) {
        ArrayList<Integer> diffIndicesList = new ArrayList<Integer>();
        if (other.numActiveElements() == 0) {
            return Arrays.copyOf(this.indices, this.indices.length);
        }
        if (this.indices.length == 0) {
            return new int[0];
        }
        VectorIterator itr = this.iterator();
        VectorIterator otherItr = other.iterator();
        VectorTuple tuple = (VectorTuple)itr.next();
        VectorTuple otherTuple = (VectorTuple)otherItr.next();
        while (itr.hasNext() && otherItr.hasNext()) {
            if (tuple.index == otherTuple.index) {
                tuple = (VectorTuple)itr.next();
                otherTuple = (VectorTuple)otherItr.next();
                continue;
            }
            if (tuple.index < otherTuple.index) {
                diffIndicesList.add(tuple.index);
                tuple = (VectorTuple)itr.next();
                continue;
            }
            otherTuple = (VectorTuple)otherItr.next();
        }
        while (itr.hasNext()) {
            if (tuple.index != otherTuple.index) {
                diffIndicesList.add(tuple.index);
            }
            tuple = (VectorTuple)itr.next();
        }
        while (otherItr.hasNext() && tuple.index != otherTuple.index) {
            otherTuple = (VectorTuple)otherItr.next();
        }
        if (tuple.index != otherTuple.index) {
            diffIndicesList.add(tuple.index);
        }
        return Util.toPrimitiveInt(diffIndicesList);
    }

    public int[] intersection(SparseVector other) {
        ArrayList<Integer> diffIndicesList = new ArrayList<Integer>();
        VectorIterator itr = this.iterator();
        VectorIterator otherItr = other.iterator();
        if (itr.hasNext() && otherItr.hasNext()) {
            VectorTuple tuple = (VectorTuple)itr.next();
            VectorTuple otherTuple = (VectorTuple)otherItr.next();
            while (itr.hasNext() && otherItr.hasNext()) {
                if (tuple.index == otherTuple.index) {
                    diffIndicesList.add(tuple.index);
                    tuple = (VectorTuple)itr.next();
                    otherTuple = (VectorTuple)otherItr.next();
                    continue;
                }
                if (tuple.index < otherTuple.index) {
                    tuple = (VectorTuple)itr.next();
                    continue;
                }
                otherTuple = (VectorTuple)otherItr.next();
            }
            while (itr.hasNext()) {
                if (tuple.index == otherTuple.index) {
                    diffIndicesList.add(tuple.index);
                }
                tuple = (VectorTuple)itr.next();
            }
            while (otherItr.hasNext()) {
                if (tuple.index == otherTuple.index) {
                    diffIndicesList.add(tuple.index);
                }
                otherTuple = (VectorTuple)otherItr.next();
            }
            if (tuple.index == otherTuple.index) {
                diffIndicesList.add(tuple.index);
            }
        }
        return Util.toPrimitiveInt(diffIndicesList);
    }

    @Override
    public void normalize(VectorNormalizer normalizer) {
        throw new UnsupportedOperationException("Can't normalize a sparse array");
    }

    @Override
    public double reduce(double initial, DoubleUnaryOperator transform, DoubleBinaryOperator reduction) {
        double output = initial;
        double transformedZero = transform.applyAsDouble(0.0);
        int i = 0;
        for (VectorTuple tuple : this) {
            while (i < tuple.index) {
                output = reduction.applyAsDouble(transformedZero, output);
                ++i;
            }
            double transformed = transform.applyAsDouble(tuple.value);
            output = reduction.applyAsDouble(transformed, output);
            ++i;
        }
        while (i < this.size) {
            output = reduction.applyAsDouble(transformedZero, output);
            ++i;
        }
        return output;
    }

    @Override
    public double euclideanDistance(SGDVector other) {
        return this.distance(other, a -> a * a, Math::sqrt);
    }

    @Override
    public double l1Distance(SGDVector other) {
        return this.distance(other, Math::abs, DoubleUnaryOperator.identity());
    }

    public double distance(SGDVector other, DoubleUnaryOperator transformFunc, DoubleUnaryOperator normalizeFunc) {
        double score;
        block17: {
            block15: {
                VectorTuple otherTuple;
                VectorTuple tuple;
                block16: {
                    if (other.size() != this.size) {
                        throw new IllegalArgumentException("Can't measure the distance between two vectors of different lengths, this = " + this.size + ", other = " + other.size());
                    }
                    score = 0.0;
                    if (other.numActiveElements() == 0 || this.indices.length == 0) break block15;
                    VectorIterator itr = this.iterator();
                    Iterator otherItr = other.iterator();
                    tuple = (VectorTuple)itr.next();
                    otherTuple = (VectorTuple)otherItr.next();
                    while (itr.hasNext() && otherItr.hasNext()) {
                        if (tuple.index == otherTuple.index) {
                            score += transformFunc.applyAsDouble(tuple.value - otherTuple.value);
                            tuple = (VectorTuple)itr.next();
                            otherTuple = (VectorTuple)otherItr.next();
                            continue;
                        }
                        if (tuple.index < otherTuple.index) {
                            score += transformFunc.applyAsDouble(tuple.value);
                            tuple = (VectorTuple)itr.next();
                            continue;
                        }
                        score += transformFunc.applyAsDouble(otherTuple.value);
                        otherTuple = (VectorTuple)otherItr.next();
                    }
                    while (itr.hasNext()) {
                        if (tuple.index == otherTuple.index) {
                            score += transformFunc.applyAsDouble(tuple.value - otherTuple.value);
                            otherTuple = new VectorTuple();
                        } else {
                            score += transformFunc.applyAsDouble(tuple.value);
                        }
                        tuple = (VectorTuple)itr.next();
                    }
                    while (otherItr.hasNext()) {
                        if (tuple.index == otherTuple.index) {
                            score += transformFunc.applyAsDouble(tuple.value - otherTuple.value);
                            tuple = new VectorTuple();
                        } else {
                            score += transformFunc.applyAsDouble(otherTuple.value);
                        }
                        otherTuple = (VectorTuple)otherItr.next();
                    }
                    if (tuple.index != otherTuple.index) break block16;
                    score += transformFunc.applyAsDouble(tuple.value - otherTuple.value);
                    break block17;
                }
                if (tuple.index != -1) {
                    score += transformFunc.applyAsDouble(tuple.value);
                }
                if (otherTuple.index == -1) break block17;
                score += transformFunc.applyAsDouble(otherTuple.value);
                break block17;
            }
            if (this.indices.length != 0) {
                for (VectorTuple tuple : this) {
                    score += transformFunc.applyAsDouble(tuple.value);
                }
            } else {
                for (VectorTuple tuple : other) {
                    score += transformFunc.applyAsDouble(tuple.value);
                }
            }
        }
        return normalizeFunc.applyAsDouble(score);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SparseVector(size=");
        buffer.append(this.size);
        buffer.append(",tuples=");
        for (int i = 0; i < this.indices.length; ++i) {
            buffer.append("[");
            buffer.append(this.indices[i]);
            buffer.append(",");
            buffer.append(this.values[i]);
            buffer.append("],");
        }
        buffer.setCharAt(buffer.length() - 1, ')');
        return buffer.toString();
    }

    public DenseVector densify() {
        return new DenseVector(this.toArray());
    }

    @Deprecated
    public double[] toDenseArray() {
        return this.toArray();
    }

    @Override
    public double[] toArray() {
        double[] output = new double[this.size];
        for (int i = 0; i < this.values.length; ++i) {
            output[this.indices[i]] = this.values[i];
        }
        return output;
    }

    @Override
    public double variance(double mean) {
        double variance = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            variance += (this.values[i] - mean) * (this.values[i] - mean);
        }
        return variance += (double)(this.size - this.values.length) * mean * mean;
    }

    public VectorIterator iterator() {
        return new SparseVectorIterator(this);
    }

    public static SparseVector[] transpose(SparseVector[] input) {
        int i;
        int firstDimension = input.length;
        int secondDimension = input[0].size;
        ArrayList indices = new ArrayList();
        ArrayList values = new ArrayList();
        for (i = 0; i < secondDimension; ++i) {
            indices.add(new ArrayList());
            values.add(new ArrayList());
        }
        for (i = 0; i < firstDimension; ++i) {
            for (VectorTuple f : input[i]) {
                ((ArrayList)indices.get(f.index)).add(i);
                ((ArrayList)values.get(f.index)).add(f.value);
            }
        }
        SparseVector[] output = new SparseVector[secondDimension];
        for (int i2 = 0; i2 < secondDimension; ++i2) {
            output[i2] = new SparseVector(firstDimension, Util.toPrimitiveInt((List)((List)indices.get(i2))), Util.toPrimitiveDouble((List)((List)values.get(i2))));
        }
        return output;
    }

    public static <T extends Output<T>> SparseVector[] transpose(Dataset<T> dataset) {
        ImmutableFeatureMap fMap = dataset.getFeatureIDMap();
        return SparseVector.transpose(dataset, fMap);
    }

    public static <T extends Output<T>> SparseVector[] transpose(Dataset<T> dataset, ImmutableFeatureMap fMap) {
        if (dataset.getFeatureMap().size() != fMap.size()) {
            throw new IllegalArgumentException("The dataset's internal feature map and the supplied feature map have different sizes. dataset = " + dataset.getFeatureMap().size() + ", fMap = " + fMap.size());
        }
        int numExamples = dataset.size();
        int numFeatures = fMap.size();
        ArrayList indices = new ArrayList();
        ArrayList values = new ArrayList();
        for (int i = 0; i < numFeatures; ++i) {
            indices.add(new ArrayList());
            values.add(new ArrayList());
        }
        int j = 0;
        for (Example e : dataset) {
            for (Feature f : e) {
                int index = fMap.getID(f.getName());
                ((ArrayList)indices.get(index)).add(j);
                ((ArrayList)values.get(index)).add(f.getValue());
            }
            ++j;
        }
        SparseVector[] output = new SparseVector[numFeatures];
        for (int i = 0; i < fMap.size(); ++i) {
            output[i] = new SparseVector(numExamples, Util.toPrimitiveInt((List)((List)indices.get(i))), Util.toPrimitiveDouble((List)((List)values.get(i))));
        }
        return output;
    }

    private static class SparseVectorIterator
    implements VectorIterator {
        private final SparseVector vector;
        private final VectorTuple tuple;
        private int index;

        public SparseVectorIterator(SparseVector vector) {
            this.vector = vector;
            this.tuple = new VectorTuple();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.vector.indices.length;
        }

        @Override
        public VectorTuple next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Off the end of the iterator.");
            }
            this.tuple.index = this.vector.indices[this.index];
            this.tuple.value = this.vector.values[this.index];
            ++this.index;
            return this.tuple;
        }

        @Override
        public VectorTuple getReference() {
            return this.tuple;
        }
    }
}

