/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RouteServerPersistRoutesAction;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteServerRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateRouteServerRequest> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AmazonSideAsn").getter(CreateRouteServerRequest.getter(CreateRouteServerRequest::amazonSideAsn)).setter(CreateRouteServerRequest.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").unmarshallLocationName("AmazonSideAsn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateRouteServerRequest.getter(CreateRouteServerRequest::clientToken)).setter(CreateRouteServerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateRouteServerRequest.getter(CreateRouteServerRequest::dryRun)).setter(CreateRouteServerRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> PERSIST_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersistRoutes").getter(CreateRouteServerRequest.getter(CreateRouteServerRequest::persistRoutesAsString)).setter(CreateRouteServerRequest.setter(Builder::persistRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutes").unmarshallLocationName("PersistRoutes").build()}).build();
    private static final SdkField<Long> PERSIST_ROUTES_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PersistRoutesDuration").getter(CreateRouteServerRequest.getter(CreateRouteServerRequest::persistRoutesDuration)).setter(CreateRouteServerRequest.setter(Builder::persistRoutesDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutesDuration").unmarshallLocationName("PersistRoutesDuration").build()}).build();
    private static final SdkField<Boolean> SNS_NOTIFICATIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SnsNotificationsEnabled").getter(CreateRouteServerRequest.getter(CreateRouteServerRequest::snsNotificationsEnabled)).setter(CreateRouteServerRequest.setter(Builder::snsNotificationsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsNotificationsEnabled").unmarshallLocationName("SnsNotificationsEnabled").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateRouteServerRequest.getter(CreateRouteServerRequest::tagSpecifications)).setter(CreateRouteServerRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, PERSIST_ROUTES_FIELD, PERSIST_ROUTES_DURATION_FIELD, SNS_NOTIFICATIONS_ENABLED_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRouteServerRequest.memberNameToFieldInitializer();
    private final Long amazonSideAsn;
    private final String clientToken;
    private final Boolean dryRun;
    private final String persistRoutes;
    private final Long persistRoutesDuration;
    private final Boolean snsNotificationsEnabled;
    private final List<TagSpecification> tagSpecifications;

    private CreateRouteServerRequest(BuilderImpl builder) {
        super(builder);
        this.amazonSideAsn = builder.amazonSideAsn;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.persistRoutes = builder.persistRoutes;
        this.persistRoutesDuration = builder.persistRoutesDuration;
        this.snsNotificationsEnabled = builder.snsNotificationsEnabled;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final RouteServerPersistRoutesAction persistRoutes() {
        return RouteServerPersistRoutesAction.fromValue(this.persistRoutes);
    }

    public final String persistRoutesAsString() {
        return this.persistRoutes;
    }

    public final Long persistRoutesDuration() {
        return this.persistRoutesDuration;
    }

    public final Boolean snsNotificationsEnabled() {
        return this.snsNotificationsEnabled;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistRoutesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistRoutesDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteServerRequest)) {
            return false;
        }
        CreateRouteServerRequest other = (CreateRouteServerRequest)((Object)obj);
        return Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.persistRoutesAsString(), other.persistRoutesAsString()) && Objects.equals(this.persistRoutesDuration(), other.persistRoutesDuration()) && Objects.equals(this.snsNotificationsEnabled(), other.snsNotificationsEnabled()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRouteServerRequest").add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("PersistRoutes", (Object)this.persistRoutesAsString()).add("PersistRoutesDuration", (Object)this.persistRoutesDuration()).add("SnsNotificationsEnabled", (Object)this.snsNotificationsEnabled()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "PersistRoutes": {
                return Optional.ofNullable(clazz.cast(this.persistRoutesAsString()));
            }
            case "PersistRoutesDuration": {
                return Optional.ofNullable(clazz.cast(this.persistRoutesDuration()));
            }
            case "SnsNotificationsEnabled": {
                return Optional.ofNullable(clazz.cast(this.snsNotificationsEnabled()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AmazonSideAsn", AMAZON_SIDE_ASN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PersistRoutes", PERSIST_ROUTES_FIELD);
        map.put("PersistRoutesDuration", PERSIST_ROUTES_DURATION_FIELD);
        map.put("SnsNotificationsEnabled", SNS_NOTIFICATIONS_ENABLED_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteServerRequest, T> g) {
        return obj -> g.apply((CreateRouteServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Long amazonSideAsn;
        private String clientToken;
        private Boolean dryRun;
        private String persistRoutes;
        private Long persistRoutesDuration;
        private Boolean snsNotificationsEnabled;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteServerRequest model) {
            super(model);
            this.amazonSideAsn(model.amazonSideAsn);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.persistRoutes(model.persistRoutes);
            this.persistRoutesDuration(model.persistRoutesDuration);
            this.snsNotificationsEnabled(model.snsNotificationsEnabled);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getPersistRoutes() {
            return this.persistRoutes;
        }

        public final void setPersistRoutes(String persistRoutes) {
            this.persistRoutes = persistRoutes;
        }

        @Override
        public final Builder persistRoutes(String persistRoutes) {
            this.persistRoutes = persistRoutes;
            return this;
        }

        @Override
        public final Builder persistRoutes(RouteServerPersistRoutesAction persistRoutes) {
            this.persistRoutes(persistRoutes == null ? null : persistRoutes.toString());
            return this;
        }

        public final Long getPersistRoutesDuration() {
            return this.persistRoutesDuration;
        }

        public final void setPersistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
        }

        @Override
        public final Builder persistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
            return this;
        }

        public final Boolean getSnsNotificationsEnabled() {
            return this.snsNotificationsEnabled;
        }

        public final void setSnsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
        }

        @Override
        public final Builder snsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteServerRequest build() {
            return new CreateRouteServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteServerRequest> {
        public Builder amazonSideAsn(Long var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder persistRoutes(String var1);

        public Builder persistRoutes(RouteServerPersistRoutesAction var1);

        public Builder persistRoutesDuration(Long var1);

        public Builder snsNotificationsEnabled(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

