/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.monitor.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opensearch.sql.monitor.profile.ProfilePlanNodeMetrics;
import org.opensearch.sql.monitor.profile.ProfileUtils;
import org.opensearch.sql.monitor.profile.QueryProfile;

public final class ProfilePlanNode {
    private final String nodeName;
    private final List<ProfilePlanNode> children;
    private final ProfilePlanNodeMetrics metrics = new ProfilePlanNodeMetrics();

    public ProfilePlanNode(String nodeName, List<ProfilePlanNode> children) {
        this.nodeName = Objects.requireNonNull(nodeName, "nodeName");
        this.children = List.copyOf((Collection)Objects.requireNonNull(children, "children"));
    }

    public ProfilePlanNodeMetrics metrics() {
        return this.metrics;
    }

    public QueryProfile.PlanNode snapshot() {
        ArrayList<QueryProfile.PlanNode> snapshotChildren = new ArrayList<QueryProfile.PlanNode>();
        for (ProfilePlanNode child : this.children) {
            snapshotChildren.add(child.snapshot());
        }
        List<QueryProfile.PlanNode> outputChildren = snapshotChildren.isEmpty() ? null : List.copyOf(snapshotChildren);
        return new QueryProfile.PlanNode(this.nodeName, ProfileUtils.roundToMillis(this.metrics.timeNanos()), this.metrics.rows(), outputChildren);
    }
}

