/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf;

import java.math.BigInteger;
import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.function.Strict;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class ToNumberFunction
extends ImplementorUDF {
    public ToNumberFunction() {
        super(new ToNumberImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.DOUBLE_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.STRING_OR_STRING_INTEGER;
    }

    @Strict
    public static Number toNumber(String numStr) {
        return ToNumberFunction.toNumber(numStr, 10);
    }

    @Strict
    public static Number toNumber(String numStr, int base) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("Base has to be between 2 and 36.");
        }
        Number result = null;
        try {
            if (base == 10) {
                result = numStr.contains(".") ? (Number)Double.parseDouble(numStr) : (Number)Long.parseLong(numStr);
            } else {
                BigInteger bigInteger = new BigInteger(numStr, base);
                result = bigInteger.longValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static class ToNumberImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression fieldValue = translatedOperands.get(0);
            int base = 10;
            if (translatedOperands.size() > 1) {
                Expression baseExpr = translatedOperands.get(1);
                return Expressions.call(ToNumberFunction.class, (String)"toNumber", (Expression[])new Expression[]{fieldValue, baseExpr});
            }
            return Expressions.call(ToNumberFunction.class, (String)"toNumber", (Expression[])new Expression[]{fieldValue});
        }
    }
}

