/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.openide.util.RequestProcessor;

public final class DelayScanRegistry {
    private final WeakHashMap<RequestProcessor.Task, DelayedScan> registry = new WeakHashMap(5);
    private static DelayScanRegistry instance;
    private static final int MAX_WAITING_TIME = 180000;
    private static final int WAITING_PERIOD = 10000;
    private static final boolean BLOCK_INDEFINITELY;
    private static final boolean DELAY_SCAN;

    public static synchronized DelayScanRegistry getInstance() {
        if (instance == null) {
            instance = new DelayScanRegistry();
        }
        return instance;
    }

    private DelayScanRegistry() {
    }

    public boolean isDelayed(RequestProcessor.Task task, Logger logger, String logMessagePrefix) {
        DelayedScan scan = this.getRegisteredScan(task);
        Future projectOpenTask = OpenProjects.getDefault().openProjects();
        if (!projectOpenTask.isDone()) {
            try {
                projectOpenTask.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DELAY_SCAN && IndexingBridge.getInstance().isIndexingInProgress() && (BLOCK_INDEFINITELY || scan.waitingLoops * 10000 < 180000)) {
            Level level = ++scan.waitingLoops < 10 ? Level.FINE : Level.INFO;
            logger.log(level, "{0}: Scanning in progress, trying again in {1}ms", new Object[]{logMessagePrefix, 10000});
            task.schedule(10000);
            return true;
        }
        scan.waitingLoops = 0;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelayedScan getRegisteredScan(RequestProcessor.Task task) {
        WeakHashMap<RequestProcessor.Task, DelayedScan> weakHashMap = this.registry;
        synchronized (weakHashMap) {
            return this.registry.computeIfAbsent(task, k -> new DelayedScan());
        }
    }

    static {
        BLOCK_INDEFINITELY = Boolean.getBoolean("versioning.delayscan.nolimit");
        DELAY_SCAN = Boolean.getBoolean("versioning.delayscan");
    }

    private static class DelayedScan {
        private int waitingLoops;

        private DelayedScan() {
        }
    }
}

