/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.BufferUtil;
import io.fabric8.kubernetes.client.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ByteArrayBodyHandler
implements AsyncBody.Consumer<List<ByteBuffer>> {
    private final List<ByteBuffer> buffers = Collections.synchronizedList(new LinkedList());
    private final CompletableFuture<byte[]> result = new CompletableFuture();

    @Override
    public void consume(List<ByteBuffer> value, AsyncBody asyncBody) throws Exception {
        this.buffers.addAll(value);
        asyncBody.consume();
    }

    protected void onResponse(HttpResponse<AsyncBody> response) {
        AsyncBody asyncBody = response.body();
        asyncBody.done().whenComplete(this::onBodyDone);
        asyncBody.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBodyDone(Void v, Throwable t) {
        if (t != null) {
            this.result.completeExceptionally(t);
        } else {
            byte[] bytes = null;
            List<ByteBuffer> list = this.buffers;
            synchronized (list) {
                bytes = BufferUtil.toArray(this.buffers);
            }
            this.result.complete(bytes);
        }
        this.buffers.clear();
    }

    public CompletableFuture<byte[]> getResult() {
        return this.result;
    }
}

