/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.libraries;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Bundle;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Dependency;
import org.netbeans.modules.javascript.nodejs.ui.libraries.EditPanel;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Library;
import org.netbeans.modules.javascript.nodejs.ui.libraries.LibraryProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SearchPanel
extends JPanel {
    private final Listener listener = new Listener();
    private String lastSearchTerm;
    private boolean lastSearchInNames;
    private final LibraryProvider libraryProvider;
    private JButton addButton;
    private JButton cancelButton;
    private JLabel descriptionComponent;
    private JLabel descriptionLabel;
    private EditPanel editPanel;
    private JLabel keywordsComponent;
    private JLabel keywordsLabel;
    private JLabel librariesLabel;
    private JList<Library> librariesList;
    private JLabel messageLabel;
    private JScrollPane scrollPane;
    private JButton searchButton;
    private JTextField searchField;
    private JCheckBox searchInNamesCheckBox;
    private JLabel searchLabel;
    private JPanel searchPanel;

    public SearchPanel(LibraryProvider libraryProvider) {
        this.libraryProvider = libraryProvider;
        this.initComponents();
        this.editPanel.setLibraryProvider(libraryProvider);
        this.librariesList.setCellRenderer(new LibraryRenderer());
        this.updateLibraries(new Library[0]);
        this.librarySelected(null);
    }

    final void activate() {
        this.libraryProvider.addPropertyChangeListener(this.listener);
    }

    final void deactivate() {
        this.libraryProvider.removePropertyChangeListener(this.listener);
    }

    String getSelectedLibrary() {
        Library library = this.librariesList.getSelectedValue();
        return library == null ? null : library.getName();
    }

    String getRequiredVersion() {
        return this.editPanel.getRequiredVersion();
    }

    String getInstalledVersion() {
        return this.editPanel.getInstalledVersion();
    }

    private void startSearch() {
        this.librarySelected(null);
        this.lastSearchTerm = this.searchField.getText().trim();
        this.lastSearchInNames = this.searchInNamesCheckBox.isSelected();
        Library[] libraries = this.libraryProvider.findLibraries(this.lastSearchTerm);
        if (libraries == null) {
            this.messageLabel.setText(Bundle.SearchPanel_message_searching(this.lastSearchTerm));
            this.showComponent(this.messageLabel);
        } else {
            if (this.lastSearchInNames) {
                libraries = this.filterByName(libraries, this.lastSearchTerm);
            }
            this.updateLibraries(libraries);
        }
    }

    private void showComponent(JComponent component) {
        if (component.getParent() == null) {
            JComponent shownComponent = component == this.messageLabel ? this.searchPanel : this.messageLabel;
            ((GroupLayout)this.getLayout()).replace(shownComponent, component);
        }
    }

    final void updateLibraries(Library[] libraries) {
        if (libraries == null) {
            this.messageLabel.setText(Bundle.SearchPanel_message_searchFailed());
            this.showComponent(this.messageLabel);
        } else if (libraries.length == 0) {
            this.messageLabel.setText(NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.messageLabel.text"));
            this.showComponent(this.messageLabel);
        } else {
            this.librariesList.setModel(this.libraryListModelFor(libraries));
            this.librariesList.setSelectedIndex(0);
            this.showComponent(this.searchPanel);
            this.librariesList.requestFocusInWindow();
        }
    }

    private ListModel<Library> libraryListModelFor(Library[] libraries) {
        DefaultListModel<Library> listModel = new DefaultListModel<Library>();
        if (libraries != null) {
            for (Library library : libraries) {
                listModel.addElement(library);
            }
        }
        return listModel;
    }

    private void librarySelected(Library library) {
        boolean emptySelection = library == null;
        String description = null;
        String keywords = null;
        if (!emptySelection) {
            if (!library.getDescription().isEmpty()) {
                description = "<html>" + library.getDescription();
            }
            if (library.getKeywords().length > 0) {
                StringBuilder keywordsText = new StringBuilder("<html>");
                for (String keyword : library.getKeywords()) {
                    keywordsText.append(keyword).append(" ");
                }
                keywords = keywordsText.toString();
            }
            Dependency dependency = new Dependency(library.getName());
            Library.Version latestVersion = library.getLatestVersion();
            if (latestVersion != null) {
                String versionName = latestVersion.getName();
                dependency.setInstalledVersion(versionName);
                dependency.setRequiredVersion(versionName);
            }
            this.editPanel.setDependency(dependency);
        }
        this.descriptionComponent.setText(description);
        this.keywordsComponent.setText(keywords);
        this.descriptionComponent.setVisible(description != null);
        this.keywordsLabel.setVisible(keywords != null);
        this.editPanel.setVisible(!emptySelection);
        this.addButton.setEnabled(!emptySelection);
    }

    JButton getAddButton() {
        return this.addButton;
    }

    JButton getCancelButton() {
        return this.cancelButton;
    }

    Library[] filterByName(Library[] libraries, String searchTerm) {
        ArrayList<Library> list = new ArrayList<Library>();
        for (Library library : libraries) {
            if (!library.getName().contains(searchTerm)) continue;
            list.add(library);
        }
        return list.toArray(new Library[0]);
    }

    private void initComponents() {
        this.searchPanel = new JPanel();
        this.librariesLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.librariesList = new JList();
        this.descriptionLabel = new JLabel();
        this.descriptionComponent = new JLabel();
        this.keywordsLabel = new JLabel();
        this.keywordsComponent = new JLabel();
        this.editPanel = new EditPanel();
        this.addButton = new JButton();
        this.cancelButton = new JButton();
        this.searchLabel = new JLabel();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.messageLabel = new JLabel();
        this.searchInNamesCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.librariesLabel.text"));
        this.librariesList.setSelectionMode(0);
        this.librariesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SearchPanel.this.librariesListValueChanged(evt);
            }
        });
        this.scrollPane.setViewportView(this.librariesList);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.descriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.keywordsLabel.text"));
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -2, 250, -2).addComponent(this.librariesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionComponent, -1, -1, Short.MAX_VALUE).addComponent(this.keywordsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.keywordsComponent, -1, -1, Short.MAX_VALUE).addComponent(this.editPanel, -1, -1, Short.MAX_VALUE))));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.librariesLabel).addComponent(this.descriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.descriptionComponent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.keywordsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keywordsComponent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.editPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addGap(0, 0, 0)));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.addButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.cancelButton.text"));
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchLabel.text"));
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.searchFieldActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.searchButtonActionPerformed(evt);
            }
        });
        this.messageLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.messageLabel.text"));
        this.messageLabel.setEnabled(false);
        this.searchInNamesCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.searchInNamesCheckBox, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchInNamesCheckBox.text"));
        this.searchInNamesCheckBox.setToolTipText(NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchInNamesCheckBox.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, 550, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.searchInNamesCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.searchField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchLabel).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchInNamesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageLabel, -1, 350, Short.MAX_VALUE).addContainerGap()));
    }

    private void searchFieldActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void librariesListValueChanged(ListSelectionEvent evt) {
        Library library = this.librariesList.getSelectedValue();
        this.librarySelected(library);
    }

    class Listener
    implements PropertyChangeListener {
        Listener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    String searchTerm = evt.getPropertyName();
                    if (searchTerm.equals(this.this$1.SearchPanel.this.lastSearchTerm)) {
                        Library[] libraries = (Library[])evt.getNewValue();
                        if (this.this$1.SearchPanel.this.lastSearchInNames && libraries != null) {
                            libraries = this.this$1.SearchPanel.this.filterByName(libraries, this.this$1.SearchPanel.this.lastSearchTerm);
                        }
                        this.this$1.SearchPanel.this.updateLibraries(libraries);
                    }
                }
            });
        }
    }

    static class LibraryRenderer
    extends DefaultListCellRenderer {
        LibraryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Library) {
                Library library = (Library)value;
                value = library.getName();
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

