/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.j2seplatform.queries.SourceJavadocAttacherUtil;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class SelectRootsPanel
extends JPanel
implements ActionListener {
    static final int SOURCES = 0;
    static final int JAVADOC = 1;
    private static final RequestProcessor RP = new RequestProcessor(SelectRootsPanel.class);
    private final int mode;
    private final URL root;
    private final Callable<List<? extends String>> browseCall;
    private final SourceJavadocAttacherUtil.Function<String, Collection<? extends URI>> convertor;
    private final Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins;
    private volatile DownloadService downloadService;
    private JButton add;
    private JButton addURL;
    private JLabel attachTo;
    private JButton down;
    private JButton download;
    private JScrollPane jScrollPane1;
    private JLabel lblSources;
    private JButton remove;
    private JList<URI> sources;
    private JButton up;

    SelectRootsPanel(int mode, @NonNull URL root, @NonNull List<? extends URI> attachedRoots, @NonNull Callable<List<? extends String>> browseCall, @NonNull SourceJavadocAttacherUtil.Function<String, Collection<? extends URI>> convertor, @NullAllowed Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins) {
        assert ((mode & 0xFFFFFFFE) == 0);
        assert (root != null);
        assert (browseCall != null);
        assert (convertor != null);
        this.mode = mode;
        this.root = root;
        this.browseCall = browseCall;
        this.convertor = convertor;
        this.plugins = plugins;
        this.initComponents();
        DefaultListModel<URI> model = new DefaultListModel<URI>();
        this.sources.setModel(model);
        this.sources.setCellRenderer(new RootRenderer());
        this.sources.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectRootsPanel.this.enableSelectionSensitiveActions();
            }
        });
        for (URI uRI : attachedRoots) {
            model.addElement(uRI);
        }
        this.addURL.setVisible(mode != 0);
        if (plugins != null && !plugins.isEmpty()) {
            this.download.setVisible(true);
            if (plugins.size() == 1) {
                this.download.setToolTipText(plugins.iterator().next().getDescription());
            }
        } else {
            this.download.setVisible(false);
        }
        this.enableSelectionSensitiveActions();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DownloadService cs = this.downloadService;
        if (cs != null) {
            cs.cancel();
        }
    }

    @CheckForNull
    List<? extends URI> getRoots() throws Exception {
        DefaultListModel lm = (DefaultListModel)this.sources.getModel();
        return Collections.unmodifiableList(Collections.list(lm.elements()));
    }

    private void initComponents() {
        this.attachTo = new JLabel();
        this.lblSources = new JLabel();
        this.add = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sources = new JList();
        this.remove = new JButton();
        this.up = new JButton();
        this.down = new JButton();
        this.addURL = new JButton();
        this.download = new JButton();
        this.attachTo.setText(this.getDescription());
        this.lblSources.setLabelFor(this.sources);
        Mnemonics.setLocalizedText((JLabel)this.lblSources, (String)this.getLabel());
        Mnemonics.setLocalizedText((AbstractButton)this.add, (String)NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_Browse"));
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectRootsPanel.this.browse(evt);
            }
        });
        this.sources.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.sources);
        Mnemonics.setLocalizedText((AbstractButton)this.remove, (String)NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_Remove"));
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectRootsPanel.this.remove(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.up, (String)NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_MoveUp"));
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectRootsPanel.this.moveUp(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.down, (String)NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_MoveDown"));
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectRootsPanel.this.moveDown(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addURL, (String)NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_AddURL"));
        this.addURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectRootsPanel.this.addURL(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.download, (String)NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_Download"));
        this.download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectRootsPanel.this.download(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attachTo).addComponent(this.lblSources)).addGap(0, 131, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remove, -1, -1, Short.MAX_VALUE).addComponent(this.add, -1, -1, Short.MAX_VALUE).addComponent(this.down, -1, -1, Short.MAX_VALUE).addComponent(this.up, -1, -1, Short.MAX_VALUE).addComponent(this.addURL, -1, -1, Short.MAX_VALUE).addComponent(this.download, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.attachTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSources).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.add).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addURL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.download).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.up).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.down).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 239, Short.MAX_VALUE).addGap(20, 20, 20)))));
    }

    private void browse(ActionEvent evt) {
        try {
            ArrayList<Integer> added = new ArrayList<Integer>();
            List<? extends String> paths = this.browseCall.call();
            if (paths != null) {
                DefaultListModel lm = (DefaultListModel)this.sources.getModel();
                HashSet contained = new HashSet(Collections.list(lm.elements()));
                int index = this.sources.getSelectedIndex();
                index = index < 0 ? lm.getSize() : index + 1;
                for (String string : paths) {
                    for (URI uRI : this.convertor.call(string)) {
                        if (contained.contains(uRI)) continue;
                        lm.add(index, uRI);
                        added.add(index);
                        ++index;
                    }
                }
            }
            this.select(added);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void remove(ActionEvent evt) {
        DefaultListModel lm = (DefaultListModel)this.sources.getModel();
        int[] index = this.sources.getSelectedIndices();
        for (int i = index.length - 1; i >= 0; --i) {
            lm.remove(index[i]);
        }
    }

    private void moveUp(ActionEvent evt) {
        DefaultListModel lm = (DefaultListModel)this.sources.getModel();
        int[] index = this.sources.getSelectedIndices();
        int i = 0;
        while (i < index.length) {
            URI toMove = (URI)lm.remove(index[i]);
            lm.add(index[i] - 1, toMove);
            int n = i++;
            index[n] = index[n] - 1;
        }
        this.sources.setSelectedIndices(index);
    }

    private void moveDown(ActionEvent evt) {
        DefaultListModel lm = (DefaultListModel)this.sources.getModel();
        int[] index = this.sources.getSelectedIndices();
        int i = index.length - 1;
        while (i >= 0) {
            URI toMove = (URI)lm.remove(index[i]);
            lm.add(index[i] + 1, toMove);
            int n = i--;
            index[n] = index[n] + 1;
        }
        this.sources.setSelectedIndices(index);
    }

    private void addURL(ActionEvent evt) {
        NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_RemoteJavadoc"), NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_RemoteJavadoc_Title"), 2, -1);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
            String inputText = nd.getInputText();
            DefaultListModel lm = (DefaultListModel)this.sources.getModel();
            HashSet contained = new HashSet(Collections.list(lm.elements()));
            int index = this.sources.getSelectedIndex();
            index = index < 0 ? lm.getSize() : index + 1;
            try {
                URI uri = new URI(inputText);
                if (!contained.contains(uri)) {
                    lm.add(index, uri);
                    this.select(Collections.singleton(index));
                    ++index;
                }
            }
            catch (URISyntaxException ex) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_InvalidRoot", (Object)inputText), 0));
            }
        }
    }

    private void download(ActionEvent evt) {
        DownloadService dn;
        assert (this.plugins != null);
        this.enableDownloadAction(false);
        this.downloadService = dn = new DownloadService(this.plugins, this.root, this.mode == 0);
        dn.runAsync(resFin -> Mutex.EVENT.writeAccess(new Runnable(){
            final /* synthetic */ List val$resFin;
            final /* synthetic */ SelectRootsPanel this$0;
            {
                this.val$resFin = list;
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean finished = false;
                try {
                    finished = dn.call() == false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (finished) {
                        if (this.val$resFin.isEmpty()) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SelectRootsPanel.class, (String)(this.this$0.mode == 0 ? "ERR_DownloadSourcesFailed" : "ERR_DownloadJavadocFailed"), (Object)SelectRootsPanel.getDisplayName(this.this$0.root)), 1));
                        } else {
                            DefaultListModel lm = (DefaultListModel)this.this$0.sources.getModel();
                            HashSet contained = new HashSet(Collections.list(lm.elements()));
                            int index = this.this$0.sources.getSelectedIndex();
                            index = index < 0 ? lm.getSize() : index + 1;
                            ArrayList<Integer> added = new ArrayList<Integer>();
                            for (URI uri : this.val$resFin) {
                                if (contained.contains(uri)) continue;
                                lm.add(index, uri);
                                added.add(index);
                                ++index;
                            }
                            this.this$0.select(added);
                        }
                    }
                }
                finally {
                    this.this$0.downloadService = null;
                    this.this$0.enableDownloadAction(true);
                    this.this$0.enableSelectionSensitiveActions();
                }
            }
        }));
    }

    private void enableSelectionSensitiveActions() {
        int[] indices = this.sources.getSelectedIndices();
        this.remove.setEnabled(indices.length > 0);
        this.up.setEnabled(indices.length > 0 && indices[0] != 0);
        this.down.setEnabled(indices.length > 0 && indices[indices.length - 1] != this.sources.getModel().getSize() - 1);
    }

    private void enableDownloadAction(boolean enable) {
        this.download.setEnabled(enable);
    }

    private void select(@NonNull Collection<? extends Integer> toSelect) {
        int[] indexes = new int[toSelect.size()];
        Iterator<? extends Integer> it = toSelect.iterator();
        int i = 0;
        while (it.hasNext()) {
            indexes[i] = it.next();
            ++i;
        }
        this.sources.setSelectedIndices(indexes);
    }

    @NonNull
    private String getDescription() {
        String displayName = SelectRootsPanel.getDisplayName(this.root);
        switch (this.mode) {
            case 0: {
                return NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_AttachSourcesTo", (Object)displayName);
            }
            case 1: {
                return NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_AttachJavadocTo", (Object)displayName);
            }
        }
        throw new IllegalStateException(Integer.toString(this.mode));
    }

    @NonNull
    private static String getDisplayName(@NonNull URL root) {
        File f = FileUtil.archiveOrDirForURL((URL)root);
        return f == null ? root.toString() : (f.isFile() ? f.getName() : f.getAbsolutePath());
    }

    @NonNull
    private String getLabel() {
        switch (this.mode) {
            case 0: {
                return NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_LocalSources");
            }
            case 1: {
                return NbBundle.getMessage(SelectRootsPanel.class, (String)"TXT_LocalJavadoc");
            }
        }
        throw new IllegalStateException(Integer.toString(this.mode));
    }

    private static class DownloadService
    extends SourceJavadocAttacherUtil.Downloader {
        public DownloadService(Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins, URL root, boolean source) {
            super(plugins, root, source);
        }
    }

    private static class RootRenderer
    extends DefaultListCellRenderer {
        private RootRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            URI uri;
            if (value instanceof URI && (uri = (URI)value).isAbsolute()) {
                try {
                    URL url = uri.toURL();
                    String offset = null;
                    if ("jar".equals(url.getProtocol())) {
                        String surl = url.toExternalForm();
                        int offsetPos = surl.lastIndexOf("!/");
                        if (offsetPos > 0 && offsetPos < surl.length() - 3) {
                            offset = surl.substring(offsetPos + 2);
                        }
                        url = FileUtil.getArchiveFile((URL)url);
                    }
                    if ("file".equals(url.getProtocol())) {
                        File file = Utilities.toFile((URI)url.toURI());
                        value = offset == null ? file.getAbsolutePath() : NbBundle.getMessage(SelectRootsPanel.class, (String)"PATTERN_RELPATH_IN_FILE", offset, (Object)file.getAbsolutePath());
                    }
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

