/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.CopyBootVolumeBackupDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CopyBootVolumeBackupRequest
extends BmcRequest<CopyBootVolumeBackupDetails> {
    private String bootVolumeBackupId;
    private CopyBootVolumeBackupDetails copyBootVolumeBackupDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getBootVolumeBackupId() {
        return this.bootVolumeBackupId;
    }

    public CopyBootVolumeBackupDetails getCopyBootVolumeBackupDetails() {
        return this.copyBootVolumeBackupDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CopyBootVolumeBackupDetails getBody$() {
        return this.copyBootVolumeBackupDetails;
    }

    public Builder toBuilder() {
        return new Builder().bootVolumeBackupId(this.bootVolumeBackupId).copyBootVolumeBackupDetails(this.copyBootVolumeBackupDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bootVolumeBackupId=").append(String.valueOf(this.bootVolumeBackupId));
        sb.append(",copyBootVolumeBackupDetails=").append(String.valueOf((Object)this.copyBootVolumeBackupDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CopyBootVolumeBackupRequest)) {
            return false;
        }
        CopyBootVolumeBackupRequest other = (CopyBootVolumeBackupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bootVolumeBackupId, other.bootVolumeBackupId) && Objects.equals((Object)this.copyBootVolumeBackupDetails, (Object)other.copyBootVolumeBackupDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bootVolumeBackupId == null ? 43 : this.bootVolumeBackupId.hashCode());
        result = result * 59 + (this.copyBootVolumeBackupDetails == null ? 43 : this.copyBootVolumeBackupDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CopyBootVolumeBackupRequest, CopyBootVolumeBackupDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bootVolumeBackupId = null;
        private CopyBootVolumeBackupDetails copyBootVolumeBackupDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder bootVolumeBackupId(String bootVolumeBackupId) {
            this.bootVolumeBackupId = bootVolumeBackupId;
            return this;
        }

        public Builder copyBootVolumeBackupDetails(CopyBootVolumeBackupDetails copyBootVolumeBackupDetails) {
            this.copyBootVolumeBackupDetails = copyBootVolumeBackupDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CopyBootVolumeBackupRequest o) {
            this.bootVolumeBackupId(o.getBootVolumeBackupId());
            this.copyBootVolumeBackupDetails(o.getCopyBootVolumeBackupDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CopyBootVolumeBackupRequest build() {
            CopyBootVolumeBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CopyBootVolumeBackupDetails body) {
            this.copyBootVolumeBackupDetails(body);
            return this;
        }

        public CopyBootVolumeBackupRequest buildWithoutInvocationCallback() {
            CopyBootVolumeBackupRequest request = new CopyBootVolumeBackupRequest();
            request.bootVolumeBackupId = this.bootVolumeBackupId;
            request.copyBootVolumeBackupDetails = this.copyBootVolumeBackupDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

