/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.threading;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.threading.Bundle;
import org.netbeans.modules.java.hints.threading.Tiny;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class UnlockOutsideFinally {
    public static ErrorDescription unlockInsideTry(HintContext ctx) {
        TreePath tPath;
        TreePath fin = (TreePath)ctx.getVariables().get("$lock$1");
        if (fin == null) {
            return null;
        }
        TreePath parent = fin.getParentPath();
        if (parent.getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        if ((parent = parent.getParentPath()) == null || parent.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        for (tPath = parent.getParentPath(); tPath != null && tPath.getLeaf().getKind() != Tree.Kind.TRY; tPath = tPath.getParentPath()) {
            if (tPath.getLeaf().getKind() != Tree.Kind.METHOD && tPath.getLeaf().getKind() != Tree.Kind.CLASS) continue;
            return null;
        }
        if (tPath == null) {
            return null;
        }
        TryTree tt = (TryTree)tPath.getLeaf();
        Fix f = null;
        String displayName = null;
        if (tt.getFinallyBlock() != null) {
            TreePath finBlockPath = new TreePath(tPath, tt.getFinallyBlock());
            Collection occ = Matcher.create((CompilationInfo)ctx.getInfo()).setSearchRoot(finBlockPath).match(Pattern.createSimplePattern((TreePath)parent));
            if (!occ.isEmpty()) {
                f = new MoveUnlockFix(TreePathHandle.create((TreePath)parent, (CompilationInfo)ctx.getInfo()), null).toEditorFix();
                displayName = Bundle.MSG_ExtraUnlock();
            }
        }
        if (f == null) {
            displayName = Bundle.ERR_UnlockOutsideTryFinally();
            f = new MoveUnlockFix(TreePathHandle.create((TreePath)parent, (CompilationInfo)ctx.getInfo()), TreePathHandle.create((TreePath)tPath, (CompilationInfo)ctx.getInfo())).toEditorFix();
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)parent, (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription unlockOutsideTryFinally(HintContext ctx) {
        Tree mark;
        if (((Collection)ctx.getMultiVariables().get("$statements$")).isEmpty()) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_UnlockOutsideTryFinally");
        String lockString = ctx.getVariables().containsKey("$lock") ? "$lock." : "";
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)(lockString + "lock(); try {$statements$;} finally {" + lockString + "unlock();}"));
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_UnlockOutsideTryFinally");
        Tree matched = ctx.getPath().getLeaf();
        if (matched.getKind() == Tree.Kind.BLOCK) {
            List<? extends StatementTree> s = ((BlockTree)matched).getStatements();
            int count = ((Collection)ctx.getMultiVariables().get("$$1$")).size();
            mark = s.get(count);
        } else {
            mark = matched;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)mark, (String)displayName, (Fix[])new Fix[]{f});
    }

    private static class MoveUnlockFix
    extends JavaFix {
        private TreePathHandle finHandle;

        public MoveUnlockFix(TreePathHandle handle, TreePathHandle finHandle) {
            super(handle);
            this.finHandle = finHandle;
        }

        protected String getText() {
            return this.finHandle == null ? Bundle.FIX_RemoveRedundantUnlock() : Bundle.FIX_MoveUnlockToFinally();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath finPath = null;
            if (this.finHandle != null && (finPath = this.finHandle.resolve((CompilationInfo)ctx.getWorkingCopy())) == null) {
                return;
            }
            WorkingCopy wc = ctx.getWorkingCopy();
            TreeMaker mk = wc.getTreeMaker();
            TreePath p = ctx.getPath();
            if (!StatementTree.class.isAssignableFrom(p.getLeaf().getKind().asInterface())) {
                if (p.getParentPath() != null && p.getParentPath().getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                    p = p.getParentPath();
                } else {
                    return;
                }
            }
            Utilities.removeStatement(wc, p);
            if (finPath != null) {
                Utilities.insertStatement(wc, finPath, null, Collections.singletonList((StatementTree)p.getLeaf()), null, 0);
            }
        }
    }
}

