/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.ComputePerformanceSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemComputePerformanceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="computePerformanceList")
    private final List<ComputePerformanceSummary> computePerformanceList;

    @Deprecated
    @ConstructorProperties(value={"shape", "computePerformanceList"})
    public DbSystemComputePerformanceSummary(String shape, List<ComputePerformanceSummary> computePerformanceList) {
        this.shape = shape;
        this.computePerformanceList = computePerformanceList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getShape() {
        return this.shape;
    }

    public List<ComputePerformanceSummary> getComputePerformanceList() {
        return this.computePerformanceList;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystemComputePerformanceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("shape=").append(String.valueOf(this.shape));
        sb.append(", computePerformanceList=").append(String.valueOf(this.computePerformanceList));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystemComputePerformanceSummary)) {
            return false;
        }
        DbSystemComputePerformanceSummary other = (DbSystemComputePerformanceSummary)((Object)o);
        return Objects.equals(this.shape, other.shape) && Objects.equals(this.computePerformanceList, other.computePerformanceList) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.computePerformanceList == null ? 43 : this.computePerformanceList.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="computePerformanceList")
        private List<ComputePerformanceSummary> computePerformanceList;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder computePerformanceList(List<ComputePerformanceSummary> computePerformanceList) {
            this.computePerformanceList = computePerformanceList;
            this.__explicitlySet__.add("computePerformanceList");
            return this;
        }

        public DbSystemComputePerformanceSummary build() {
            DbSystemComputePerformanceSummary model = new DbSystemComputePerformanceSummary(this.shape, this.computePerformanceList);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystemComputePerformanceSummary model) {
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("computePerformanceList")) {
                this.computePerformanceList(model.getComputePerformanceList());
            }
            return this;
        }
    }
}

