/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackupDestinationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="vpcUser")
    private final String vpcUser;
    @JsonProperty(value="vpcPassword")
    private final String vpcPassword;
    @JsonProperty(value="internetProxy")
    private final String internetProxy;
    @JsonProperty(value="dbrsPolicyId")
    private final String dbrsPolicyId;

    @Deprecated
    @ConstructorProperties(value={"type", "id", "vpcUser", "vpcPassword", "internetProxy", "dbrsPolicyId"})
    public BackupDestinationDetails(Type type, String id, String vpcUser, String vpcPassword, String internetProxy, String dbrsPolicyId) {
        this.type = type;
        this.id = id;
        this.vpcUser = vpcUser;
        this.vpcPassword = vpcPassword;
        this.internetProxy = internetProxy;
        this.dbrsPolicyId = dbrsPolicyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getVpcUser() {
        return this.vpcUser;
    }

    public String getVpcPassword() {
        return this.vpcPassword;
    }

    public String getInternetProxy() {
        return this.internetProxy;
    }

    public String getDbrsPolicyId() {
        return this.dbrsPolicyId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackupDestinationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf((Object)this.type));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", vpcUser=").append(String.valueOf(this.vpcUser));
        sb.append(", vpcPassword=").append(String.valueOf(this.vpcPassword));
        sb.append(", internetProxy=").append(String.valueOf(this.internetProxy));
        sb.append(", dbrsPolicyId=").append(String.valueOf(this.dbrsPolicyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupDestinationDetails)) {
            return false;
        }
        BackupDestinationDetails other = (BackupDestinationDetails)((Object)o);
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.id, other.id) && Objects.equals(this.vpcUser, other.vpcUser) && Objects.equals(this.vpcPassword, other.vpcPassword) && Objects.equals(this.internetProxy, other.internetProxy) && Objects.equals(this.dbrsPolicyId, other.dbrsPolicyId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.vpcUser == null ? 43 : this.vpcUser.hashCode());
        result = result * 59 + (this.vpcPassword == null ? 43 : this.vpcPassword.hashCode());
        result = result * 59 + (this.internetProxy == null ? 43 : this.internetProxy.hashCode());
        result = result * 59 + (this.dbrsPolicyId == null ? 43 : this.dbrsPolicyId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Nfs("NFS"),
        RecoveryAppliance("RECOVERY_APPLIANCE"),
        ObjectStore("OBJECT_STORE"),
        Local("LOCAL"),
        Dbrs("DBRS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="vpcUser")
        private String vpcUser;
        @JsonProperty(value="vpcPassword")
        private String vpcPassword;
        @JsonProperty(value="internetProxy")
        private String internetProxy;
        @JsonProperty(value="dbrsPolicyId")
        private String dbrsPolicyId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder vpcUser(String vpcUser) {
            this.vpcUser = vpcUser;
            this.__explicitlySet__.add("vpcUser");
            return this;
        }

        public Builder vpcPassword(String vpcPassword) {
            this.vpcPassword = vpcPassword;
            this.__explicitlySet__.add("vpcPassword");
            return this;
        }

        public Builder internetProxy(String internetProxy) {
            this.internetProxy = internetProxy;
            this.__explicitlySet__.add("internetProxy");
            return this;
        }

        public Builder dbrsPolicyId(String dbrsPolicyId) {
            this.dbrsPolicyId = dbrsPolicyId;
            this.__explicitlySet__.add("dbrsPolicyId");
            return this;
        }

        public BackupDestinationDetails build() {
            BackupDestinationDetails model = new BackupDestinationDetails(this.type, this.id, this.vpcUser, this.vpcPassword, this.internetProxy, this.dbrsPolicyId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackupDestinationDetails model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("vpcUser")) {
                this.vpcUser(model.getVpcUser());
            }
            if (model.wasPropertyExplicitlySet("vpcPassword")) {
                this.vpcPassword(model.getVpcPassword());
            }
            if (model.wasPropertyExplicitlySet("internetProxy")) {
                this.internetProxy(model.getInternetProxy());
            }
            if (model.wasPropertyExplicitlySet("dbrsPolicyId")) {
                this.dbrsPolicyId(model.getDbrsPolicyId());
            }
            return this;
        }
    }
}

