/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.primefaces;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.JsfComponentUtils;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.modules.web.primefaces.Bundle;
import org.netbeans.modules.web.primefaces.PrimefacesCustomizer;
import org.netbeans.modules.web.primefaces.PrimefacesProvider;
import org.netbeans.modules.web.primefaces.ui.PrimefacesCustomizerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class PrimefacesImplementation
implements JsfComponentImplementation {
    private PrimefacesCustomizer customizer;
    public static final String PRIMEFACES_NAME = "PrimeFaces";
    private static final String MAVEN_PF_REPO = "default:http://repository.primefaces.org/";
    private static final String MAVEN_PF_DEP = "org.primefaces:primefaces:5.0:jar";
    private static final Logger LOGGER = Logger.getLogger(PrimefacesImplementation.class.getName());
    private static final String PRIMEFACES_SPECIFIC_PRIME_RESOURCE = "org.primefaces.application.PrimeResource";
    private static final String PRIMEFACES_SPECIFIC_PRIME_RESOURCE_HANDLER = "org.primefaces.application.PrimeResourceHandler";
    private static final String PREFERENCES_NODE = "primefaces";
    private static final String POM_PROPERTIES_PATH = "META-INF/maven/org.primefaces/primefaces/pom.properties";
    public static final String PROP_PREFERRED_LIBRARY = "preferred-library";

    public String getName() {
        return PRIMEFACES_NAME;
    }

    public String getDisplayName() {
        return Bundle.PrimefacesImplementation_primefaces_display_name();
    }

    public String getDescription() {
        return NbBundle.getMessage(PrimefacesProvider.class, (String)"LBL_PrimeFaces_Description");
    }

    public Set<FileObject> extend(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        PrimefacesImplementation.extendClasspath(webModule, jsfComponentCustomizer);
        try {
            FileObject welcomePage = PrimefacesImplementation.generateWelcomePage(webModule);
            return Collections.singleton(welcomePage);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during creating welcome page and extending index", ex);
            return Collections.emptySet();
        }
    }

    public Set<JsfVersion> getJsfVersion() {
        return EnumSet.of(JsfVersion.JSF_2_0, JsfVersion.JSF_2_1, JsfVersion.JSF_2_2);
    }

    public boolean isInWebModule(WebModule webModule) {
        ClassPath classpath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        return this.hasPrimeFacesResource(classpath);
    }

    private boolean hasPrimeFacesResource(ClassPath classPath) {
        return classPath.findResource(PRIMEFACES_SPECIFIC_PRIME_RESOURCE.replace('.', '/') + ".class") != null || classPath.findResource(PRIMEFACES_SPECIFIC_PRIME_RESOURCE_HANDLER.replace('.', '/') + ".class") != null;
    }

    public JsfComponentCustomizer createJsfComponentCustomizer(WebModule webModule) {
        if (this.customizer == null) {
            this.customizer = new PrimefacesCustomizer();
        }
        return this.customizer;
    }

    public void remove(WebModule webModule) {
        try {
            List<Library> primefacesLibraries = JsfComponentUtils.isMavenBased((WebModule)webModule) ? Arrays.asList(PrimefacesImplementation.getMavenLibrary()) : PrimefacesImplementation.getAllRegisteredPrimefaces();
            ProjectClassPathModifier.removeLibraries((Library[])primefacesLibraries.toArray(new Library[0]), (FileObject)webModule.getJavaSources()[0], (String)"classpath/compile");
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", ex);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", ex);
        }
    }

    private static void extendClasspath(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        try {
            Library primefacesLibrary;
            if (JsfComponentUtils.isMavenBased((WebModule)webModule)) {
                primefacesLibrary = PrimefacesImplementation.getMavenLibrary();
            } else {
                primefacesLibrary = PrimefacesImplementation.getPreferredLibrary(jsfComponentCustomizer);
                if (primefacesLibrary == null) {
                    LOGGER.log(Level.SEVERE, "No PrimeFaces library found.");
                }
            }
            FileObject[] javaSources = webModule.getJavaSources();
            ProjectClassPathModifier.addLibraries((Library[])new Library[]{primefacesLibrary}, (FileObject)javaSources[0], (String)"classpath/compile");
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", ex);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", ex);
        }
    }

    private static Library getMavenLibrary() {
        return JsfComponentUtils.createMavenDependencyLibrary((String)"PrimeFaces-maven-lib", (String[])new String[]{MAVEN_PF_DEP}, (String[])new String[]{MAVEN_PF_REPO});
    }

    public static List<Library> getAllRegisteredPrimefaces() {
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List content;
            if (!"j2se".equals(library.getType()) || !PrimefacesImplementation.isValidPrimefacesLibrary(content = library.getContent("classpath"))) continue;
            libraries.add(library);
        }
        return libraries;
    }

    public static boolean isValidPrimefacesLibrary(List<URL> libraryContent) {
        try {
            return ClasspathUtil.containsClass(libraryContent, (String)PRIMEFACES_SPECIFIC_PRIME_RESOURCE) || ClasspathUtil.containsClass(libraryContent, (String)PRIMEFACES_SPECIFIC_PRIME_RESOURCE_HANDLER);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return false;
        }
    }

    public static Preferences getPrimefacesPreferences() {
        return NbPreferences.forModule(PrimefacesImplementation.class).node(PREFERENCES_NODE);
    }

    private static List<URI> getPomURIs(Library library) {
        String baseUri = "http://repository.primefaces.org/org/primefaces/primefaces/<VERSION>/primefaces-<VERSION>.pom";
        String versionItem = "version=";
        LinkedList<URI> poms = new LinkedList<URI>();
        for (URI uri : library.getURIContent("classpath")) {
            try {
                URL archiveFileURL = FileUtil.getArchiveFile((URL)uri.toURL());
                JarFileSystem jsf = new JarFileSystem(new File(archiveFileURL.toURI()));
                FileObject resource = jsf.findResource(POM_PROPERTIES_PATH);
                if (resource == null) continue;
                String propertiesText = resource.asText();
                int indexOfVersion = propertiesText.indexOf(versionItem);
                String version = propertiesText.substring(indexOfVersion + versionItem.length());
                version = version.substring(0, version.indexOf("\n"));
                poms.add(new URI(baseUri.replace("<VERSION>", version.trim())));
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.WARNING, "Primefaces version wasn't parsed", ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Primefaces version wasn't parsed", ex);
            }
        }
        return poms;
    }

    private static Library getPreferredLibrary(JsfComponentCustomizer jsfComponentCustomizer) {
        PrimefacesCustomizerPanel panel;
        Library libarary;
        if (jsfComponentCustomizer != null && (libarary = (panel = (PrimefacesCustomizerPanel)jsfComponentCustomizer.getComponent()).getPrimefacesLibrary()) != null) {
            return LibraryManager.getDefault().getLibrary(libarary.getName());
        }
        Library primefacesLibrary = LibraryManager.getDefault().getLibrary(PrimefacesImplementation.getPrimefacesPreferences().get(PROP_PREFERRED_LIBRARY, ""));
        if (primefacesLibrary != null) {
            return primefacesLibrary;
        }
        return PrimefacesImplementation.getAllRegisteredPrimefaces().get(0);
    }

    private static FileObject generateWelcomePage(WebModule webModule) throws IOException {
        FileObject templateFO = FileUtil.getConfigFile((String)"Templates/Other/welcomePrimefaces.xhtml");
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataObject generated = templateDO.createFromTemplate(DataFolder.findFolder((FileObject)webModule.getDocumentBase()), "welcomePrimefaces");
        JsfComponentUtils.reformat((DataObject)generated);
        PrimefacesImplementation.updateIndexPage(webModule);
        return generated.getPrimaryFile();
    }

    private static void updateIndexPage(WebModule webModule) throws DataObjectNotFoundException {
        FileObject indexFO = webModule.getDocumentBase().getFileObject("index.xhtml");
        if (indexFO == null || !indexFO.isValid() || !indexFO.canWrite()) {
            return;
        }
        DataObject indexDO = DataObject.find((FileObject)indexFO);
        JsfComponentUtils.enhanceFileBody((DataObject)indexDO, (String)"</h:body>", (String)("<br />\n<h:link outcome=\"welcomePrimefaces\" value=\"" + Bundle.PrimefacesImplementation_index_welcome_primefaces_lbl() + "\" />"));
        JsfComponentUtils.reformat((DataObject)indexDO);
    }
}

