/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class PickOrCreateFieldPanel
extends JPanel {
    private Object[] availableFields;
    private DefaultComboBoxModel mdlAvailableFields = new DefaultComboBoxModel();
    private FieldNameValidator nameValidator = null;
    private Border brdrBlack = BorderFactory.createLineBorder(Color.BLACK);
    private DialogDescriptor dlgDescriptor = null;
    private FileObject fileObject;
    private NotificationLineSupport notSupport;
    private JButton btnFindType;
    private ButtonGroup buttonGroup1;
    private JLabel lblName;
    private JLabel lblType;
    private JComboBox lstExistingFields;
    private JRadioButton radioCreateNewField;
    private JRadioButton radioPickUpExistingField;
    private JTextField txtNewFieldName;
    private JTextField txtType;

    public PickOrCreateFieldPanel() {
        this.initComponents();
        this.radioPickUpExistingField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean pickUpExisting = PickOrCreateFieldPanel.this.radioPickUpExistingField.isSelected();
                PickOrCreateFieldPanel.this.lstExistingFields.setEnabled(pickUpExisting);
                PickOrCreateFieldPanel.this.btnFindType.setEnabled(!PickOrCreateFieldPanel.this.radioPickUpExistingField.isSelected());
                PickOrCreateFieldPanel.this.txtNewFieldName.setEnabled(!PickOrCreateFieldPanel.this.radioPickUpExistingField.isSelected());
                PickOrCreateFieldPanel.this.txtType.setEnabled(!PickOrCreateFieldPanel.this.radioPickUpExistingField.isSelected());
            }
        });
        this.lstExistingFields.setModel(this.mdlAvailableFields);
        this.txtNewFieldName.setSelectionEnd(this.txtNewFieldName.getText().length() - 1);
        this.txtNewFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                NameStatus nameStatus = NameStatus.VALID;
                if (PickOrCreateFieldPanel.this.nameValidator != null) {
                    nameStatus = PickOrCreateFieldPanel.this.nameValidator.checkName(PickOrCreateFieldPanel.this.getNewIdName());
                }
                PickOrCreateFieldPanel.this.setFieldNameStatus(nameStatus);
            }
        });
        this.setNameValidator(new DefaultFieldNameValidator());
        this.setFieldNameStatus(NameStatus.VALID);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.radioPickUpExistingField = new JRadioButton();
        this.lstExistingFields = new JComboBox();
        this.radioCreateNewField = new JRadioButton();
        this.lblName = new JLabel();
        this.txtNewFieldName = new JTextField();
        this.lblType = new JLabel();
        this.txtType = new JTextField();
        this.btnFindType = new JButton();
        this.buttonGroup1.add(this.radioPickUpExistingField);
        this.radioPickUpExistingField.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/jpa/verification/fixes/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.radioPickUpExistingField, (String)bundle.getString("LBL_PickExistingField"));
        this.radioPickUpExistingField.setMargin(new Insets(0, 0, 0, 0));
        this.lstExistingFields.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonGroup1.add(this.radioCreateNewField);
        Mnemonics.setLocalizedText((AbstractButton)this.radioCreateNewField, (String)bundle.getString("LBL_CreateNewField"));
        this.radioCreateNewField.setMargin(new Insets(0, 0, 0, 0));
        this.lblName.setLabelFor(this.txtNewFieldName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)bundle.getString("LBL_FieldName"));
        this.txtNewFieldName.setText(NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"PickOrCreateFieldPanel.txtNewFieldName.text"));
        this.txtNewFieldName.setEnabled(false);
        this.lblType.setLabelFor(this.txtType);
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)bundle.getString("LBL_FieldType"));
        this.txtType.setText(NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"PickOrCreateFieldPanel.txtType.text"));
        this.txtType.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFindType, (String)bundle.getString("LBL_FindType"));
        this.btnFindType.setEnabled(false);
        this.btnFindType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickOrCreateFieldPanel.this.btnFindTypeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.radioPickUpExistingField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lstExistingFields, 0, 388, Short.MAX_VALUE)).addComponent(this.radioCreateNewField).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblName).addComponent(this.lblType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.txtType, -1, 364, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFindType)).addComponent(this.txtNewFieldName, -1, 469, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioPickUpExistingField).addComponent(this.lstExistingFields, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioCreateNewField).addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblName).addComponent(this.txtNewFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblType).addComponent(this.btnFindType).addComponent(this.txtType, -2, -1, -2)).addContainerGap()));
        this.lblType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"PickOrCreateFieldPanel.lblType.AccessibleContext.accessibleName"));
    }

    private void btnFindTypeActionPerformed(ActionEvent evt) {
        ElementHandle type = TypeElementFinder.find((ClasspathInfo)ClasspathInfo.create((FileObject)this.fileObject), null);
        if (type != null) {
            String fqn = type.getQualifiedName().toString();
            this.txtType.setText(fqn);
        }
    }

    public void setFileObject(FileObject fo) {
        this.fileObject = fo;
    }

    public void setAvailableFields(Object[] availableFields) {
        this.availableFields = availableFields;
        this.mdlAvailableFields.removeAllElements();
        if (availableFields == null || availableFields.length == 0) {
            this.setChoosingExistingFieldEnabled(false);
        } else {
            this.setChoosingExistingFieldEnabled(true);
            for (int i = 0; i < availableFields.length; ++i) {
                this.mdlAvailableFields.addElement(availableFields[i]);
            }
        }
    }

    public void setChoosingExistingFieldEnabled(boolean enabled) {
        if (!enabled) {
            this.radioCreateNewField.setSelected(true);
        }
        this.radioPickUpExistingField.setEnabled(enabled);
    }

    public boolean wasCreateNewFieldSelected() {
        return this.radioCreateNewField.isSelected();
    }

    public String getNewIdName() {
        return this.txtNewFieldName.getText();
    }

    public Object getSelectedField() {
        return this.lstExistingFields.getSelectedItem();
    }

    public String getSelectedIdType() {
        return this.txtType.getText();
    }

    public void setType(String typeName) {
        this.txtType.setText(typeName);
    }

    public void setNameValidator(FieldNameValidator nameValidator) {
        this.nameValidator = nameValidator;
    }

    public void setExistingFieldNames(Set<String> existingFieldNames) {
        this.nameValidator.setExistingFieldNames(existingFieldNames);
    }

    public void setSelelectableType(boolean selectableType) {
        this.txtType.setVisible(selectableType);
        this.btnFindType.setVisible(selectableType);
        this.lblType.setVisible(selectableType);
    }

    void setDefaultFieldName(String defaultFieldName) {
        this.txtNewFieldName.setText(defaultFieldName);
    }

    public void setFieldNameStatus(NameStatus nameStatus) {
        if (this.dlgDescriptor == null) {
            return;
        }
        this.dlgDescriptor.setValid(nameStatus == NameStatus.VALID);
        String errorMsgBundleId = null;
        String fieldName = this.txtNewFieldName.getText();
        switch (nameStatus.ordinal()) {
            case 1: {
                errorMsgBundleId = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_IllegalJavaID", (Object)fieldName);
                break;
            }
            case 2: {
                errorMsgBundleId = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_IllegalSQLKeyWord", (Object)fieldName);
                break;
            }
            case 3: {
                errorMsgBundleId = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_DuplicateVariableName", (Object)fieldName);
            }
        }
        this.notSupport.setErrorMessage(errorMsgBundleId);
    }

    public void setDlgDescriptor(DialogDescriptor dlgDescriptor) {
        this.dlgDescriptor = dlgDescriptor;
        this.notSupport = dlgDescriptor.getNotificationLineSupport();
    }

    public static interface FieldNameValidator {
        public NameStatus checkName(String var1);

        public void setExistingFieldNames(Set<String> var1);
    }

    public static class DefaultFieldNameValidator
    implements FieldNameValidator {
        private Set<String> existingFieldNames;

        @Override
        public void setExistingFieldNames(Set<String> existingFieldNames) {
            this.existingFieldNames = existingFieldNames;
        }

        @Override
        public NameStatus checkName(String name) {
            if (!Utilities.isJavaIdentifier((String)name)) {
                return NameStatus.ILLEGAL_JAVA_ID;
            }
            if (JavaPersistenceQLKeywords.isKeyword((String)name)) {
                return NameStatus.ILLEGAL_SQL_KEYWORD;
            }
            if (this.existingFieldNames != null && this.existingFieldNames.contains(name)) {
                return NameStatus.DUPLICATE;
            }
            return NameStatus.VALID;
        }
    }

    public static enum NameStatus {
        VALID,
        ILLEGAL_JAVA_ID,
        ILLEGAL_SQL_KEYWORD,
        DUPLICATE;

    }
}

