/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.query.CommentSet;

public final class CommentSetImpl
implements Cloneable,
CommentSet {
    private boolean commentsMapped;
    private final Map<CommentSet.RelativePosition, List<Comment>> commentsMap = new HashMap<CommentSet.RelativePosition, List<Comment>>();
    private Map<CommentSet.RelativePosition, List<Comment>> origMap = null;
    private boolean changed;
    private boolean commentsFrozen;

    @Override
    public void addPrecedingComment(String s) {
        this.addPrecedingComment(Comment.create(s));
    }

    @Override
    public void addPrecedingComment(Comment c) {
        this.addComment(CommentSet.RelativePosition.PRECEDING, c);
    }

    @Override
    public void addPrecedingComments(List<Comment> comments) {
        for (Comment comment : comments) {
            this.addComment(CommentSet.RelativePosition.PRECEDING, comment);
        }
    }

    @Override
    public void addTrailingComment(String s) {
        this.addTrailingComment(Comment.create(s));
    }

    @Override
    public void addTrailingComment(Comment c) {
        this.addComment(CommentSet.RelativePosition.TRAILING, c);
    }

    @Override
    public void addTrailingComments(List<Comment> comments) {
        for (Comment comment : comments) {
            this.addComment(CommentSet.RelativePosition.TRAILING, comment);
        }
    }

    @Override
    public List<Comment> getPrecedingComments() {
        return this.getComments(CommentSet.RelativePosition.PRECEDING);
    }

    @Override
    public List<Comment> getTrailingComments() {
        return this.getComments(CommentSet.RelativePosition.TRAILING);
    }

    @Override
    public boolean hasComments() {
        return !this.commentsMap.isEmpty() || this.changed;
    }

    @Override
    public int pos() {
        return this.pos(CommentSet.RelativePosition.PRECEDING);
    }

    @Override
    public int pos(CommentSet.RelativePosition position) {
        List<Comment> list = this.getComments(position);
        return list.isEmpty() ? -2 : list.get(0).pos();
    }

    @Override
    public void addComment(CommentSet.RelativePosition positioning, Comment c) {
        this.addComment(positioning, c, -1);
    }

    @Override
    public void insertComment(CommentSet.RelativePosition positioning, Comment c, int index) {
        this.addComment(positioning, c, index);
    }

    private boolean trackFirstChange() {
        return (this.commentsMapped || this.commentsFrozen) && !this.changed;
    }

    public void addComment(CommentSet.RelativePosition positioning, Comment c, int index) {
        List<Object> comments;
        Map<CommentSet.RelativePosition, List<Comment>> orig = null;
        if (this.trackFirstChange()) {
            orig = this.getOrigMap();
        }
        if (this.commentsMap.containsKey((Object)positioning)) {
            comments = this.commentsMap.get((Object)positioning);
        } else {
            comments = new CL();
            this.commentsMap.put(positioning, comments);
        }
        if (c.isNew()) {
            comments.add(c);
        } else {
            if (index < 0) {
                index = 0;
                int npos = c.pos();
                for (Comment comment : comments) {
                    if (comment.isNew()) {
                        comments.add(c);
                        break;
                    }
                    int pos = comment.pos();
                    if (pos > npos) break;
                    if (pos == npos && c == comment) {
                        return;
                    }
                    ++index;
                }
            }
            comments.add(index, c);
        }
        if (orig != null) {
            this.origMap = orig;
        }
        this.changed = true;
    }

    public void addComments(CommentSet.RelativePosition positioning, Iterable<? extends Comment> comments) {
        for (Comment comment : comments) {
            this.addComment(positioning, comment);
        }
    }

    public List<Comment> getOrigComments(CommentSet.RelativePosition positioning) {
        if (this.origMap == null) {
            return this.getComments(positioning);
        }
        List<Comment> c = this.origMap.get((Object)positioning);
        return c != null ? c : Collections.emptyList();
    }

    @Override
    public List<Comment> getComments(CommentSet.RelativePosition positioning) {
        if (this.commentsMap.containsKey((Object)positioning)) {
            return this.commentsMap.get((Object)positioning);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasChanges() {
        return this.changed;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Unexpected " + String.valueOf(e));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<CommentSet.RelativePosition, List<Comment>> entry : this.commentsMap.entrySet()) {
            if (!first) {
                sb.append(", ");
                first = false;
            }
            sb.append("[").append((Object)entry.getKey()).append(" -> ");
            for (Comment comment : entry.getValue()) {
                sb.append(',').append(comment.getText());
            }
            sb.append("]");
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean areCommentsMapped() {
        return this.commentsMapped;
    }

    public void commentsFrozen(boolean freeze) {
        this.commentsFrozen = freeze;
    }

    public void commentsMapped() {
        this.commentsMapped = true;
        this.changed = false;
    }

    public void clearComments(CommentSet.RelativePosition forPosition) {
        this.commentsMap.remove((Object)forPosition);
    }

    private Map<CommentSet.RelativePosition, List<Comment>> getOrigMap() {
        if (this.origMap != null) {
            return this.origMap;
        }
        if (this.commentsMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<CommentSet.RelativePosition, List<Comment>>(this.commentsMap);
    }

    class CL<T>
    extends ArrayList<T> {
        CL() {
        }

        @Override
        public T remove(int index) {
            if (CommentSetImpl.this.trackFirstChange()) {
                CommentSetImpl.this.origMap = CommentSetImpl.this.getOrigMap();
            }
            CommentSetImpl.this.changed = true;
            return (T)super.remove(index);
        }

        @Override
        public boolean retainAll(Collection c) {
            Map<CommentSet.RelativePosition, List<Comment>> orig = CommentSetImpl.this.trackFirstChange() ? CommentSetImpl.this.getOrigMap() : null;
            boolean r = super.retainAll(c);
            if (orig != null && r) {
                CommentSetImpl.this.origMap = orig;
            }
            CommentSetImpl.this.changed |= r;
            return r;
        }

        @Override
        public boolean removeAll(Collection c) {
            Map<CommentSet.RelativePosition, List<Comment>> orig = CommentSetImpl.this.trackFirstChange() ? CommentSetImpl.this.getOrigMap() : null;
            boolean r = super.removeAll(c);
            if (orig != null && r) {
                CommentSetImpl.this.origMap = orig;
            }
            CommentSetImpl.this.changed |= r;
            return r;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            boolean xch = CommentSetImpl.this.trackFirstChange();
            CommentSetImpl.this.changed = CommentSetImpl.this.changed | toIndex > fromIndex;
            if (xch && CommentSetImpl.this.changed) {
                CommentSetImpl.this.origMap = CommentSetImpl.this.getOrigMap();
            }
            super.removeRange(fromIndex, toIndex);
        }

        @Override
        public boolean remove(Object o) {
            Map<CommentSet.RelativePosition, List<Comment>> orig = CommentSetImpl.this.trackFirstChange() ? CommentSetImpl.this.getOrigMap() : null;
            boolean r = super.remove(o);
            if (orig != null && r) {
                CommentSetImpl.this.origMap = orig;
            }
            CommentSetImpl.this.changed |= r;
            return r;
        }

        @Override
        public T set(int index, T element) {
            boolean xch = CommentSetImpl.this.trackFirstChange();
            CommentSetImpl.this.changed = CommentSetImpl.this.changed | element != this.get(index);
            if (xch && CommentSetImpl.this.changed) {
                CommentSetImpl.this.origMap = CommentSetImpl.this.getOrigMap();
            }
            return super.set(index, element);
        }
    }
}

