/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDAMethodChooserUtils;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.MethodChooser;
import org.openide.text.Annotation;
import org.openide.util.NbBundle;

public class MethodChooserSupport {
    private final JPDADebuggerImpl debugger;
    private final JPDAThread currentThread;
    private final String url;
    private final ReferenceType clazzRef;
    private MethodChooser chooser;
    private PropertyChangeListener chooserPropertyChangeListener;
    ArrayList<Annotation> annotations;
    private int startLine;
    private int endLine;
    private int selectedIndex = -1;
    private EditorContext.Operation[] operations;
    private Location[] locations;
    private ExpressionPool.Interval expressionLines;
    private boolean[] isCertainlyReachable;

    MethodChooserSupport(JPDADebuggerImpl debugger, String url, ReferenceType clazz, int methodLine) {
        this.debugger = debugger;
        this.currentThread = debugger.getCurrentThread();
        this.url = url;
        this.clazzRef = clazz;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public MethodChooser.Segment[] getSegments() {
        MethodChooser.Segment[] segments = new MethodChooser.Segment[this.operations.length];
        for (int x = 0; x < segments.length; ++x) {
            int start = this.operations[x].getMethodStartPosition().getOffset();
            int end = this.operations[x].getMethodEndPosition().getOffset();
            segments[x] = this.isCertainlyReachable[x] ? new MethodChooser.Segment(start, end) : new UncertainSegment(start, end);
        }
        return segments;
    }

    public int getSegmentsCount() {
        return this.operations.length;
    }

    public String getHint() {
        return NbBundle.getMessage(MethodChooserSupport.class, (String)"MSG_RunIntoMethod_Status_Line_Help");
    }

    public KeyStroke[] getStopEvents() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(119, 0), KeyStroke.getKeyStroke(118, 64), KeyStroke.getKeyStroke(118, 128)};
    }

    public KeyStroke[] getConfirmEvents() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(118, 0)};
    }

    public MethodChooser createChooser() {
        return new MethodChooser(this.url, this.getSegments(), this.selectedIndex, this.getHint(), this.getStopEvents(), this.getConfirmEvents());
    }

    public void tearUp(MethodChooser selector) {
        System.setProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips", "true");
        this.chooser = selector;
        this.debugger.addPropertyChangeListener(this.chooserPropertyChangeListener);
        this.debugger.getThreadsCollector().addPropertyChangeListener(this.chooserPropertyChangeListener);
        this.annotateLines();
    }

    public void tearDown() {
        System.clearProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips");
        this.debugger.removePropertyChangeListener(this.chooserPropertyChangeListener);
        this.debugger.getThreadsCollector().removePropertyChangeListener(this.chooserPropertyChangeListener);
        this.clearAnnotations();
    }

    public void doStepInto() {
        int index = this.chooser.getSelectedIndex();
        JPDAMethodChooserUtils.doStepInto((JPDADebuggerImpl)this.debugger, (EditorContext.Operation)this.operations[index], (Location)this.locations[index], (ExpressionPool.Interval)this.expressionLines);
    }

    public boolean init() {
        JPDAMethodChooserUtils.Params params = JPDAMethodChooserUtils.init((JPDADebuggerImpl)this.debugger, (JPDAThread)this.currentThread, (String)this.url, (JPDAMethodChooserUtils.ReleaseUIListener)new JPDAMethodChooserUtils.ReleaseUIListener(){

            public void releaseUI() {
                MethodChooserSupport.this.chooser.releaseUI(false);
            }
        });
        this.operations = params.getOperations();
        this.expressionLines = params.getExpressionLines();
        this.locations = params.getLocations();
        this.startLine = params.getStartLine();
        this.endLine = params.getEndLine();
        this.isCertainlyReachable = params.getIsCertainlyReachable();
        this.selectedIndex = params.getSelectedIndex();
        this.chooserPropertyChangeListener = params.getChoosertPropertyChangeListener();
        return params.isContinuedDirectly();
    }

    private void annotateLines() {
        this.annotations = new ArrayList();
        EditorContext context = EditorContextBridge.getContext();
        JPDAThread thread = this.debugger.getCurrentThread();
        EditorContext.Operation currOp = thread.getCurrentOperation();
        int currentLine = currOp != null ? currOp.getStartPosition().getLine() : thread.getLineNumber(null);
        String annoType = currOp != null ? "CurrentExpressionLine" : "CurrentPC";
        for (int lineNum = this.startLine; lineNum <= this.endLine; ++lineNum) {
            Object anno;
            if (lineNum == currentLine || !((anno = context.annotate(this.url, lineNum, annoType, null)) instanceof Annotation)) continue;
            this.annotations.add((Annotation)anno);
        }
    }

    private void clearAnnotations() {
        if (this.annotations != null) {
            for (Annotation anno : this.annotations) {
                anno.detach();
            }
        }
    }

    private static class UncertainSegment
    extends MethodChooser.Segment {
        public UncertainSegment(int start, int end) {
            super(start, end);
        }
    }
}

