/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.Bitness;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum Architecture implements Api
{
    AARCH64("AARCH64", "aarch64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(ARM64);
        }
    }
    ,
    AARCH32("AARCH32", "aarch32", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(ARM, ARM32);
        }
    }
    ,
    ARM("ARM", "arm", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(ARM32, AARCH32);
        }
    }
    ,
    ARM32("ARM32", "arm32", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(ARM, AARCH32);
        }
    }
    ,
    ARMHF("ARMHF", "armhf", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    ARMEL("ARMEL", "armel", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    ARM64("ARM64", "arm64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(AARCH64);
        }
    }
    ,
    MIPS("MIPS", "mips", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    MIPSEL("MIPS EL", "mipsel", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    PPC("Power PC", "ppc", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    PPC64("PPC64", "ppc64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    PPC64LE("PPC64LE", "ppc64le", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    RISCV64("RISCv64", "riscv64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    S390X("S390X", "s390x", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    SPARC("Sparc", "sparc", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    SPARCV9("Sparc V9", "sparcv9", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    X64("X64", "x64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(AMD64, X86_64);
        }
    }
    ,
    X32("X32", "x32", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X86, I386, I586, I686);
        }
    }
    ,
    I386("I386", "i386", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X86, X32, I586, I686);
        }
    }
    ,
    I586("I586", "i386", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X86, X32, I386, I686);
        }
    }
    ,
    I686("I686", "i386", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X86, X32, I386, I686);
        }
    }
    ,
    X86("X86", "x86", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X32, I386, I586, I686);
        }
    }
    ,
    X86_64("X86_64", "x86_64", Bitness.BIT_64, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X64, AMD64);
        }
    }
    ,
    AMD64("AMD64", "amd64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X64, X86_64);
        }
    }
    ,
    IA64("IA-64", "ia64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    NONE("-", "", Bitness.NONE, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    NOT_FOUND("", "", Bitness.NOT_FOUND, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    };

    private final String uiString;
    private final String apiString;
    private final Bitness bitness;
    private final boolean standard;

    private Architecture(String uiString, String apiString, Bitness bitness, boolean standard) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.bitness = bitness;
        this.standard = standard;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Architecture getDefault() {
        return NONE;
    }

    @Override
    public Architecture getNotFound() {
        return NOT_FOUND;
    }

    public Architecture[] getAll() {
        return (Architecture[])Arrays.stream(Architecture.values()).filter(Architecture::isStandard).toArray(Architecture[]::new);
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",\n").append("  \"").append("bitness").append("\"").append(":").append("\"").append(this.bitness.getApiString()).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",").append("\"").append("bitness").append("\"").append(":").append("\"").append(this.bitness.getApiString()).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static Architecture fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "aarch64": 
            case "AARCH64": {
                return AARCH64;
            }
            case "amd64": 
            case "AMD64": 
            case "_amd64": {
                return AMD64;
            }
            case "aarch32": 
            case "AARCH32": 
            case "arm32": 
            case "ARM32": 
            case "armv6": 
            case "ARMV6": 
            case "armv7l": 
            case "ARMV7L": 
            case "armv7": 
            case "ARMV7": 
            case "arm": 
            case "ARM": {
                return ARM;
            }
            case "armel": 
            case "ARMEL": {
                return ARMEL;
            }
            case "armhf": 
            case "ARMHF": {
                return ARMHF;
            }
            case "arm64": 
            case "ARM64": 
            case "armv8": 
            case "ARMV8": {
                return ARM64;
            }
            case "mips": 
            case "MIPS": {
                return MIPS;
            }
            case "mipsel": 
            case "MIPSEL": {
                return MIPSEL;
            }
            case "ppc": 
            case "PPC": {
                return PPC;
            }
            case "ppc64el": 
            case "PPC64EL": 
            case "ppc64le": 
            case "PPC64LE": {
                return PPC64LE;
            }
            case "ppc64": 
            case "PPC64": {
                return PPC64;
            }
            case "riscv64": 
            case "RISCV64": {
                return RISCV64;
            }
            case "s390": 
            case "s390x": 
            case "S390X": {
                return S390X;
            }
            case "sparc": 
            case "SPARC": {
                return SPARC;
            }
            case "sparcv9": 
            case "SPARCV9": {
                return SPARCV9;
            }
            case "x64": 
            case "X64": 
            case "x86-64": 
            case "X86-64": 
            case "x86_64": 
            case "X86_64": 
            case "x86lx64": 
            case "X86LX64": {
                return X64;
            }
            case "x32": 
            case "x86": 
            case "X86": 
            case "286": 
            case "386": 
            case "486": 
            case "586": 
            case "686": 
            case "i386": 
            case "i486": 
            case "i586": 
            case "i686": 
            case "x86-32": 
            case "x86lx32": 
            case "X86LX32": {
                return X86;
            }
            case "ia64": 
            case "IA64": 
            case "ia-64": 
            case "IA-64": {
                return IA64;
            }
        }
        return NOT_FOUND;
    }

    public Bitness getBitness() {
        return this.bitness;
    }

    public boolean isStandard() {
        return this.standard;
    }

    public static List<Architecture> getAsList() {
        return Arrays.asList(Architecture.values());
    }

    public abstract List<Architecture> getSynonyms();
}

