/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.netbeans.modules.websvc.saas.spi.ConsumerFlavorProvider;
import org.netbeans.modules.websvc.saas.ui.actions.ViewWSDLAction;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.ui.nodes.WsdlSaasNodeChildren;
import org.netbeans.modules.websvc.saas.util.SaasTransferable;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class WsdlSaasNode
extends SaasNode {
    private ExTransferable transferable;
    private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/ui/resources/webservice.png");
    private boolean portAdded;

    public WsdlSaasNode(WsdlSaas saas) {
        this(saas, new InstanceContent());
    }

    protected WsdlSaasNode(WsdlSaas saas, InstanceContent content) {
        super(new WsdlSaasNodeChildren(saas), new AbstractLookup((AbstractLookup.Content)content), (Saas)saas);
        content.add((Object)saas);
        this.transferable = ExTransferable.create((Transferable)new SaasTransferable((Object)saas, SaasTransferable.WSDL_SERVICE_FLAVORS));
    }

    private static WsdlSaasPort getDefaultPort(WsdlSaas saas) {
        if (saas.getPorts().isEmpty()) {
            return null;
        }
        return (WsdlSaasPort)saas.getPorts().get(0);
    }

    public WsdlSaas getSaas() {
        return (WsdlSaas)super.getSaas();
    }

    @Override
    public Image getGenericIcon(int type) {
        return ICON;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    @Override
    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(super.getActions(context)));
        actions.add((Action)SystemAction.get(ViewWSDLAction.class));
        return actions.toArray(new Action[0]);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ss = sheet.get("data");
        if (ss == null) {
            ss = new Sheet.Set();
            ss.setName("data");
            ss.setDisplayName(NbBundle.getMessage(WsdlSaasNode.class, (String)"WS_INFO"));
            ss.setShortDescription(NbBundle.getMessage(WsdlSaasNode.class, (String)"WS_INFO"));
            sheet.put(ss);
        }
        ss.put((Node.Property)new PropertySupport.ReadOnly<String>("name", String.class, NbBundle.getMessage(WsdlSaasNode.class, (String)"PORT_NAME_IN_WSDL"), NbBundle.getMessage(WsdlSaasNode.class, (String)"PORT_NAME_IN_WSDL")){

            public String getValue() {
                return this.getName();
            }
        });
        ss.put((Node.Property)new PropertySupport.ReadOnly<String>("URL", String.class, NbBundle.getMessage(WsdlSaasNode.class, (String)"WS_URL"), NbBundle.getMessage(WsdlSaasNode.class, (String)"WS_URL")){

            public String getValue() {
                return WsdlSaasNode.this.saas.getUrl();
            }
        });
        return sheet;
    }

    public Transferable clipboardCopy() throws IOException {
        if (this.getSaas().getState() != Saas.State.READY) {
            this.getSaas().toStateReady(true);
            return super.clipboardCopy();
        }
        if (!this.portAdded) {
            final WsdlSaasPort port = WsdlSaasNode.getDefaultPort(this.getSaas());
            if (port != null) {
                this.transferable.put(new ExTransferable.Single(this, ConsumerFlavorProvider.PORT_FLAVOR){
                    final /* synthetic */ WsdlSaasNode this$0;
                    {
                        this.this$0 = this$0;
                        super(flavor);
                    }

                    protected Object getData() throws IOException, UnsupportedFlavorException {
                        return port;
                    }
                });
            }
            this.portAdded = true;
        }
        return SaasTransferable.addFlavors((Transferable)this.transferable);
    }
}

