/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.j2semodule.ui.wizards.ModuleTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ModuleTargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private ModuleTargetChooserPanelGUI gui;
    private WizardDescriptor wizard;
    private Project project;
    private SourceGroup[] folders;

    public ModuleTargetChooserPanel(Project project, SourceGroup[] folders) {
        this.project = project;
        this.folders = folders;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new ModuleTargetChooserPanelGUI(this.project, this.folders, null);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wizard) {
        Object substitute;
        this.wizard = wizard;
        if (this.gui != null) {
            FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
            this.gui.initValues(Templates.getTemplate((WizardDescriptor)wizard), preselectedFolder);
        }
        if (this.gui != null && (substitute = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            wizard.putProperty("NewFileWizard_Title", substitute);
        }
    }

    public void storeSettings(WizardDescriptor settings) {
        Object value = this.wizard.getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
            return;
        }
        if (this.isValid()) {
            assert (this.gui != null);
            FileObject rootFolder = this.gui.getRootFolder();
            Templates.setTargetFolder((WizardDescriptor)this.wizard, (FileObject)(rootFolder.isValid() ? rootFolder : null));
            Templates.setTargetName((WizardDescriptor)this.wizard, (String)this.gui.getTargetName());
        }
        if (WizardDescriptor.FINISH_OPTION.equals(value)) {
            this.wizard.putProperty("NewFileWizard_Title", null);
        }
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        if (this.gui == null) {
            return false;
        }
        if (this.gui.getTargetName() == null) {
            this.setErrorMessage("INFO_ModuleTargetChooser_ProvideModuleName");
            return false;
        }
        if (!this.isValidModuleName(this.gui.getTargetName())) {
            this.setErrorMessage("ERR_ModuleTargetChooser_InvalidModule");
            return false;
        }
        if (!this.isValidModule(this.gui.getRootFolder(), this.gui.getTargetName())) {
            this.setErrorMessage("ERR_ModuleTargetChooser_InvalidFolder");
            return false;
        }
        if (this.isModuleNameAlreadyExists(this.gui.getRootFolder(), this.gui.getTargetName())) {
            this.setErrorMessage("ERR_ModuleTargetChooser_AlreadyExistModule");
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] ls;
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new ChangeListener[0]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener l : ls) {
            l.stateChanged(ev);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private boolean isValidModuleName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer st = new StringTokenizer(str, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidModule(FileObject root, String path) {
        if (root == null) {
            return false;
        }
        if (path == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(path, ".");
        while (st.hasMoreTokens()) {
            if ((root = root.getFileObject(st.nextToken())) == null) {
                return true;
            }
            if (!root.isData()) continue;
            return false;
        }
        return true;
    }

    private boolean isModuleNameAlreadyExists(FileObject root, String newModuleName) {
        return Arrays.stream(root.getChildren()).anyMatch(module -> module.getName().equalsIgnoreCase(newModuleName));
    }

    private void setErrorMessage(String key) {
        if (key == null) {
            this.wizard.getNotificationLineSupport().clearMessages();
        } else {
            this.wizard.getNotificationLineSupport().setErrorMessage(NbBundle.getMessage(ModuleTargetChooserPanelGUI.class, (String)key));
        }
    }
}

