/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.Collections;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.jsf.api.editor.JsfFacesComponentsProvider;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfNavigationHelper {
    private JsfNavigationHelper() {
    }

    static TokenSequence getTokenSequenceAtCaret(TokenHierarchy th, int caretOffset) {
        TokenSequence ts = Utils.getJoinedHtmlSequence((TokenHierarchy)th, (int)caretOffset);
        if (ts == null) {
            return null;
        }
        ts.move(caretOffset);
        if (ts.moveNext() || ts.movePrevious()) {
            return ts;
        }
        return null;
    }

    static DeclarationFinder.DeclarationLocation goToCompositeComponentLibrary(HtmlParserResult htmlresult, final int caretOffset, Library lib) {
        Snapshot snapshot = htmlresult.getSnapshot();
        Element leaf = htmlresult.findByPhysicalRange(caretOffset, true);
        OpenTag openTag = (OpenTag)leaf;
        String tagName = openTag.unqualifiedName().toString();
        LibraryComponent component = lib.getComponent(tagName);
        if (component == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        if (!(component instanceof CompositeComponentLibrary.CompositeComponent)) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        CompositeComponentModel model = ((CompositeComponentLibrary.CompositeComponent)component).getComponentModel();
        FileObject file = model.getSourceFile();
        int astOffset = snapshot.getEmbeddedOffset(caretOffset);
        int jumpOffset = 0;
        TokenSequence htmlTs = snapshot.getTokenHierarchy().tokenSequence();
        htmlTs.move(astOffset);
        if ((htmlTs.moveNext() || htmlTs.movePrevious()) && htmlTs.token().id() != HTMLTokenId.TAG_OPEN && htmlTs.token().id() == HTMLTokenId.ARGUMENT) {
            final String attributeName = htmlTs.token().text().toString();
            Source source = Source.create((FileObject)file);
            final int[] attrOffset = new int[1];
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result result = resultIterator.getParserResult(caretOffset);
                        if (result instanceof HtmlParserResult) {
                            HtmlParserResult hresult = (HtmlParserResult)result;
                            Node root = hresult.root("http://xmlns.jcp.org/jsf/composite");
                            ElementUtils.visitChildren((Element)root, (ElementVisitor)new ElementVisitor(){
                                final /* synthetic */ 1 this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                public void visit(Element node) {
                                    OpenTag ot = (OpenTag)node;
                                    if (LexerUtils.equals((CharSequence)"interface", (CharSequence)ot.unqualifiedName(), (boolean)true, (boolean)true)) {
                                        for (Element child : ot.children(ElementType.OPEN_TAG)) {
                                            CharSequence value;
                                            Attribute nameAttr;
                                            OpenTag otch = (OpenTag)child;
                                            if (!LexerUtils.equals((CharSequence)"attribute", (CharSequence)otch.unqualifiedName(), (boolean)true, (boolean)true) || (nameAttr = otch.getAttribute("name")) == null || (value = nameAttr.unquotedValue()) == null || !LexerUtils.equals((CharSequence)attributeName, (CharSequence)value, (boolean)true, (boolean)false)) continue;
                                            attrOffset[0] = child.from();
                                            break;
                                        }
                                    }
                                }
                            }, (ElementType)ElementType.OPEN_TAG);
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            jumpOffset = attrOffset[0];
        }
        if (file != null) {
            return new DeclarationFinder.DeclarationLocation(file, jumpOffset);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    static DeclarationFinder.DeclarationLocation goToFacesComponentLibrary(HtmlParserResult htmlresult, int caretOffset, JsfFacesComponentsProvider.FacesComponentLibrary lib) {
        FileObject file;
        Project project;
        Element leaf = htmlresult.findByPhysicalRange(caretOffset, true);
        OpenTag openTag = (OpenTag)leaf;
        String tagName = openTag.unqualifiedName().toString();
        LibraryComponent component = lib.getComponent(tagName);
        if (component == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        if (!(component instanceof JsfFacesComponentsProvider.FacesLibraryComponent)) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        JsfFacesComponentsProvider.FacesLibraryComponent facesComponent = (JsfFacesComponentsProvider.FacesLibraryComponent)component;
        FileObject fileObject = htmlresult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (file = facesComponent.getComponentFile(project)) != null) {
            return new DeclarationFinder.DeclarationLocation(file, 0);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    static DeclarationFinder.DeclarationLocation goToReferencedFile(HtmlParserResult htmlresult, int caretOffset, String tag, String attribute, String value) {
        FileObject fileObject;
        if (tag.isEmpty() || attribute.isEmpty() || value.isEmpty()) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        if (tag.contains("include") && "src".equals(attribute) && (fileObject = htmlresult.getSnapshot().getSource().getFileObject().getParent().getFileObject(value)) != null) {
            return new DeclarationFinder.DeclarationLocation(fileObject, 0);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }
}

