/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import org.netbeans.modules.profiler.snaptracer.ProbeItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.ContinuousXYPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.DiscreteXYPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.PointsComputer;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineColorFactory;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineIconPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.ContinuousXYItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.DiscreteXYItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.IconItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.ValueItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.XYItemDescriptor;

final class TimelinePaintersFactory {
    TimelinePaintersFactory() {
    }

    static TimelineXYPainter createPainter(ProbeItemDescriptor descriptor, int itemIndex, PointsComputer c, IdeSnapshot snapshot) {
        if (descriptor instanceof ValueItemDescriptor) {
            return TimelinePaintersFactory.createValuePainter((ValueItemDescriptor)descriptor, itemIndex, c, snapshot);
        }
        return null;
    }

    private static TimelineXYPainter createValuePainter(ValueItemDescriptor descriptor, int itemIndex, PointsComputer c, IdeSnapshot snapshot) {
        if (descriptor instanceof ContinuousXYItemDescriptor) {
            return TimelinePaintersFactory.createContinuousPainter((ContinuousXYItemDescriptor)descriptor, itemIndex, c);
        }
        if (descriptor instanceof DiscreteXYItemDescriptor) {
            return TimelinePaintersFactory.createDiscretePainter((DiscreteXYItemDescriptor)descriptor, itemIndex, c);
        }
        if (descriptor instanceof IconItemDescriptor) {
            return TimelinePaintersFactory.createIconPainter((IconItemDescriptor)descriptor, itemIndex, snapshot);
        }
        return null;
    }

    private static TimelineXYPainter createContinuousPainter(XYItemDescriptor descriptor, int itemIndex, PointsComputer c) {
        Color fillColor;
        Color lineColor;
        double dataFactor = descriptor.getDataFactor();
        float lineWidth = descriptor.getLineWidth();
        if (lineWidth == -1.0f) {
            lineWidth = 2.0f;
        }
        if ((lineColor = descriptor.getLineColor()) == ProbeItemDescriptor.DEFAULT_COLOR) {
            lineColor = TimelineColorFactory.getColor(itemIndex);
        }
        if ((fillColor = descriptor.getFillColor()) == ProbeItemDescriptor.DEFAULT_COLOR) {
            fillColor = lineColor == null ? TimelineColorFactory.getColor(itemIndex) : TimelineColorFactory.getGradient(itemIndex)[0];
        }
        return new ContinuousXYPainter(lineWidth, lineColor, fillColor, dataFactor, c);
    }

    private static DiscreteXYPainter createDiscretePainter(DiscreteXYItemDescriptor descriptor, int itemIndex, PointsComputer c) {
        Color fillColor;
        Color lineColor;
        double dataFactor = descriptor.getDataFactor();
        float lineWidth = descriptor.getLineWidth();
        if (lineWidth == -1.0f) {
            lineWidth = 2.0f;
        }
        if ((lineColor = descriptor.getLineColor()) == ProbeItemDescriptor.DEFAULT_COLOR) {
            lineColor = TimelineColorFactory.getColor(itemIndex);
        }
        if ((fillColor = descriptor.getFillColor()) == ProbeItemDescriptor.DEFAULT_COLOR) {
            fillColor = lineColor == null ? TimelineColorFactory.getColor(itemIndex) : TimelineColorFactory.getGradient(itemIndex)[0];
        }
        return new DiscreteXYPainter(lineWidth, lineColor, fillColor, descriptor.getWidth(), descriptor.isFixedWidth(), descriptor.isTopLineOnly(), descriptor.isOutlineOnly(), dataFactor, c);
    }

    private static TimelineIconPainter createIconPainter(IconItemDescriptor descriptor, int itemIndex, IdeSnapshot snapshot) {
        Color color = descriptor.getColor();
        if (color == ProbeItemDescriptor.DEFAULT_COLOR) {
            color = TimelineColorFactory.getColor(itemIndex);
        }
        return new TimelineIconPainter(color, snapshot);
    }
}

