/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import org.netbeans.modules.css.visual.api.CssStylesTC;
import org.netbeans.modules.web.browser.api.Page;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class CssStylesTCController
implements PropertyChangeListener,
LookupListener {
    private static final RequestProcessor RP = new RequestProcessor(CssStylesTCController.class);
    private static CssStylesTCController STATIC_INSTANCE;
    public static final String CSS_TC_MODE = "properties";

    static synchronized void init() {
        if (STATIC_INSTANCE == null) {
            STATIC_INSTANCE = new CssStylesTCController();
        }
    }

    public CssStylesTCController() {
        TopComponent.Registry reg = WindowManager.getDefault().getRegistry();
        reg.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)reg));
        Lookup.Result lookupResult = Lookup.getDefault().lookupResult(PageInspector.class);
        lookupResult.addLookupListener((LookupListener)this);
        this.resultChanged(new LookupEvent(lookupResult));
        this.propertyChange(new PropertyChangeEvent(this, "activated", null, TopComponent.getRegistry().getActivated()));
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("activated".equals(propName)) {
            final TopComponent activated = (TopComponent)evt.getNewValue();
            if (!WindowManager.getDefault().isOpenedEditorTopComponent(activated)) {
                return;
            }
            if (activated instanceof CssStylesTC) {
                return;
            }
            RP.post(new Runnable(){
                final /* synthetic */ CssStylesTCController this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    final FileObject file = this.this$0.getFileObject(activated);
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            CssStylesTC cssStylesTC;
                            if (this.this$1.this$0.isCSSStylesTCOpened() && (cssStylesTC = this.this$1.this$0.getCssStylesTC()) != null) {
                                cssStylesTC.setContext(file);
                            }
                        }
                    });
                }
            });
        } else if ("model".equals(propName)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Page page = PageInspector.getDefault().getPage();
                    TopComponentGroup group = CssStylesTCController.getCssStylesTCGroup();
                    if (page == null) {
                        group.close();
                    } else {
                        group.open();
                    }
                }
            });
        }
    }

    private FileObject getFileObject(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        return (FileObject)tc.getLookup().lookup(FileObject.class);
    }

    private boolean isCSSStylesTCOpened() {
        WindowManager wm = WindowManager.getDefault();
        for (Mode mode : wm.getModes()) {
            if (!CSS_TC_MODE.equals(mode.getName())) continue;
            for (TopComponent tc : wm.getOpenedTopComponents(mode)) {
                if (!(tc instanceof CssStylesTC)) continue;
                return true;
            }
        }
        return false;
    }

    private CssStylesTC getCssStylesTC() {
        return (CssStylesTC)WindowManager.getDefault().findTopComponent("CssStylesTC");
    }

    static TopComponentGroup getCssStylesTCGroup() {
        return WindowManager.getDefault().findTopComponentGroup("CssStyles");
    }

    public final void resultChanged(LookupEvent ev) {
        PageInspector pageInspector = PageInspector.getDefault();
        if (pageInspector != null) {
            Lookup.Result lookupResult = (Lookup.Result)ev.getSource();
            lookupResult.removeLookupListener((LookupListener)this);
            pageInspector.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public static class ShutdownHook
    implements Callable<Boolean>,
    WindowSystemListener {
        private boolean listenerInstalled;

        @Override
        public Boolean call() throws Exception {
            if (!this.listenerInstalled) {
                this.listenerInstalled = true;
                WindowManager.getDefault().addWindowSystemListener((WindowSystemListener)this);
            }
            return Boolean.TRUE;
        }

        public void beforeLoad(WindowSystemEvent event) {
        }

        public void afterLoad(WindowSystemEvent event) {
        }

        public void beforeSave(WindowSystemEvent event) {
            TopComponentGroup group = CssStylesTCController.getCssStylesTCGroup();
            if (group != null) {
                group.close();
            }
        }

        public void afterSave(WindowSystemEvent event) {
        }
    }
}

