/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.api.PhpLanguageProperties;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class PhpProjectGenerator {
    private static final Logger LOGGER = Logger.getLogger(PhpProjectGenerator.class.getName());
    public static final Monitor DEV_NULL = new Monitor(){

        @Override
        public void starting() {
        }

        @Override
        public void creatingIndexFile() {
        }

        @Override
        public void finishing() {
        }
    };

    private PhpProjectGenerator() {
    }

    public static AntProjectHelper createProject(ProjectProperties projectProperties, Monitor monitor) throws IOException {
        if (monitor == null) {
            monitor = DEV_NULL;
        }
        monitor.starting();
        ProjectProperties projectPropertiesCopy = new ProjectProperties(projectProperties);
        boolean existingSources = projectPropertiesCopy.getSourcesDirectory().exists();
        FileObject sourceDir = FileUtil.createFolder((File)projectPropertiesCopy.getSourcesDirectory());
        AntProjectHelper helper = PhpProjectGenerator.createProject0(projectPropertiesCopy);
        PhpProjectGenerator.logUsage(helper.getProjectDirectory(), sourceDir, projectPropertiesCopy.getRunAsType(), projectPropertiesCopy.isCopySources(), projectPropertiesCopy.getFrameworkExtenders());
        WizardDescriptor descriptor = projectPropertiesCopy.getDescriptor();
        if (descriptor == null) {
            LOGGER.fine("Index file not used, no descriptor given");
        } else {
            String indexFile = projectPropertiesCopy.getIndexFile();
            if (!existingSources && indexFile != null) {
                monitor.creatingIndexFile();
                FileObject template = null;
                PhpProjectProperties.RunAsType runAsType = projectPropertiesCopy.getRunAsType();
                if (runAsType == null) {
                    template = Templates.getTemplate((WizardDescriptor)descriptor);
                } else {
                    switch (runAsType) {
                        case SCRIPT: {
                            template = FileUtil.getConfigFile((String)"Templates/Scripting/EmptyPHP.php");
                            break;
                        }
                        default: {
                            template = Templates.getTemplate((WizardDescriptor)descriptor);
                        }
                    }
                }
                assert (template != null) : "Template for Index PHP file cannot be null";
                PhpProjectGenerator.createIndexFile(template, sourceDir, indexFile);
            }
        }
        monitor.finishing();
        return helper;
    }

    private static AntProjectHelper createProject0(final ProjectProperties projectProperties) throws IOException {
        File projectDirectory = projectProperties.getProjectDirectory();
        if (projectDirectory == null) {
            projectDirectory = projectProperties.getSourcesDirectory();
        }
        assert (projectDirectory != null);
        FileObject projectFO = FileUtil.createFolder((File)projectDirectory);
        final AntProjectHelper helper = ProjectGenerator.createProject((FileObject)projectFO, (String)"org.netbeans.modules.php.project");
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws MutexException {
                    try {
                        Element data = helper.getPrimaryConfigurationData(true);
                        Document doc = data.getOwnerDocument();
                        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/php-project/1", "name");
                        nameEl.appendChild(doc.createTextNode(projectProperties.getName()));
                        data.appendChild(nameEl);
                        helper.putPrimaryConfigurationData(data, true);
                        EditableProperties sharedProperties = helper.getProperties("nbproject/project.properties");
                        EditableProperties privateProperties = helper.getProperties("nbproject/private/private.properties");
                        PhpProjectGenerator.configureAutoconfigured(projectProperties, sharedProperties, privateProperties);
                        PhpProjectGenerator.configureSources(helper, projectProperties, sharedProperties, privateProperties);
                        PhpProjectGenerator.configureEncoding(projectProperties, sharedProperties, privateProperties);
                        PhpProjectGenerator.configureTags(projectProperties, sharedProperties, privateProperties);
                        PhpProjectGenerator.configureIncludePath(projectProperties, sharedProperties, privateProperties);
                        PhpProjectGenerator.configureUrl(projectProperties, sharedProperties, privateProperties);
                        if (projectProperties.getRunAsType() != null) {
                            PhpProjectGenerator.configureCopySources(projectProperties, sharedProperties, privateProperties);
                            PhpProjectGenerator.configureIndexFile(projectProperties, sharedProperties, privateProperties);
                            PhpProjectGenerator.configureRunConfiguration(projectProperties, sharedProperties, privateProperties);
                        }
                        helper.putProperties("nbproject/project.properties", sharedProperties);
                        helper.putProperties("nbproject/private/private.properties", privateProperties);
                        Project project = ProjectManager.getDefault().findProject(helper.getProjectDirectory());
                        assert (project != null);
                        ProjectManager.getDefault().saveProject(project);
                        assert (this.verifyProjectProperties(project));
                    }
                    catch (IOException ioe) {
                        throw new MutexException((Exception)ioe);
                    }
                    return null;
                }

                private boolean verifyProjectProperties(Project project) throws IOException {
                    FileObject nbproject = project.getProjectDirectory().getFileObject("nbproject");
                    if (nbproject == null) {
                        throw new IllegalStateException("nbproject directory does not exist for project " + project.getProjectDirectory());
                    }
                    if (!nbproject.isValid()) {
                        throw new IllegalStateException("nbproject directory not valid for project " + project.getProjectDirectory());
                    }
                    FileObject projectProperties2 = nbproject.getFileObject("project.properties");
                    if (projectProperties2 == null) {
                        throw new IllegalStateException("nbproject/project.properties does not exist for project " + project.getProjectDirectory());
                    }
                    if (!projectProperties2.isValid()) {
                        throw new IllegalStateException("nbproject/project.properties not valid for project " + project.getProjectDirectory());
                    }
                    if (!projectProperties2.asText().contains("src.dir")) {
                        throw new IllegalStateException("src.dir not found in nbproject/project.properties for project " + project.getProjectDirectory());
                    }
                    return true;
                }
            });
        }
        catch (MutexException e) {
            Exception ie = e.getException();
            if (ie instanceof IOException) {
                throw (IOException)ie;
            }
            Exceptions.printStackTrace((Throwable)e);
        }
        return helper;
    }

    private static void configureAutoconfigured(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        Boolean autoconfigured = projectProperties.getAutoconfigured();
        if (autoconfigured != null) {
            privateProperties.setProperty("autoconfigured", Boolean.toString(autoconfigured));
        }
    }

    private static void configureSources(AntProjectHelper helper, ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        File srcDir = projectProperties.getSourcesDirectory();
        File projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        String srcPath = PropertyUtils.relativizeFile((File)projectDirectory, (File)srcDir);
        if (srcPath == null) {
            srcPath = srcDir.getAbsolutePath();
        }
        sharedProperties.setProperty("src.dir", srcPath);
        sharedProperties.setProperty("web.root", ".");
        sharedProperties.setProperty("php.version", projectProperties.getPhpVersion().name());
    }

    private static void configureEncoding(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        Charset charset = projectProperties.getCharset();
        sharedProperties.setProperty("source.encoding", charset.name());
        FileEncodingQuery.setDefaultEncoding((Charset)charset);
    }

    private static void configureTags(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        sharedProperties.setProperty("tags.short", String.valueOf(false));
        sharedProperties.setProperty("tags.asp", String.valueOf(PhpLanguageProperties.ASP_TAGS_ENABLED));
    }

    private static void configureIncludePath(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        sharedProperties.setProperty("include.path", "${php.global.include.path}");
    }

    private static void configureUrl(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        privateProperties.put("url", projectProperties.getUrl());
    }

    private static void configureCopySources(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        String copyTargetString = "";
        File target = projectProperties.getCopySourcesTarget();
        if (target != null) {
            copyTargetString = target.getAbsolutePath();
        }
        privateProperties.put("copy.src.files", String.valueOf(projectProperties.isCopySources()));
        privateProperties.put("copy.src.target", copyTargetString);
        privateProperties.put("copy.src.on.open", String.valueOf(projectProperties.isCopySourcesOnOpen()));
    }

    private static void configureIndexFile(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        String indexFile = projectProperties.getIndexFile();
        if (indexFile != null) {
            privateProperties.setProperty("index.file", indexFile);
        }
    }

    private static void configureRunConfiguration(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        PhpProjectProperties.RunAsType runAs = projectProperties.getRunAsType();
        privateProperties.put("run.as", runAs.name());
        switch (runAs) {
            case SCRIPT: 
            case LOCAL: {
                break;
            }
            case REMOTE: {
                PhpProjectGenerator.configureRunAsRemoteWeb(projectProperties, sharedProperties, privateProperties);
                break;
            }
            case INTERNAL: {
                PhpProjectGenerator.configureRunAsInternalServer(projectProperties, sharedProperties, privateProperties);
                break;
            }
            default: {
                assert (false) : "Unhandled RunAsType type: " + (Object)((Object)runAs);
                break;
            }
        }
    }

    private static void configureRunAsRemoteWeb(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        RemoteConfiguration remoteConfiguration = projectProperties.getRemoteConfiguration();
        String remoteDirectory = projectProperties.getRemoteDirectory();
        PhpProjectProperties.UploadFiles uploadFiles = projectProperties.getUploadFiles();
        assert (remoteConfiguration != null);
        assert (uploadFiles != null);
        privateProperties.put("remote.connection", remoteConfiguration.getName());
        privateProperties.put("remote.directory", remoteDirectory);
        privateProperties.put("remote.upload", uploadFiles.name());
    }

    private static void configureRunAsInternalServer(ProjectProperties projectProperties, EditableProperties sharedProperties, EditableProperties privateProperties) {
        String hostname = projectProperties.getHostname();
        Integer port = projectProperties.getPort();
        String router = projectProperties.getRouter();
        assert (hostname != null);
        assert (port != null);
        privateProperties.put("hostname", hostname);
        privateProperties.put("port", String.valueOf(port));
        if (StringUtils.hasText((String)router)) {
            privateProperties.put("router", router);
        }
        privateProperties.remove((Object)"index.file");
    }

    private static void createIndexFile(FileObject template, FileObject sourceDir, String indexFile) throws IOException {
        String indexFileName = PhpProjectGenerator.getIndexFileName(indexFile, template.getExt());
        DataFolder dataFolder = DataFolder.findFolder((FileObject)sourceDir);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        DataObject index = dataTemplate.createFromTemplate(dataFolder, indexFileName);
        try {
            FileUtils.reformatFile((DataObject)index);
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, exc.getMessage(), exc);
        }
    }

    private static String getIndexFileName(String indexFile, String plannedExt) {
        String ext = "." + plannedExt;
        if (indexFile.endsWith(ext)) {
            return indexFile.substring(0, indexFile.length() - ext.length());
        }
        return indexFile;
    }

    private static void logUsage(FileObject projectDir, FileObject sourceDir, PhpProjectProperties.RunAsType runAs, Boolean copyFiles, Map<PhpFrameworkProvider, PhpModuleExtender> frameworkExtenders) {
        assert (projectDir != null);
        assert (sourceDir != null);
        PhpProjectUtils.logUsage(PhpProjectGenerator.class, "USG_PROJECT_CREATE_PHP", Arrays.asList(projectDir.equals(sourceDir) ? "EXTRA_SRC_DIR_NO" : "EXTRA_SRC_DIR_YES", runAs != null ? runAs.name() : "", "1", copyFiles != null && copyFiles != false ? "COPY_FILES_YES" : "COPY_FILES_NO", PhpProjectUtils.getFrameworksForUsage(frameworkExtenders.keySet())));
    }

    public static final class ProjectProperties {
        private File projectDirectory;
        private File sourcesDirectory;
        private String name;
        private PhpProjectProperties.RunAsType runAsType;
        private PhpVersion phpVersion;
        private Charset charset;
        private String url;
        private String indexFile;
        private WizardDescriptor descriptor;
        private Boolean copySources;
        private File copySourcesTarget;
        private Boolean copySourcesOnOpen;
        private RemoteConfiguration remoteConfiguration;
        private String remoteDirectory;
        private PhpProjectProperties.UploadFiles uploadFiles;
        private String hostname;
        private Integer port;
        private String router;
        private Map<PhpFrameworkProvider, PhpModuleExtender> frameworkExtenders;
        private Boolean autoconfigured;

        public ProjectProperties() {
        }

        public ProjectProperties(ProjectProperties properties) {
            this.projectDirectory = properties.projectDirectory;
            this.sourcesDirectory = properties.sourcesDirectory;
            this.name = properties.name;
            this.runAsType = properties.runAsType;
            this.phpVersion = properties.phpVersion;
            this.charset = properties.charset;
            this.url = properties.url;
            this.indexFile = properties.indexFile;
            this.descriptor = properties.descriptor;
            this.copySources = properties.copySources;
            this.copySourcesTarget = properties.copySourcesTarget;
            this.copySourcesOnOpen = properties.copySourcesOnOpen;
            this.remoteConfiguration = properties.remoteConfiguration;
            this.remoteDirectory = properties.remoteDirectory;
            this.uploadFiles = properties.uploadFiles;
            this.hostname = properties.hostname;
            this.port = properties.port;
            this.router = properties.router;
            this.frameworkExtenders = properties.frameworkExtenders;
            this.autoconfigured = properties.autoconfigured;
        }

        public String getName() {
            return this.name;
        }

        public ProjectProperties setName(String name) {
            assert (name != null);
            this.name = name;
            return this;
        }

        public File getSourcesDirectory() {
            return this.sourcesDirectory;
        }

        public ProjectProperties setSourcesDirectory(File sourcesDirectory) {
            assert (sourcesDirectory != null);
            this.sourcesDirectory = FileUtil.normalizeFile((File)sourcesDirectory);
            return this;
        }

        public File getProjectDirectory() {
            return this.projectDirectory;
        }

        public ProjectProperties setProjectDirectory(File projectDirectory) {
            if (projectDirectory != null) {
                projectDirectory = FileUtil.normalizeFile((File)projectDirectory);
            }
            this.projectDirectory = projectDirectory;
            return this;
        }

        public PhpProjectProperties.RunAsType getRunAsType() {
            return this.runAsType;
        }

        public ProjectProperties setRunAsType(PhpProjectProperties.RunAsType runAsType) {
            this.runAsType = runAsType;
            return this;
        }

        public PhpVersion getPhpVersion() {
            return this.phpVersion;
        }

        public ProjectProperties setPhpVersion(PhpVersion phpVersion) {
            assert (phpVersion != null);
            this.phpVersion = phpVersion;
            return this;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public ProjectProperties setCharset(Charset charset) {
            assert (charset != null);
            this.charset = charset;
            return this;
        }

        public String getUrl() {
            assert (this.url != null);
            return this.url;
        }

        public ProjectProperties setUrl(String url) {
            this.url = url;
            return this;
        }

        public Boolean isCopySources() {
            return this.copySources;
        }

        public ProjectProperties setCopySources(Boolean copySources) {
            this.copySources = copySources;
            return this;
        }

        public File getCopySourcesTarget() {
            return this.copySourcesTarget;
        }

        public ProjectProperties setCopySourcesTarget(File copySourcesTarget) {
            if (copySourcesTarget != null) {
                copySourcesTarget = FileUtil.normalizeFile((File)copySourcesTarget);
            }
            this.copySourcesTarget = copySourcesTarget;
            return this;
        }

        public Boolean isCopySourcesOnOpen() {
            return this.copySourcesOnOpen;
        }

        public ProjectProperties setCopySourcesOnOpen(Boolean copySourcesOnOpen) {
            this.copySourcesOnOpen = copySourcesOnOpen;
            return this;
        }

        public String getIndexFile() {
            return this.indexFile;
        }

        public ProjectProperties setIndexFile(String indexFile) {
            this.indexFile = indexFile;
            return this;
        }

        public WizardDescriptor getDescriptor() {
            return this.descriptor;
        }

        public ProjectProperties setDescriptor(WizardDescriptor descriptor) {
            assert (descriptor != null);
            this.descriptor = descriptor;
            return this;
        }

        public RemoteConfiguration getRemoteConfiguration() {
            return this.remoteConfiguration;
        }

        public ProjectProperties setRemoteConfiguration(RemoteConfiguration remoteConfiguration) {
            this.remoteConfiguration = remoteConfiguration;
            return this;
        }

        public String getRemoteDirectory() {
            return this.remoteDirectory;
        }

        public ProjectProperties setRemoteDirectory(String remoteDirectory) {
            this.remoteDirectory = remoteDirectory;
            return this;
        }

        public PhpProjectProperties.UploadFiles getUploadFiles() {
            return this.uploadFiles;
        }

        public ProjectProperties setUploadFiles(PhpProjectProperties.UploadFiles uploadFiles) {
            this.uploadFiles = uploadFiles;
            return this;
        }

        public String getHostname() {
            return this.hostname;
        }

        public ProjectProperties setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Integer getPort() {
            return this.port;
        }

        public ProjectProperties setPort(Integer port) {
            this.port = port;
            return this;
        }

        public String getRouter() {
            return this.router;
        }

        public ProjectProperties setRouter(String router) {
            this.router = router;
            return this;
        }

        public Map<PhpFrameworkProvider, PhpModuleExtender> getFrameworkExtenders() {
            if (this.frameworkExtenders == null) {
                return Collections.emptyMap();
            }
            return this.frameworkExtenders;
        }

        public ProjectProperties setFrameworkExtenders(Map<PhpFrameworkProvider, PhpModuleExtender> frameworkExtenders) {
            assert (frameworkExtenders != null);
            this.frameworkExtenders = frameworkExtenders;
            return this;
        }

        public Boolean getAutoconfigured() {
            return this.autoconfigured;
        }

        public ProjectProperties setAutoconfigured(Boolean autoconfigured) {
            this.autoconfigured = autoconfigured;
            return this;
        }
    }

    public static interface Monitor {
        public void starting();

        public void creatingIndexFile();

        public void finishing();
    }
}

