/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.IncludePathSupport;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.CustomizerIncludePathInternal;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CustomizerIncludePath
extends JPanel
implements HelpCtx.Provider {
    private static final Logger LOGGER = Logger.getLogger(CustomizerIncludePath.class.getName());
    private static final long serialVersionUID = 1564768521234L;
    private final ProjectCustomizer.Category category;
    private final PhpProjectProperties uiProps;
    private final PhpProject project;
    private final DefaultListModel<BasePathSupport.Item> publicIncludePathListModel;
    private final DefaultListModel<BasePathSupport.Item> privateIncludePathListModel;
    private JLabel includePathInfoLabel;
    private JLabel includePathLabel;
    private JTabbedPane includePathTabbedPane;

    public CustomizerIncludePath(ProjectCustomizer.Category category, PhpProjectProperties uiProps) {
        assert (category != null);
        assert (uiProps != null);
        this.category = category;
        this.uiProps = uiProps;
        this.project = uiProps.getProject();
        assert (this.project != null);
        this.publicIncludePathListModel = uiProps.getIncludePathListModel();
        this.privateIncludePathListModel = uiProps.getPrivateIncludePathListModel();
        this.initComponents();
        this.init();
    }

    private void init() {
        ListCellRenderer<BasePathSupport.Item> includePathListRenderer = this.uiProps.getIncludePathListRenderer();
        DefaultChangeListener defaultChangeListener = new DefaultChangeListener();
        CustomizerIncludePathInternal publicIncludePath = new CustomizerIncludePathInternal(this.project, this.publicIncludePathListModel, includePathListRenderer, "nb.php.project.includePath");
        CustomizerIncludePathInternal privateIncludePath = new CustomizerIncludePathInternal(this.project, this.privateIncludePathListModel, includePathListRenderer, "nb.php.project.includePath.private");
        publicIncludePath.addChangeListener(defaultChangeListener);
        privateIncludePath.addChangeListener(defaultChangeListener);
        this.includePathTabbedPane.add(Bundle.CustomizerIncludePath_tab_public_title(), publicIncludePath);
        this.includePathTabbedPane.add(Bundle.CustomizerIncludePath_tab_private_title(), privateIncludePath);
        this.validateData();
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        ValidationResult publicResult = new IncludePathSupport.Validator().validatePaths(this.project, this.convertToList(this.publicIncludePathListModel)).getResult();
        if (publicResult.hasErrors()) {
            this.processErrors(Bundle.CustomizerIncludePath_tab_public_title(), publicResult.getErrors(), this.publicIncludePathListModel);
            return;
        }
        ValidationResult privateResult = new IncludePathSupport.Validator().validatePaths(this.project, this.convertToList(this.privateIncludePathListModel)).getResult();
        if (privateResult.hasErrors()) {
            this.processErrors(Bundle.CustomizerIncludePath_tab_private_title(), privateResult.getErrors(), this.privateIncludePathListModel);
            return;
        }
        if (publicResult.hasWarnings()) {
            this.processWarnings(Bundle.CustomizerIncludePath_tab_public_title(), publicResult.getWarnings());
            return;
        }
        if (privateResult.hasWarnings()) {
            this.processWarnings(Bundle.CustomizerIncludePath_tab_private_title(), privateResult.getWarnings());
            return;
        }
        assert (publicResult.isFaultless()) : publicResult;
        assert (privateResult.isFaultless()) : privateResult;
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void processErrors(String prefix, List<ValidationResult.Message> errors, final DefaultListModel<BasePathSupport.Item> includePathListModel) {
        assert (EventQueue.isDispatchThread());
        assert (!errors.isEmpty());
        final ValidationResult.Message error = errors.get(0);
        if (error.isType("ANOTHER_PROJECT_MESSAGE_TYPE")) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ CustomizerIncludePath this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.askUserToFixPath(includePathListModel, (BasePathSupport.Item)error.getSource());
                }
            });
        }
        this.category.setErrorMessage(Bundle.CustomizerIncludePath_error(prefix, error.getMessage()));
        this.category.setValid(false);
    }

    private void processWarnings(String prefix, List<ValidationResult.Message> warnings) {
        assert (EventQueue.isDispatchThread());
        assert (!warnings.isEmpty());
        this.category.setErrorMessage(Bundle.CustomizerIncludePath_warning(prefix, warnings.get(0).getMessage()));
        this.category.setValid(true);
    }

    private List<BasePathSupport.Item> convertToList(DefaultListModel<BasePathSupport.Item> listModel) {
        ArrayList<BasePathSupport.Item> items = new ArrayList<BasePathSupport.Item>(listModel.getSize());
        for (int i = 0; i < listModel.getSize(); ++i) {
            items.add(listModel.get(i));
        }
        return items;
    }

    private void askUserToFixPath(DefaultListModel<BasePathSupport.Item> includePathListModel, BasePathSupport.Item item) {
        PhpProject currentProject = this.uiProps.getProject();
        FileObject fileObject = item.getFileObject(currentProject.getProjectDirectory());
        assert (fileObject != null);
        PhpProject owningProject = PhpProjectUtils.getPhpProject(fileObject);
        assert (owningProject != null);
        String owningProjectDisplayName = ProjectUtils.getInformation((Project)owningProject).getDisplayName();
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)Bundle.CustomizerPhpIncludePath_error_anotherProjectSubFile(item.getAbsoluteFilePath(currentProject.getProjectDirectory()), owningProjectDisplayName), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) != NotifyDescriptor.YES_OPTION) {
            return;
        }
        FileObject sourcesDirectory = ProjectPropertiesSupport.getSourcesDirectory(owningProject);
        if (sourcesDirectory == null) {
            LOGGER.log(Level.INFO, "Source files of project {0} not found, Include Path cannot be fixed", owningProject.getName());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.CustomizerPhpIncludePath_error_brokenProject(owningProjectDisplayName), 2));
            return;
        }
        int index = includePathListModel.indexOf(item);
        assert (index != -1);
        includePathListModel.set(index, BasePathSupport.Item.create(FileUtil.toFile((FileObject)sourcesDirectory).getAbsolutePath(), null));
    }

    private void initComponents() {
        this.includePathLabel = new JLabel();
        this.includePathTabbedPane = new JTabbedPane();
        this.includePathInfoLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.includePathLabel, (String)NbBundle.getMessage(CustomizerIncludePath.class, (String)"CustomizerIncludePath.includePathLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.includePathInfoLabel, (String)NbBundle.getMessage(CustomizerIncludePath.class, (String)"CustomizerIncludePath.includePathInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includePathLabel).addComponent(this.includePathInfoLabel, -2, -1, -2).addComponent(this.includePathTabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.includePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includePathTabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includePathInfoLabel, -2, -1, -2)));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.customizer.CustomizerPhpIncludePath");
    }

    private final class DefaultChangeListener
    implements ChangeListener {
        private DefaultChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CustomizerIncludePath.this.validateData();
        }
    }
}

