/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.api.beans.model.SpringModel;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class SpringBeansELVariableResolver
implements ELVariableResolver {
    private static final Logger LOG = Logger.getLogger(SpringBeansELVariableResolver.class.getName());
    private static final String CONTENT_NAME = "SpringBeans";

    public ELVariableResolver.FieldInfo getInjectableField(String beanName, FileObject target, ResolverContext context) {
        for (SpringBean bean : this.getSpringBeans(target, context)) {
            if (!beanName.equals(SpringBeansELVariableResolver.getBeanName(bean))) continue;
            return new ELVariableResolver.FieldInfo(bean.getClassName());
        }
        return null;
    }

    public String getBeanName(String clazz, FileObject target, ResolverContext context) {
        for (SpringBean bean : this.getSpringBeans(target, context)) {
            if (!clazz.equals(bean.getClassName())) continue;
            return SpringBeansELVariableResolver.getBeanName(bean);
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject target, ResolverContext context) {
        List<SpringBean> beans = this.getSpringBeans(target, context);
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>(beans.size());
        for (SpringBean bean : beans) {
            String beanName = SpringBeansELVariableResolver.getBeanName(bean);
            if (beanName == null) continue;
            result.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)SpringBeansELVariableResolver.getBeanName(bean), (String)bean.getClassName()));
        }
        return result;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int offset, ResolverContext context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String scope, Snapshot snapshot, ResolverContext context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String name, Snapshot snapshot, ResolverContext context) {
        return Collections.emptyList();
    }

    private List<SpringBean> getSpringBeans(FileObject target, ResolverContext context) {
        SpringScope scope = SpringScope.getSpringScope((FileObject)target);
        if (scope == null) {
            return Collections.emptyList();
        }
        if (context.getContent(CONTENT_NAME) == null) {
            context.setContent(CONTENT_NAME, this.getBeansFromScope(target, scope));
        }
        return (List)context.getContent(CONTENT_NAME);
    }

    private List<SpringBean> getBeansFromScope(FileObject target, SpringScope scope) {
        final ArrayList<SpringBean> springBeans = new ArrayList<SpringBean>();
        for (SpringConfigModel model : scope.getAllConfigModels()) {
            try {
                model.runReadAction((Action)new Action<SpringBeans>(){
                    final /* synthetic */ SpringBeansELVariableResolver this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run(SpringBeans beans) {
                        springBeans.addAll(beans.getBeans());
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        springBeans.addAll(SpringBeansELVariableResolver.getAnnotatedBeans((MetadataModel<SpringModel>)scope.getSpringAnnotationModel(target)));
        return springBeans;
    }

    private static String getBeanName(SpringBean bean) {
        String beanName = null;
        Iterator iterator = bean.getNames().iterator();
        if (iterator.hasNext()) {
            String name;
            beanName = name = (String)iterator.next();
        }
        if (beanName == null) {
            beanName = bean.getId();
        }
        return beanName;
    }

    private static List<SpringBean> getAnnotatedBeans(MetadataModel<SpringModel> model) {
        try {
            return (List)model.runReadAction((MetadataModelAction)new MetadataModelAction<SpringModel, List<SpringBean>>(){

                public List<SpringBean> run(SpringModel model) throws Exception {
                    LinkedList<SpringBean> beans = new LinkedList<SpringBean>();
                    beans.addAll(model.getBeans());
                    return beans;
                }
            });
        }
        catch (MetadataModelException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        return Collections.emptyList();
    }
}

