/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public class Utils {
    public static final String KEY_CCLS_PATH = "ccls";
    public static final String KEY_CLANGD_PATH = "clangd";
    public static final String KEY_PREFFERED_LS = "preferredLS";
    public static final String[] AVAILABLE_LS = new String[]{"ccls", "clangd"};
    private static final String[] CCLS_NAMES = new String[]{"ccls"};
    private static final String[] CLANGD_NAMES = new String[]{"clangd-10", "clangd", "clangd-9"};
    private static List<String> cclsAutodetectedPaths;
    private static List<String> clangdAutodetectedPaths;
    private static final Logger LOGGER;

    public static Preferences settings() {
        return NbPreferences.forModule(Utils.class);
    }

    public static synchronized String getCCLSPath() {
        String path = Utils.settings().get(KEY_CCLS_PATH, null);
        if (path == null || path.isEmpty()) {
            if (cclsAutodetectedPaths == null) {
                cclsAutodetectedPaths = Utils.findFileOnUsersPath(CCLS_NAMES);
            }
            if (!cclsAutodetectedPaths.isEmpty()) {
                path = cclsAutodetectedPaths.get(0);
            }
        }
        if (path == null || path.isEmpty()) {
            return null;
        }
        return path;
    }

    public static synchronized String getCLANGDPath() {
        String path = Utils.settings().get(KEY_CLANGD_PATH, null);
        if (path == null || path.isEmpty()) {
            if (clangdAutodetectedPaths == null) {
                clangdAutodetectedPaths = Utils.findFileOnUsersPath(CLANGD_NAMES);
            }
            if (!clangdAutodetectedPaths.isEmpty()) {
                path = clangdAutodetectedPaths.get(0);
            }
        }
        if (path == null || path.isEmpty()) {
            return null;
        }
        return path;
    }

    public static String getPreferredLs() {
        String preferredLs = Utils.settings().get(KEY_PREFFERED_LS, KEY_CCLS_PATH);
        if (Arrays.stream(AVAILABLE_LS).anyMatch(s -> s.equals(preferredLs))) {
            return preferredLs;
        }
        return KEY_CCLS_PATH;
    }

    public static List<String> findFileOnUsersPath(String ... filenames) {
        Parameters.notNull((CharSequence)"filenames", (Object)filenames);
        String path = System.getenv("PATH");
        LOGGER.log(Level.FINE, "PATH: [{0}]", path);
        if (path == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>(Arrays.asList(path.split(File.pathSeparator)));
        LOGGER.log(Level.FINE, "PATH dirs: {0}", dirs);
        ArrayList<String> found = new ArrayList<String>(dirs.size() * filenames.length);
        for (String filename : filenames) {
            Parameters.notNull((CharSequence)"filename", (Object)filename);
            for (String dir : dirs) {
                File file = new File(dir, filename);
                if (!file.isFile()) continue;
                String absolutePath = FileUtil.normalizeFile((File)file).getAbsolutePath();
                LOGGER.log(Level.FINE, "File ''{0}'' found", absolutePath);
                if (found.contains(absolutePath)) continue;
                LOGGER.log(Level.FINE, "File ''{0}'' added to found files", absolutePath);
                found.add(absolutePath);
            }
        }
        LOGGER.log(Level.FINE, "Found files: {0}", found);
        return found;
    }

    static {
        LOGGER = Logger.getLogger(Utils.class.getName());
    }
}

