/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.swing.JDialog;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.InterceptorsResult;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.BindingsPanel;
import org.netbeans.modules.web.beans.navigation.DecoratorsModel;
import org.netbeans.modules.web.beans.navigation.DecoratorsPanel;
import org.netbeans.modules.web.beans.navigation.EventsModel;
import org.netbeans.modules.web.beans.navigation.EventsPanel;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.InterceptorsModel;
import org.netbeans.modules.web.beans.navigation.InterceptorsPanel;
import org.netbeans.modules.web.beans.navigation.ObserversModel;
import org.netbeans.modules.web.beans.navigation.ObserversPanel;
import org.netbeans.modules.web.beans.navigation.ResizablePopup;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.ModelActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.PositionStrategy;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebBeansActionHelper {
    private static final String WAIT_NODE = "LBL_WaitNode";
    static final String DELEGATE = "javax.decorator.Delegate";
    static final String DELEGATE_JAKARTA = "jakarta.decorator.Delegate";
    static final String DECORATOR = "javax.decorator.Decorator";
    static final String DECORATOR_JAKARTA = "jakarta.decorator.Decorator";
    static final String EVENT_INTERFACE = "javax.enterprise.event.Event";
    static final String EVENT_INTERFACE_JAKARTA = "jakarta.enterprise.event.Event";
    static final String OBSERVES_ANNOTATION = "javax.enterprise.event.Observes";
    static final String OBSERVES_ANNOTATION_JAKARTA = "jakarta.enterprise.event.Observes";
    static final String FIRE = "fire";
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = EnumSet.of(JavaTokenId.IDENTIFIER, JavaTokenId.THIS, JavaTokenId.SUPER);
    private static final PositionStrategy CARET_POSITION_STRATEGY = new PositionStrategy(){

        @Override
        public int getOffset(JTextComponent component) {
            return component.getCaret().getDot();
        }
    };

    private WebBeansActionHelper() {
    }

    public static boolean isEnabled() {
        JTextComponent c = EditorRegistry.lastFocusedComponent();
        if (c == null || !c.isShowing()) {
            return false;
        }
        if (OpenProjects.getDefault().getOpenProjects().length == 0) {
            return false;
        }
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)c.getDocument());
        return WebBeansActionHelper.isEnabled(fileObject);
    }

    public static boolean isEnabled(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        boolean hasJsr330 = WebBeansActionHelper.hasJsr330(project);
        if (!hasJsr330) {
            return false;
        }
        return WebBeansActionHelper.hasJsr299(project);
    }

    public static boolean hasJsr330(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups.length == 0) {
            return false;
        }
        boolean hasInject = false;
        boolean hasQualifier = false;
        for (SourceGroup sourceGroup : sourceGroups) {
            boolean qualifierFound;
            boolean injectFound;
            boolean bl = injectFound = WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "javax.inject.Inject") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "javax.inject.Inject") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "jakarta.inject.Inject") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "jakarta.inject.Inject");
            if (injectFound) {
                hasInject = true;
            }
            boolean bl2 = qualifierFound = WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "javax.inject.Qualifier") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "javax.inject.Qualifier") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "jakarta.inject.Qualifier") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "jakarta.inject.Qualifier");
            if (!qualifierFound) continue;
            hasQualifier = true;
        }
        return hasInject && hasQualifier;
    }

    public static boolean hasJsr299(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups.length == 0) {
            return false;
        }
        boolean hasDefault = false;
        boolean hasProduces = false;
        boolean hasDependent = false;
        for (SourceGroup sourceGroup : sourceGroups) {
            boolean dependentFound;
            boolean producesFound;
            boolean defaultFound;
            boolean bl = defaultFound = WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "javax.enterprise.inject.Default") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "javax.enterprise.inject.Default") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "jakarta.enterprise.inject.Default") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "jakarta.enterprise.inject.Default");
            if (defaultFound) {
                hasDefault = true;
            }
            boolean bl2 = producesFound = WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "javax.enterprise.inject.Produces") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "javax.enterprise.inject.Produces") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "jakarta.enterprise.inject.Produces") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "jakarta.enterprise.inject.Produces");
            if (producesFound) {
                hasProduces = true;
            }
            boolean bl3 = dependentFound = WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "javax.enterprise.context.Dependent") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "javax.enterprise.context.Dependent") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/compile", "jakarta.enterprise.context.Dependent") || WebBeansActionHelper.hasResource(sourceGroup, "classpath/source", "jakarta.enterprise.context.Dependent");
            if (!dependentFound) continue;
            hasDependent = true;
        }
        return hasDefault && hasProduces && hasDependent;
    }

    static boolean hasResource(SourceGroup group, String classPathType, String fqn) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)group.getRootFolder(), (String)classPathType);
        String path = fqn.replace('.', '/');
        path = "classpath/source".equals(classPathType) ? path + ".java" : path + ".class";
        if (classPath == null) {
            return false;
        }
        return classPath.findResource(path) != null;
    }

    static boolean getVariableElementAtDot(JTextComponent component, Object[] variable, boolean showStatusOnError) {
        return WebBeansActionHelper.getVariableElementAtDot(component, variable, showStatusOnError, CARET_POSITION_STRATEGY);
    }

    static boolean getVariableElementAtDot(final JTextComponent component, final Object[] variable, final boolean showStatusOnError, final PositionStrategy strategy) {
        JavaSource javaSource = JavaSource.forDocument((Document)component.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    int dot = strategy.getOffset(component);
                    TreePath tp = controller.getTreeUtilities().pathFor(dot);
                    Element contextElement = controller.getTrees().getElement(tp);
                    if (contextElement == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_ElementNotFound"));
                        return;
                    }
                    Element element = WebBeansActionHelper.getContextElement(contextElement, controller);
                    if (element == null) {
                        return;
                    }
                    if (!(element instanceof VariableElement) && showStatusOnError) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_NotVariableElement", (Object)700));
                        return;
                    }
                    if (element.getKind() == ElementKind.FIELD) {
                        ElementHandle handle = ElementHandle.create((Element)((VariableElement)element));
                        variable[0] = handle;
                        variable[1] = element.getSimpleName().toString();
                        variable[2] = ModelActionStrategy.InspectActionId.INJECTABLES_CONTEXT;
                    } else {
                        WebBeansActionHelper.setVariablePath(variable, controller, element);
                    }
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(GoToInjectableAtCaretAction.class.getName()).log(Level.INFO, e.getMessage(), e);
        }
        return variable[1] != null;
    }

    static Element getContextElement(Element element, CompilationController controller) {
        if (element instanceof TypeElement) {
            if (WebBeansActionHelper.hasAnnotation(element, DECORATOR) || WebBeansActionHelper.hasAnnotation(element, DECORATOR_JAKARTA)) {
                List<VariableElement> fieldsIn = ElementFilter.fieldsIn(controller.getElements().getAllMembers((TypeElement)element));
                for (VariableElement variableElement : fieldsIn) {
                    if (!WebBeansActionHelper.hasAnnotation(variableElement, DELEGATE) && !WebBeansActionHelper.hasAnnotation(element, DELEGATE_JAKARTA)) continue;
                    return variableElement;
                }
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_NotDecorator"));
            }
            return null;
        }
        return element;
    }

    static boolean hasAnnotation(Element element, String fqn) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Name qualifiedName;
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Element annotationElement = annotationType.asElement();
            if (!(annotationElement instanceof TypeElement) || !(qualifiedName = ((TypeElement)annotationElement).getQualifiedName()).contentEquals(fqn)) continue;
            return true;
        }
        return false;
    }

    static boolean getClassAtDot(JTextComponent component, Object[] subject) {
        return WebBeansActionHelper.getClassAtDot(component, subject, CARET_POSITION_STRATEGY);
    }

    static boolean getClassAtDot(final JTextComponent component, final Object[] subject, final PositionStrategy strategy) {
        JavaSource javaSource = JavaSource.forDocument((Document)component.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    int dot = strategy.getOffset(component);
                    TreePath tp = controller.getTreeUtilities().pathFor(dot);
                    Element element = controller.getTrees().getElement(tp);
                    if (element == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_ElementNotFound"));
                        return;
                    }
                    if (element instanceof TypeElement) {
                        subject[0] = ElementHandle.create((Element)element);
                        subject[1] = element.getSimpleName();
                        subject[2] = ModelActionStrategy.InspectActionId.CLASS_CONTEXT;
                    }
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(WebBeansActionHelper.class.getName()).log(Level.WARNING, e.getMessage(), e);
        }
        return subject[0] != null;
    }

    static boolean getMethodAtDot(final JTextComponent component, final Object[] subject, final PositionStrategy strategy) {
        JavaSource javaSource = JavaSource.forDocument((Document)component.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    Element enclosingElement;
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    int dot = strategy.getOffset(component);
                    TreePath tp = controller.getTreeUtilities().pathFor(dot);
                    Element element = controller.getTrees().getElement(tp);
                    if (element == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_ElementNotFound"));
                        return;
                    }
                    if (element instanceof ExecutableElement) {
                        subject[0] = ElementHandle.create((Element)element);
                        subject[1] = element.getSimpleName();
                        subject[2] = ModelActionStrategy.InspectActionId.METHOD_CONTEXT;
                    } else if (element instanceof VariableElement && (enclosingElement = element.getEnclosingElement()) instanceof ExecutableElement && (WebBeansActionHelper.hasAnnotation(element, WebBeansActionHelper.OBSERVES_ANNOTATION) || WebBeansActionHelper.hasAnnotation(element, WebBeansActionHelper.OBSERVES_ANNOTATION_JAKARTA))) {
                        subject[0] = ElementHandle.create((Element)enclosingElement);
                        subject[1] = enclosingElement.getSimpleName();
                        subject[2] = ModelActionStrategy.InspectActionId.METHOD_CONTEXT;
                    }
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(WebBeansActionHelper.class.getName()).log(Level.WARNING, e.getMessage(), e);
        }
        return subject[0] != null;
    }

    static boolean getMethodAtDot(JTextComponent component, Object[] subject) {
        return WebBeansActionHelper.getMethodAtDot(component, subject, CARET_POSITION_STRATEGY);
    }

    public static boolean getContextEventInjectionAtDot(final JTextComponent component, final Object[] variable, final PositionStrategy strategy) {
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)component.getDocument())), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ExpressionTree select;
                    Tree parentLeaf;
                    Parser.Result resuslt = resultIterator.getParserResult(strategy.getOffset(component));
                    CompilationController controller = CompilationController.get((Parser.Result)resuslt);
                    if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    Token[] token = new Token[1];
                    int[] span = WebBeansActionHelper.getIdentifierSpan(component.getDocument(), strategy.getOffset(component), token);
                    if (span == null) {
                        return;
                    }
                    int exactOffset = controller.getSnapshot().getEmbeddedOffset(span[0] + 1);
                    TreePath path = controller.getTreeUtilities().pathFor(exactOffset);
                    TreePath parent = path.getParentPath();
                    if (parent != null && (parentLeaf = parent.getLeaf()).getKind() == Tree.Kind.METHOD_INVOCATION && (select = ((MethodInvocationTree)parentLeaf).getMethodSelect()).getKind() == Tree.Kind.MEMBER_SELECT) {
                        Scope scope = controller.getTrees().getScope(path);
                        TypeElement subjectClass = scope.getEnclosingClass();
                        Element method = controller.getTrees().getElement(new TreePath(path, select));
                        Element caller = controller.getTrees().getElement(new TreePath(path, ((MemberSelectTree)select).getExpression()));
                        String methodName = method.getSimpleName().toString();
                        if (WebBeansActionHelper.FIRE.equals(methodName) && method instanceof ExecutableElement && caller instanceof VariableElement) {
                            String variableName = caller.getSimpleName().toString();
                            TypeElement enclosingTypeElement = controller.getElementUtilities().enclosingTypeElement(method);
                            String fqnMethodClass = enclosingTypeElement.getQualifiedName().toString();
                            if (WebBeansActionHelper.EVENT_INTERFACE.equals(fqnMethodClass) || WebBeansActionHelper.EVENT_INTERFACE_JAKARTA.equals(fqnMethodClass)) {
                                List<VariableElement> fields = ElementFilter.fieldsIn(controller.getElements().getAllMembers(subjectClass));
                                for (VariableElement var : fields) {
                                    String varName = var.getSimpleName().toString();
                                    if (!variableName.equals(varName)) continue;
                                    ElementHandle handle = ElementHandle.create((Element)var);
                                    variable[0] = handle;
                                    variable[1] = varName;
                                    variable[2] = ModelActionStrategy.InspectActionId.OBSERVERS_CONTEXT;
                                    return;
                                }
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        return variable[1] != null;
    }

    public static boolean getContextEventInjectionAtDot(JTextComponent component, Object[] variable) {
        return WebBeansActionHelper.getContextEventInjectionAtDot(component, variable, CARET_POSITION_STRATEGY);
    }

    static void showInjectablesDialog(MetadataModel<WebBeansModel> metamodel, WebBeansModel model, Object[] subject, InjectablesModel uiModel, String name, Result result) {
        subject[2] = ModelActionStrategy.InspectActionId.INJECTABLES_CONTEXT;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)WAIT_NODE));
        JDialog dialog = ResizablePopup.getDialog();
        String title = NbBundle.getMessage(WebBeansActionHelper.class, (String)"TITLE_Injectables", (Object)name);
        dialog.setTitle(title);
        dialog.setContentPane(new BindingsPanel(subject, metamodel, model, uiModel, result));
        dialog.setVisible(true);
    }

    static void showEventsDialog(MetadataModel<WebBeansModel> metaModel, WebBeansModel model, Object[] subject, EventsModel uiModel, String name) {
        subject[2] = ModelActionStrategy.InspectActionId.METHOD_CONTEXT;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)WAIT_NODE));
        JDialog dialog = ResizablePopup.getDialog();
        String title = NbBundle.getMessage(WebBeansActionHelper.class, (String)"TITLE_Events", (Object)name);
        dialog.setTitle(title);
        dialog.setContentPane(new EventsPanel(subject, metaModel, model, uiModel));
        dialog.setVisible(true);
    }

    static void showObserversDialog(List<ExecutableElement> methods, MetadataModel<WebBeansModel> metaModel, WebBeansModel model, Object[] subject, ObserversModel uiModel, String name) {
        subject[2] = ModelActionStrategy.InspectActionId.OBSERVERS_CONTEXT;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)WAIT_NODE));
        JDialog dialog = ResizablePopup.getDialog();
        String title = NbBundle.getMessage(WebBeansActionHelper.class, (String)"TITLE_Observers", (Object)name);
        dialog.setTitle(title);
        dialog.setContentPane(new ObserversPanel(subject, metaModel, model, uiModel));
        dialog.setVisible(true);
    }

    public static void showDecoratorsDialog(MetadataModel<WebBeansModel> metaModel, WebBeansModel model, Object[] subject, DecoratorsModel uiModel, String name) {
        subject[2] = ModelActionStrategy.InspectActionId.CLASS_CONTEXT;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)WAIT_NODE));
        JDialog dialog = ResizablePopup.getDialog();
        String title = NbBundle.getMessage(WebBeansActionHelper.class, (String)"TITLE_Decorators", (Object)name);
        dialog.setTitle(title);
        dialog.setContentPane(new DecoratorsPanel(subject, metaModel, model, uiModel));
        dialog.setVisible(true);
    }

    static void showInterceptorsDialog(MetadataModel<WebBeansModel> metaModel, WebBeansModel model, Object[] subject, InterceptorsModel uiModel, String name, InterceptorsResult result) {
        subject[2] = ModelActionStrategy.InspectActionId.CLASS_CONTEXT;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)WAIT_NODE));
        JDialog dialog = ResizablePopup.getDialog();
        String title = NbBundle.getMessage(WebBeansActionHelper.class, (String)"TITLE_Interceptors", (Object)name);
        dialog.setTitle(title);
        dialog.setContentPane(new InterceptorsPanel(subject, metaModel, model, uiModel, result));
        dialog.setVisible(true);
    }

    public static LinkedHashSet<TypeElement> getEnabledDecorators(Collection<TypeElement> decorators, BeansModel beansModel, LinkedHashSet<ElementHandle<TypeElement>> enabledHandles, CompilationController controller) {
        LinkedHashSet<TypeElement> enabled = new LinkedHashSet<TypeElement>();
        HashSet<TypeElement> foundDecorators = new HashSet<TypeElement>(decorators);
        LinkedHashSet<String> decoratorClasses = beansModel.getDecoratorClasses();
        for (String decorator : decoratorClasses) {
            TypeElement enabledDecorator = controller.getElements().getTypeElement(decorator);
            if (!foundDecorators.contains(enabledDecorator)) continue;
            enabled.add(enabledDecorator);
            if (enabledHandles == null) continue;
            enabledHandles.add((ElementHandle<TypeElement>)ElementHandle.create((Element)enabledDecorator));
        }
        return enabled;
    }

    public static VariableElement findVariable(WebBeansModel model, Object[] variablePath) {
        if (variablePath[0] == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_VariableNotFound", (Object)variablePath[1]));
            return null;
        }
        Element element = ((ElementHandle)variablePath[0]).resolve((CompilationInfo)model.getCompilationController());
        if (element == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_VariableNotFound", (Object)variablePath[1]));
            return null;
        }
        VariableElement var = null;
        ExecutableElement method = null;
        if (element.getKind() == ElementKind.FIELD) {
            var = (VariableElement)element;
        } else {
            method = (ExecutableElement)element;
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                if (!variableElement.getSimpleName().contentEquals(variablePath[1].toString())) continue;
                var = variableElement;
            }
        }
        if (var == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_VariableNotFound", (Object)variablePath[1]));
        }
        return var;
    }

    static int[] getIdentifierSpan(Document doc, int offset, Token<JavaTokenId>[] token) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)doc);
        if (fileObject == null) {
            return null;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        if (JavaTokenId.JAVADOC_COMMENT == t.id()) {
            return null;
        }
        if (!USABLE_TOKEN_IDS.contains(t.id())) {
            ts.move(offset - 1);
            if (!ts.moveNext()) {
                return null;
            }
            t = ts.token();
            if (!USABLE_TOKEN_IDS.contains(t.id())) {
                return null;
            }
        }
        if (token != null) {
            token[0] = t;
        }
        return new int[]{ts.offset(), ts.offset() + t.length()};
    }

    private static void setVariablePath(Object[] variableAtCaret, CompilationController controller, Element element) {
        Element parent = element.getEnclosingElement();
        if (parent instanceof ExecutableElement) {
            ElementHandle handle = ElementHandle.create((Element)((ExecutableElement)parent));
            variableAtCaret[0] = handle;
            variableAtCaret[1] = element.getSimpleName().toString();
            variableAtCaret[2] = ModelActionStrategy.InspectActionId.INJECTABLES_CONTEXT;
        }
    }
}

