/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.ActualBuildRunnerShapeConfig;
import com.oracle.bmc.devops.model.BuildPipelineStagePredecessorCollection;
import com.oracle.bmc.devops.model.BuildPipelineStageRunProgress;
import com.oracle.bmc.devops.model.BuildSourceCollection;
import com.oracle.bmc.devops.model.BuildStageRunStep;
import com.oracle.bmc.devops.model.ExportedVariableCollection;
import com.oracle.bmc.devops.model.NetworkChannel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="buildPipelineStageType")
@JsonFilter(value="explicitlySetFilter")
public final class BuildStageRunProgress
extends BuildPipelineStageRunProgress {
    @JsonProperty(value="actualBuildRunnerShape")
    private final String actualBuildRunnerShape;
    @JsonProperty(value="actualBuildRunnerShapeConfig")
    private final ActualBuildRunnerShapeConfig actualBuildRunnerShapeConfig;
    @JsonProperty(value="image")
    private final Image image;
    @JsonProperty(value="buildSpecFile")
    private final String buildSpecFile;
    @JsonProperty(value="stageExecutionTimeoutInSeconds")
    private final Integer stageExecutionTimeoutInSeconds;
    @JsonProperty(value="buildSourceCollection")
    private final BuildSourceCollection buildSourceCollection;
    @JsonProperty(value="primaryBuildSource")
    private final String primaryBuildSource;
    @JsonProperty(value="steps")
    private final List<BuildStageRunStep> steps;
    @JsonProperty(value="exportedVariables")
    private final ExportedVariableCollection exportedVariables;
    @JsonProperty(value="privateAccessConfig")
    private final NetworkChannel privateAccessConfig;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BuildStageRunProgress(String stageDisplayName, String buildPipelineStageId, Date timeStarted, Date timeFinished, BuildPipelineStageRunProgress.Status status, BuildPipelineStagePredecessorCollection buildPipelineStagePredecessors, String actualBuildRunnerShape, ActualBuildRunnerShapeConfig actualBuildRunnerShapeConfig, Image image, String buildSpecFile, Integer stageExecutionTimeoutInSeconds, BuildSourceCollection buildSourceCollection, String primaryBuildSource, List<BuildStageRunStep> steps, ExportedVariableCollection exportedVariables, NetworkChannel privateAccessConfig) {
        super(stageDisplayName, buildPipelineStageId, timeStarted, timeFinished, status, buildPipelineStagePredecessors);
        this.actualBuildRunnerShape = actualBuildRunnerShape;
        this.actualBuildRunnerShapeConfig = actualBuildRunnerShapeConfig;
        this.image = image;
        this.buildSpecFile = buildSpecFile;
        this.stageExecutionTimeoutInSeconds = stageExecutionTimeoutInSeconds;
        this.buildSourceCollection = buildSourceCollection;
        this.primaryBuildSource = primaryBuildSource;
        this.steps = steps;
        this.exportedVariables = exportedVariables;
        this.privateAccessConfig = privateAccessConfig;
    }

    public String getActualBuildRunnerShape() {
        return this.actualBuildRunnerShape;
    }

    public ActualBuildRunnerShapeConfig getActualBuildRunnerShapeConfig() {
        return this.actualBuildRunnerShapeConfig;
    }

    public Image getImage() {
        return this.image;
    }

    public String getBuildSpecFile() {
        return this.buildSpecFile;
    }

    public Integer getStageExecutionTimeoutInSeconds() {
        return this.stageExecutionTimeoutInSeconds;
    }

    public BuildSourceCollection getBuildSourceCollection() {
        return this.buildSourceCollection;
    }

    public String getPrimaryBuildSource() {
        return this.primaryBuildSource;
    }

    public List<BuildStageRunStep> getSteps() {
        return this.steps;
    }

    public ExportedVariableCollection getExportedVariables() {
        return this.exportedVariables;
    }

    public NetworkChannel getPrivateAccessConfig() {
        return this.privateAccessConfig;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BuildStageRunProgress(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", actualBuildRunnerShape=").append(String.valueOf(this.actualBuildRunnerShape));
        sb.append(", actualBuildRunnerShapeConfig=").append(String.valueOf((Object)this.actualBuildRunnerShapeConfig));
        sb.append(", image=").append(String.valueOf((Object)this.image));
        sb.append(", buildSpecFile=").append(String.valueOf(this.buildSpecFile));
        sb.append(", stageExecutionTimeoutInSeconds=").append(String.valueOf(this.stageExecutionTimeoutInSeconds));
        sb.append(", buildSourceCollection=").append(String.valueOf((Object)this.buildSourceCollection));
        sb.append(", primaryBuildSource=").append(String.valueOf(this.primaryBuildSource));
        sb.append(", steps=").append(String.valueOf(this.steps));
        sb.append(", exportedVariables=").append(String.valueOf((Object)this.exportedVariables));
        sb.append(", privateAccessConfig=").append(String.valueOf((Object)this.privateAccessConfig));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildStageRunProgress)) {
            return false;
        }
        BuildStageRunProgress other = (BuildStageRunProgress)((Object)o);
        return Objects.equals(this.actualBuildRunnerShape, other.actualBuildRunnerShape) && Objects.equals((Object)this.actualBuildRunnerShapeConfig, (Object)other.actualBuildRunnerShapeConfig) && Objects.equals((Object)this.image, (Object)other.image) && Objects.equals(this.buildSpecFile, other.buildSpecFile) && Objects.equals(this.stageExecutionTimeoutInSeconds, other.stageExecutionTimeoutInSeconds) && Objects.equals((Object)this.buildSourceCollection, (Object)other.buildSourceCollection) && Objects.equals(this.primaryBuildSource, other.primaryBuildSource) && Objects.equals(this.steps, other.steps) && Objects.equals((Object)this.exportedVariables, (Object)other.exportedVariables) && Objects.equals((Object)this.privateAccessConfig, (Object)other.privateAccessConfig) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.actualBuildRunnerShape == null ? 43 : this.actualBuildRunnerShape.hashCode());
        result = result * 59 + (this.actualBuildRunnerShapeConfig == null ? 43 : this.actualBuildRunnerShapeConfig.hashCode());
        result = result * 59 + (this.image == null ? 43 : this.image.hashCode());
        result = result * 59 + (this.buildSpecFile == null ? 43 : this.buildSpecFile.hashCode());
        result = result * 59 + (this.stageExecutionTimeoutInSeconds == null ? 43 : this.stageExecutionTimeoutInSeconds.hashCode());
        result = result * 59 + (this.buildSourceCollection == null ? 43 : this.buildSourceCollection.hashCode());
        result = result * 59 + (this.primaryBuildSource == null ? 43 : this.primaryBuildSource.hashCode());
        result = result * 59 + (this.steps == null ? 43 : this.steps.hashCode());
        result = result * 59 + (this.exportedVariables == null ? 43 : this.exportedVariables.hashCode());
        result = result * 59 + (this.privateAccessConfig == null ? 43 : this.privateAccessConfig.hashCode());
        return result;
    }

    public static enum Image implements BmcEnum
    {
        Ol7X8664Standard10("OL7_X86_64_STANDARD_10"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Image> map;

        private Image(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Image create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Image', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Image.class);
            map = new HashMap<String, Image>();
            for (Image v : Image.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stageDisplayName")
        private String stageDisplayName;
        @JsonProperty(value="buildPipelineStageId")
        private String buildPipelineStageId;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="status")
        private BuildPipelineStageRunProgress.Status status;
        @JsonProperty(value="buildPipelineStagePredecessors")
        private BuildPipelineStagePredecessorCollection buildPipelineStagePredecessors;
        @JsonProperty(value="actualBuildRunnerShape")
        private String actualBuildRunnerShape;
        @JsonProperty(value="actualBuildRunnerShapeConfig")
        private ActualBuildRunnerShapeConfig actualBuildRunnerShapeConfig;
        @JsonProperty(value="image")
        private Image image;
        @JsonProperty(value="buildSpecFile")
        private String buildSpecFile;
        @JsonProperty(value="stageExecutionTimeoutInSeconds")
        private Integer stageExecutionTimeoutInSeconds;
        @JsonProperty(value="buildSourceCollection")
        private BuildSourceCollection buildSourceCollection;
        @JsonProperty(value="primaryBuildSource")
        private String primaryBuildSource;
        @JsonProperty(value="steps")
        private List<BuildStageRunStep> steps;
        @JsonProperty(value="exportedVariables")
        private ExportedVariableCollection exportedVariables;
        @JsonProperty(value="privateAccessConfig")
        private NetworkChannel privateAccessConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stageDisplayName(String stageDisplayName) {
            this.stageDisplayName = stageDisplayName;
            this.__explicitlySet__.add("stageDisplayName");
            return this;
        }

        public Builder buildPipelineStageId(String buildPipelineStageId) {
            this.buildPipelineStageId = buildPipelineStageId;
            this.__explicitlySet__.add("buildPipelineStageId");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder status(BuildPipelineStageRunProgress.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder buildPipelineStagePredecessors(BuildPipelineStagePredecessorCollection buildPipelineStagePredecessors) {
            this.buildPipelineStagePredecessors = buildPipelineStagePredecessors;
            this.__explicitlySet__.add("buildPipelineStagePredecessors");
            return this;
        }

        public Builder actualBuildRunnerShape(String actualBuildRunnerShape) {
            this.actualBuildRunnerShape = actualBuildRunnerShape;
            this.__explicitlySet__.add("actualBuildRunnerShape");
            return this;
        }

        public Builder actualBuildRunnerShapeConfig(ActualBuildRunnerShapeConfig actualBuildRunnerShapeConfig) {
            this.actualBuildRunnerShapeConfig = actualBuildRunnerShapeConfig;
            this.__explicitlySet__.add("actualBuildRunnerShapeConfig");
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }

        public Builder buildSpecFile(String buildSpecFile) {
            this.buildSpecFile = buildSpecFile;
            this.__explicitlySet__.add("buildSpecFile");
            return this;
        }

        public Builder stageExecutionTimeoutInSeconds(Integer stageExecutionTimeoutInSeconds) {
            this.stageExecutionTimeoutInSeconds = stageExecutionTimeoutInSeconds;
            this.__explicitlySet__.add("stageExecutionTimeoutInSeconds");
            return this;
        }

        public Builder buildSourceCollection(BuildSourceCollection buildSourceCollection) {
            this.buildSourceCollection = buildSourceCollection;
            this.__explicitlySet__.add("buildSourceCollection");
            return this;
        }

        public Builder primaryBuildSource(String primaryBuildSource) {
            this.primaryBuildSource = primaryBuildSource;
            this.__explicitlySet__.add("primaryBuildSource");
            return this;
        }

        public Builder steps(List<BuildStageRunStep> steps) {
            this.steps = steps;
            this.__explicitlySet__.add("steps");
            return this;
        }

        public Builder exportedVariables(ExportedVariableCollection exportedVariables) {
            this.exportedVariables = exportedVariables;
            this.__explicitlySet__.add("exportedVariables");
            return this;
        }

        public Builder privateAccessConfig(NetworkChannel privateAccessConfig) {
            this.privateAccessConfig = privateAccessConfig;
            this.__explicitlySet__.add("privateAccessConfig");
            return this;
        }

        public BuildStageRunProgress build() {
            BuildStageRunProgress model = new BuildStageRunProgress(this.stageDisplayName, this.buildPipelineStageId, this.timeStarted, this.timeFinished, this.status, this.buildPipelineStagePredecessors, this.actualBuildRunnerShape, this.actualBuildRunnerShapeConfig, this.image, this.buildSpecFile, this.stageExecutionTimeoutInSeconds, this.buildSourceCollection, this.primaryBuildSource, this.steps, this.exportedVariables, this.privateAccessConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BuildStageRunProgress model) {
            if (model.wasPropertyExplicitlySet("stageDisplayName")) {
                this.stageDisplayName(model.getStageDisplayName());
            }
            if (model.wasPropertyExplicitlySet("buildPipelineStageId")) {
                this.buildPipelineStageId(model.getBuildPipelineStageId());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("buildPipelineStagePredecessors")) {
                this.buildPipelineStagePredecessors(model.getBuildPipelineStagePredecessors());
            }
            if (model.wasPropertyExplicitlySet("actualBuildRunnerShape")) {
                this.actualBuildRunnerShape(model.getActualBuildRunnerShape());
            }
            if (model.wasPropertyExplicitlySet("actualBuildRunnerShapeConfig")) {
                this.actualBuildRunnerShapeConfig(model.getActualBuildRunnerShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("buildSpecFile")) {
                this.buildSpecFile(model.getBuildSpecFile());
            }
            if (model.wasPropertyExplicitlySet("stageExecutionTimeoutInSeconds")) {
                this.stageExecutionTimeoutInSeconds(model.getStageExecutionTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("buildSourceCollection")) {
                this.buildSourceCollection(model.getBuildSourceCollection());
            }
            if (model.wasPropertyExplicitlySet("primaryBuildSource")) {
                this.primaryBuildSource(model.getPrimaryBuildSource());
            }
            if (model.wasPropertyExplicitlySet("steps")) {
                this.steps(model.getSteps());
            }
            if (model.wasPropertyExplicitlySet("exportedVariables")) {
                this.exportedVariables(model.getExportedVariables());
            }
            if (model.wasPropertyExplicitlySet("privateAccessConfig")) {
                this.privateAccessConfig(model.getPrivateAccessConfig());
            }
            return this;
        }
    }
}

