/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private ClassPath runtimeClassPath = null;
    private ClassPath bootClassPath = null;
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = evaluator;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    private FileObject getDir(final String propname) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){
            final /* synthetic */ ClassPathProviderImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = this.this$0;
                synchronized (classPathProviderImpl) {
                    String prop;
                    FileObject fo = (FileObject)this.this$0.dirCache.get(propname);
                    if (!(fo != null && fo.isValid() || (prop = this.this$0.evaluator.getProperty(propname)) == null)) {
                        fo = this.this$0.helper.resolveFileObject(prop);
                        this.this$0.dirCache.put(propname, fo);
                    }
                    return fo;
                }
            }
        });
    }

    private FileObject getDistJar() {
        return this.getDir("dist.jar");
    }

    private FileObject getBuildDir() {
        return this.getDir("build.dir");
    }

    private int getType(FileObject file) {
        FileObject dir = this.getDistJar();
        if (dir != null && dir.equals(FileUtil.getArchiveFile((FileObject)file))) {
            return 0;
        }
        dir = this.getBuildDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 0;
        }
        return -1;
    }

    private synchronized ClassPath getRunTimeClasspath(FileObject file) {
        if (this.getType(file) == -1) {
            return null;
        }
        if (this.runtimeClassPath == null) {
            this.runtimeClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"debug.classpath", "j2ee.platform.classpath"}));
        }
        return this.runtimeClassPath;
    }

    private synchronized ClassPath getBootClassPath() {
        if (this.bootClassPath == null) {
            this.bootClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createBootClassPathImplementation((PropertyEvaluator)this.evaluator));
        }
        return this.bootClassPath;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/boot".equals(type)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        assert (false);
        return null;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.dirCache.remove(evt.getPropertyName());
    }
}

