/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ProjectEar;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.javaee.project.api.ant.DeployOnSaveUtils;
import org.netbeans.modules.javaee.project.api.ant.ui.J2EEProjectProperties;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.Lookups;

public class EarActionProvider
implements ActionProvider {
    private static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    private static final String COMMAND_COMPILE = "compile";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "run", "debug", "profile", "redeploy", "verify", "delete", "copy", "move", "rename"};
    EarProject project;
    private final UpdateHelper updateHelper;
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public EarActionProvider(EarProject project, UpdateHelper updateHelper) {
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("profile", new String[]{"profile"});
        this.commands.put("redeploy", new String[]{"run-deploy"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put(COMMAND_COMPILE, new String[]{COMMAND_COMPILE});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.updateHelper = updateHelper;
        this.project = project;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject(this.project.getBuildXmlName());
    }

    public String[] getSupportedActions() {
        return (String[])supportedActions.clone();
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        Properties p;
        String commandToExecute;
        String[] targetNames;
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        String realCommand = command;
        J2eeModuleProvider.DeployOnSaveSupport support = this.project.getAppModule().getDeployOnSaveSupport();
        if ("build".equals(realCommand) && this.isCosEnabled() && support != null && support.containsIdeArtifacts()) {
            boolean cleanAndBuild = DeployOnSaveUtils.showBuildActionWarning((Project)this.project, (DeployOnSaveUtils.CustomizerPresenter)new DeployOnSaveUtils.CustomizerPresenter(){

                public void showCustomizer(String category) {
                    CustomizerProviderImpl provider = (CustomizerProviderImpl)EarActionProvider.this.project.getLookup().lookup(CustomizerProviderImpl.class);
                    provider.showCustomizer(category);
                }
            });
            if (cleanAndBuild) {
                realCommand = "rebuild";
            } else {
                return;
            }
        }
        if ((targetNames = this.getTargetNames(commandToExecute = realCommand, context, p = new Properties())) == null) {
            return;
        }
        if (targetNames.length == 0) {
            targetNames = null;
        }
        if (p.keySet().size() == 0) {
            p = null;
        }
        final ProjectEar app = this.project.getAppModule();
        final ActionProgress listener = ActionProgress.start((Lookup)context);
        try {
            Deployment.getDefault().suspendDeployOnSave((J2eeModuleProvider)app);
            ActionUtils.runTarget((FileObject)this.findBuildXml(), (String[])targetNames, (Properties)p).addTaskListener(new TaskListener(){
                final /* synthetic */ EarActionProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public void taskFinished(Task task) {
                    Deployment.getDefault().resumeDeployOnSave((J2eeModuleProvider)app);
                    assert (task instanceof ExecutorTask);
                    listener.finished(((ExecutorTask)task).result() == 0);
                }
            });
        }
        catch (IOException e) {
            Deployment.getDefault().resumeDeployOnSave((J2eeModuleProvider)app);
            Exceptions.printStackTrace((Throwable)e);
            listener.finished(false);
        }
        catch (RuntimeException ex) {
            Deployment.getDefault().resumeDeployOnSave((J2eeModuleProvider)app);
            listener.finished(false);
            throw ex;
        }
    }

    String[] getTargetNames(String command, Lookup context, Properties p) throws IllegalArgumentException {
        FileObject browserContextFile = (FileObject)context.lookup(FileObject.class);
        if (browserContextFile == null) {
            browserContextFile = this.project.getProjectDirectory();
        }
        String ctx = FileUtil.toFile((FileObject)browserContextFile).getAbsolutePath();
        p.setProperty("browser.context", ctx);
        String[] targetNames = this.commands.get(command);
        if (command.equals("run") || command.equals("redeploy")) {
            if (!this.checkSelectedServer(false, false, false)) {
                return null;
            }
            if (command.equals("run") && this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (command.equals("redeploy")) {
                p.setProperty("forceRedeploy", "true");
            } else {
                p.setProperty("forceRedeploy", "false");
            }
            this.setDirectoryDeploymentProperty(p);
        } else if (command.equals("debug")) {
            SubprojectProvider spp;
            if (!this.checkSelectedServer(true, false, false)) {
                return null;
            }
            this.setDirectoryDeploymentProperty(p);
            if (this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (null != (spp = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class))) {
                StringBuilder edbd = new StringBuilder();
                Set s = spp.getSubprojects();
                for (Project proj : s) {
                    FileObject fo;
                    WebModule wm;
                    WebModuleProvider wmp = (WebModuleProvider)proj.getLookup().lookup(WebModuleProvider.class);
                    if (null == wmp || null == (wm = wmp.findWebModule(proj.getProjectDirectory())) || null == (fo = wm.getDocumentBase())) continue;
                    edbd.append(FileUtil.toFile((FileObject)fo).getAbsolutePath() + ":");
                }
                p.setProperty("ear.docbase.dirs", edbd.toString());
            }
        } else if (command.equals("profile")) {
            if (!this.checkSelectedServer(false, true, false)) {
                return null;
            }
            this.setDirectoryDeploymentProperty(p);
            SubprojectProvider spp = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class);
            if (null != spp) {
                StringBuilder edbd = new StringBuilder();
                Set s = spp.getSubprojects();
                for (Project proj : s) {
                    FileObject fo;
                    WebModule wm;
                    WebModuleProvider wmp = (WebModuleProvider)proj.getLookup().lookup(WebModuleProvider.class);
                    if (null == wmp || null == (wm = wmp.findWebModule(proj.getProjectDirectory())) || null == (fo = wm.getDocumentBase())) continue;
                    edbd.append(FileUtil.toFile((FileObject)fo).getAbsolutePath() + ":");
                }
                p.setProperty("ear.docbase.dirs", edbd.toString());
            }
        } else if (targetNames == null) {
            throw new IllegalArgumentException(command);
        }
        this.collectStartupExtenderArgs(p, command);
        return targetNames;
    }

    private void setDirectoryDeploymentProperty(Properties p) {
        String instance = this.updateHelper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (instance != null) {
            J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            String sdi = jmp.getServerInstanceID();
            J2eeModule mod = jmp.getJ2eeModule();
            if (sdi != null && mod != null) {
                boolean cFD = Deployment.getDefault().canFileDeploy(instance, mod);
                p.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, "" + cFD);
            }
        }
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (this.findBuildXml() == null) {
            return false;
        }
        J2eeModuleProvider.DeployOnSaveSupport support = this.project.getAppModule().getDeployOnSaveSupport();
        if (this.isCosEnabled() && support != null && support.containsIdeArtifacts() && "compile.single".equals(command)) {
            return false;
        }
        if (command.equals(COMMAND_VERIFY)) {
            J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            return provider != null && provider.hasVerifierSupport();
        }
        if (command.equals("run")) {
            boolean isAppClientSelected = this.project.evaluator().getProperty("app.client") != null;
            return this.checkSelectedServer(false, false, true) && (!isAppClientSelected || !this.isTargetServerRemote());
        }
        return true;
    }

    private boolean isDebugged() {
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (null == jmp) {
            return false;
        }
        ServerDebugInfo sdi = null;
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            if (null == sdi && null == (sdi = jmp.getServerDebugInfo())) {
                return false;
            }
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? attCookie.getSharedMemoryName().equalsIgnoreCase(sdi.getShmemName()) : attCookie.getHostName() != null && attCookie.getHostName().equalsIgnoreCase(sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean checkSelectedServer(boolean checkDebug, boolean checkProfile, boolean noMessages) {
        return J2EEProjectProperties.checkSelectedServer((Project)this.project, (AntProjectHelper)this.updateHelper.getAntProjectHelper(), (Profile)this.project.getJ2eeProfile(), (J2eeModule.Type)J2eeModule.Type.EAR, (J2EEProjectProperties.SetServerInstanceCallback)new J2EEProjectProperties.SetServerInstanceCallback(){

            public void setServerInstance(String serverInstanceId) {
                EarProjectProperties.setServerInstance(EarActionProvider.this.project, EarActionProvider.this.updateHelper, serverInstanceId);
            }
        }, (boolean)checkDebug, (boolean)checkProfile, (boolean)noMessages);
    }

    private boolean isTargetServerRemote() {
        J2eeModuleProvider module = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties props = module.getInstanceProperties();
        String domain = props.getProperty("DOMAIN");
        String location = props.getProperty("LOCATION");
        return "".equals(domain) && "".equals(location);
    }

    private boolean isCosEnabled() {
        return Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.compile.on.save"));
    }

    private void collectStartupExtenderArgs(Map p, String command) {
        StringBuilder b = new StringBuilder();
        for (String arg : this.runJvmargsIde(command)) {
            b.append(' ').append(arg);
        }
        if (b.length() > 0) {
            p.put("run.jvmargs.ide", b.toString());
        }
    }

    private List<String> runJvmargsIde(String command) {
        StartupExtender.StartMode mode;
        if (command.equals("run") || command.equals("run.single")) {
            mode = StartupExtender.StartMode.NORMAL;
        } else if (command.equals("debug") || command.equals("debug.single") || command.equals("debug.stepinto")) {
            mode = StartupExtender.StartMode.DEBUG;
        } else if (command.equals("profile") || command.equals("profile.single")) {
            mode = StartupExtender.StartMode.PROFILE;
        } else if (command.equals("test") || command.equals("test.single")) {
            mode = StartupExtender.StartMode.TEST_NORMAL;
        } else if (command.equals("debug.test.single")) {
            mode = StartupExtender.StartMode.TEST_DEBUG;
        } else if (command.equals("profile.test.single")) {
            mode = StartupExtender.StartMode.TEST_PROFILE;
        } else {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        JavaPlatform p = this.getActivePlatform();
        for (StartupExtender group : StartupExtender.getExtenders((Lookup)Lookups.fixed((Object[])new Object[]{this.project, p != null ? p : JavaPlatformManager.getDefault().getDefaultPlatform()}), (StartupExtender.StartMode)mode)) {
            args.addAll(group.getArguments());
        }
        return args;
    }

    private JavaPlatform getActivePlatform() {
        return CommonProjectUtils.getActivePlatform((String)this.project.evaluator().getProperty("platform.active"));
    }
}

