/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.modules.web.clientproject.ui.BrowseFolders;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.clientproject.validation.ProjectFoldersValidator;
import org.netbeans.modules.web.clientproject.validation.RunProjectValidator;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.api.WebServer;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class BrowserRunPanel
extends JPanel
implements DocumentListener,
ItemListener {
    private static final long serialVersionUID = 98712411454L;
    private final ClientSideProject project;
    private final ComboBoxModel webServerModel;
    private final ClientSideProjectProperties uiProperties;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JComboBox browserComboBox;
    private JLabel browserLabel;
    private JPanel configurationPlaceholder;
    private JLabel projectUrlDescriptionLabel;
    private JLabel projectUrlLabel;
    private JTextField projectUrlTextField;
    private JButton startFileBrowseButton;
    private JLabel startFileLabel;
    private JTextField startFileTextField;
    private JLabel webRootExampleLabel;
    private JLabel webRootLabel;
    private JTextField webRootTextField;
    private JComboBox webServerComboBox;
    private JLabel webServerLabel;

    BrowserRunPanel(ClientSideProjectProperties uiProperties) {
        assert (uiProperties != null);
        this.uiProperties = uiProperties;
        this.project = uiProperties.getProject();
        this.webServerModel = new DefaultComboBoxModel<ClientSideProjectProperties.ProjectServer>(ClientSideProjectProperties.ProjectServer.values());
        this.initComponents();
        this.init();
        this.initListeners();
    }

    @Override
    public void addNotify() {
        String info;
        boolean siteRootValid;
        super.addNotify();
        File siteRoot = this.getSiteRoot();
        ValidationResult result = new ProjectFoldersValidator().validateSiteRootFolder(siteRoot).getResult();
        boolean bl = siteRootValid = siteRoot != null && !result.hasErrors();
        if (siteRootValid) {
            assert (siteRoot != null);
            info = NbBundle.getMessage(BrowserRunPanel.class, (String)"URL_DESCRIPTION", (Object)siteRoot.getAbsolutePath());
        } else {
            info = " ";
        }
        this.projectUrlDescriptionLabel.setText(info);
        this.startFileTextField.setEnabled(siteRootValid);
        this.startFileBrowseButton.setEnabled(siteRootValid);
        this.storeAndFireChange();
    }

    private void init() {
        this.startFileTextField.setText(this.uiProperties.getStartFile());
        this.webServerComboBox.setModel(this.webServerModel);
        this.webServerComboBox.setRenderer(new ServerRenderer(this.webServerComboBox.getRenderer()));
        this.webServerComboBox.setSelectedItem((Object)this.uiProperties.getProjectServer());
        this.projectUrlTextField.setText(this.uiProperties.getProjectUrl());
        this.webRootTextField.setText(this.uiProperties.getWebRoot());
        this.updateConfigurationCustomizer();
    }

    private void initListeners() {
        this.browserComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                BrowserRunPanel.this.storeAndFireChange();
            }
        });
        this.startFileTextField.getDocument().addDocumentListener(this);
        this.webServerComboBox.addItemListener(this);
        this.projectUrlTextField.getDocument().addDocumentListener(this);
        this.webRootTextField.getDocument().addDocumentListener(this);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getErrorMessage() {
        ValidationResult result = this.validateData();
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        return null;
    }

    public String getWarningMessage() {
        ValidationResult result = this.validateData();
        if (result.hasWarnings()) {
            return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
        }
        return null;
    }

    public void onlyExternalUrl(boolean enable) {
        if (enable) {
            this.webServerComboBox.setSelectedItem((Object)ClientSideProjectProperties.ProjectServer.EXTERNAL);
            this.projectUrlLabel.setVisible(true);
            this.projectUrlTextField.setVisible(true);
            this.projectUrlDescriptionLabel.setVisible(true);
            this.webServerLabel.setVisible(false);
            this.webServerComboBox.setVisible(false);
            this.webRootLabel.setVisible(false);
            this.webRootTextField.setVisible(false);
            this.webRootExampleLabel.setVisible(false);
        } else {
            this.updateConfigurationCustomizer();
        }
    }

    void storeAndFireChange() {
        this.storeData();
        this.changeSupport.fireChange();
    }

    private ValidationResult validateData() {
        RunProjectValidator validator = new RunProjectValidator().validateStartFile(this.getSiteRoot(), this.getResolvedStartFile());
        if (this.projectUrlTextField.isVisible()) {
            validator.validateProjectUrl(this.getProjectUrl());
        }
        return validator.getResult();
    }

    private void storeData() {
        this.uiProperties.setStartFile(this.getStartFile());
        this.uiProperties.setProjectServer(this.getProjectServer());
        this.uiProperties.setProjectUrl(this.getProjectUrl());
        this.uiProperties.setWebRoot(this.getWebRoot());
        this.uiProperties.setSelectedBrowser(this.getSelectedBrowserId());
    }

    private void updateConfigurationCustomizer() {
        this.configurationPlaceholder.removeAll();
        WebBrowser wb = this.getSelectedBrowser();
        ClientProjectEnhancedBrowserImplementation enhancedBrowser = this.uiProperties.createEnhancedBrowserSettings(wb);
        if (enhancedBrowser != null) {
            ProjectConfigurationCustomizer customizerPanel = enhancedBrowser.getProjectConfigurationCustomizer();
            if (customizerPanel != null) {
                this.configurationPlaceholder.add((Component)customizerPanel.createPanel(), "Center");
                EnumSet hiddenProperties = customizerPanel.getHiddenProperties();
                this.showWebServer(!hiddenProperties.contains(ProjectConfigurationCustomizer.HiddenProperties.WEB_SERVER));
            } else {
                this.showWebServer(true);
            }
        }
        this.validate();
        this.repaint();
    }

    private void showWebServer(boolean visible) {
        this.webServerLabel.setVisible(visible);
        this.webServerComboBox.setVisible(visible);
        this.projectUrlDescriptionLabel.setVisible(visible);
        this.projectUrlLabel.setVisible(visible);
        this.projectUrlTextField.setVisible(visible);
        this.webRootExampleLabel.setVisible(visible);
        this.webRootLabel.setVisible(visible);
        this.webRootTextField.setVisible(visible);
        if (visible) {
            this.updateWebRootEnablement();
        } else {
            this.storeAndFireChange();
        }
    }

    @CheckForNull
    private File getSiteRoot() {
        return this.uiProperties.getResolvedSiteRootFolder();
    }

    private String getStartFile() {
        return this.startFileTextField.getText();
    }

    private String getSelectedBrowserId() {
        return ((BrowserUISupport.BrowserComboBoxModel)this.browserComboBox.getModel()).getSelectedBrowserId();
    }

    private WebBrowser getSelectedBrowser() {
        return ((BrowserUISupport.BrowserComboBoxModel)this.browserComboBox.getModel()).getSelectedBrowser();
    }

    @CheckForNull
    private File getResolvedStartFile() {
        String startFile = this.getStartFile();
        if (startFile == null) {
            return null;
        }
        File directFile = new File(startFile = ClientSideProjectUtilities.splitPathAndFragment(startFile)[0]);
        if (directFile.isAbsolute()) {
            return directFile;
        }
        File siteRoot = this.getSiteRoot();
        if (siteRoot == null) {
            return null;
        }
        FileObject siteRootFo = FileUtil.toFileObject((File)siteRoot);
        if (siteRootFo == null) {
            return null;
        }
        FileObject fo = siteRootFo.getFileObject(startFile);
        if (fo == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)fo);
    }

    private ClientSideProjectProperties.ProjectServer getProjectServer() {
        return (ClientSideProjectProperties.ProjectServer)((Object)this.webServerComboBox.getSelectedItem());
    }

    private String getProjectUrl() {
        return this.projectUrlTextField.getText();
    }

    private String getWebRoot() {
        return this.webRootTextField.getText();
    }

    private void initComponents() {
        this.browserLabel = new JLabel();
        this.browserComboBox = this.createBrowserComboBox();
        this.configurationPlaceholder = new JPanel();
        this.startFileLabel = new JLabel();
        this.startFileTextField = new JTextField();
        this.startFileBrowseButton = new JButton();
        this.webServerLabel = new JLabel();
        this.webServerComboBox = new JComboBox();
        this.projectUrlLabel = new JLabel();
        this.projectUrlTextField = new JTextField();
        this.projectUrlDescriptionLabel = new JLabel();
        this.webRootLabel = new JLabel();
        this.webRootTextField = new JTextField();
        this.webRootExampleLabel = new JLabel();
        this.browserLabel.setLabelFor(this.browserComboBox);
        Mnemonics.setLocalizedText((JLabel)this.browserLabel, (String)NbBundle.getMessage(BrowserRunPanel.class, (String)"BrowserRunPanel.browserLabel.text"));
        this.browserComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserRunPanel.this.browserComboBoxActionPerformed(evt);
            }
        });
        this.configurationPlaceholder.setLayout(new BorderLayout());
        this.startFileLabel.setLabelFor(this.startFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.startFileLabel, (String)NbBundle.getMessage(BrowserRunPanel.class, (String)"BrowserRunPanel.startFileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.startFileBrowseButton, (String)NbBundle.getMessage(BrowserRunPanel.class, (String)"BrowserRunPanel.startFileBrowseButton.text"));
        this.startFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserRunPanel.this.startFileBrowseButtonActionPerformed(evt);
            }
        });
        this.webServerLabel.setLabelFor(this.webServerComboBox);
        Mnemonics.setLocalizedText((JLabel)this.webServerLabel, (String)NbBundle.getMessage(BrowserRunPanel.class, (String)"BrowserRunPanel.webServerLabel.text"));
        this.projectUrlLabel.setLabelFor(this.projectUrlTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectUrlLabel, (String)NbBundle.getMessage(BrowserRunPanel.class, (String)"BrowserRunPanel.projectUrlLabel.text"));
        this.projectUrlDescriptionLabel.setFont(this.projectUrlDescriptionLabel.getFont().deriveFont((float)this.projectUrlDescriptionLabel.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.projectUrlDescriptionLabel, (String)NbBundle.getMessage(BrowserRunPanel.class, (String)"BrowserRunPanel.projectUrlDescriptionLabel.text"));
        this.projectUrlDescriptionLabel.setEnabled(false);
        this.webRootLabel.setLabelFor(this.webRootTextField);
        Mnemonics.setLocalizedText((JLabel)this.webRootLabel, (String)NbBundle.getMessage(BrowserRunPanel.class, (String)"BrowserRunPanel.webRootLabel.text"));
        this.webRootExampleLabel.setFont(this.webRootExampleLabel.getFont().deriveFont((float)this.webRootExampleLabel.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.webRootExampleLabel, (String)"EXAMPLE");
        this.webRootExampleLabel.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browserLabel).addComponent(this.webServerLabel).addComponent(this.startFileLabel).addComponent(this.webRootLabel).addComponent(this.projectUrlLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.webRootExampleLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.startFileTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startFileBrowseButton)).addComponent(this.browserComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.webServerComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.projectUrlTextField).addComponent(this.webRootTextField).addComponent(this.configurationPlaceholder, -1, -1, Short.MAX_VALUE).addComponent(this.projectUrlDescriptionLabel))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browserLabel).addComponent(this.browserComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationPlaceholder, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startFileLabel).addComponent(this.startFileTextField, -2, -1, -2).addComponent(this.startFileBrowseButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.webServerLabel).addComponent(this.webServerComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectUrlLabel).addComponent(this.projectUrlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectUrlDescriptionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.webRootLabel).addComponent(this.webRootTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.webRootExampleLabel).addGap(0, 2, Short.MAX_VALUE)));
    }

    private void startFileBrowseButtonActionPerformed(ActionEvent evt) {
        FileObject siteRootFolder = FileUtil.toFileObject((File)this.getSiteRoot());
        assert (siteRootFolder != null);
        FileObject selectedFile = BrowseFolders.showDialog(new FileObject[]{siteRootFolder}, DataObject.class, this.getStartFile());
        if (selectedFile != null) {
            this.startFileTextField.setText(FileUtil.getRelativePath((FileObject)siteRootFolder, (FileObject)selectedFile));
        }
    }

    private void browserComboBoxActionPerformed(ActionEvent evt) {
        this.updateConfigurationCustomizer();
    }

    private void updateWebRooExample() {
        if (!this.webRootTextField.isVisible()) {
            return;
        }
        if (!this.webRootTextField.isEnabled()) {
            this.webRootExampleLabel.setText(" ");
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(WebServer.getWebserver().getPort());
        String ctx = this.webRootTextField.getText();
        if (ctx.trim().length() == 0) {
            s.append("/");
        } else {
            if (!ctx.startsWith("/")) {
                s.append("/");
            }
            s.append(ctx);
        }
        this.webRootExampleLabel.setText(Bundle.BrowserRunPanel_webRoot_example(s.toString()));
    }

    private boolean isEmbeddedServer() {
        return this.webServerComboBox.getSelectedItem() == ClientSideProjectProperties.ProjectServer.INTERNAL;
    }

    private void updateWebRootEnablement() {
        this.webRootTextField.setVisible(this.isEmbeddedServer());
        this.webRootLabel.setVisible(this.isEmbeddedServer());
        this.webRootExampleLabel.setVisible(this.isEmbeddedServer());
        this.projectUrlLabel.setVisible(!this.isEmbeddedServer());
        this.projectUrlTextField.setVisible(!this.isEmbeddedServer());
        this.projectUrlDescriptionLabel.setVisible(!this.isEmbeddedServer());
        this.updateWebRooExample();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateWebRooExample();
        this.storeAndFireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateWebRooExample();
        this.storeAndFireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateWebRooExample();
        this.storeAndFireChange();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateWebRootEnablement();
        this.storeAndFireChange();
    }

    private JComboBox createBrowserComboBox() {
        WebBrowser wb;
        String selectedBrowser = this.uiProperties.getSelectedBrowser();
        if ((selectedBrowser == null || BrowserUISupport.getBrowser((String)selectedBrowser) == null) && (wb = this.project.getProjectWebBrowser()) != null) {
            selectedBrowser = wb.getId();
        }
        return BrowserUISupport.createBrowserPickerComboBox((String)selectedBrowser, (boolean)false, (boolean)true);
    }

    private static final class ServerRenderer
    implements ListCellRenderer {
        private final ListCellRenderer original;

        public ServerRenderer(ListCellRenderer original) {
            this.original = original;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            value = ((ClientSideProjectProperties.ProjectServer)((Object)value)).getTitle();
            return this.original.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class ConfigRenderer
    implements ListCellRenderer {
        private final ListCellRenderer original;

        public ConfigRenderer(ListCellRenderer original) {
            this.original = original;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ProjectConfiguration) {
                value = ((ProjectConfiguration)value).getDisplayName();
            }
            return this.original.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

