/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import io.agroal.api.transaction.TransactionAware;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.BaseXAResource;
import io.agroal.narayana.ConnectableLocalXAResource;
import io.agroal.narayana.ErrorConditionXAResource;
import io.agroal.narayana.FirstResourceBaseXAResource;
import io.agroal.narayana.LocalXAResource;
import io.agroal.narayana.RecoveryXAResource;
import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.XAResource;
import org.jboss.tm.TxUtils;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class NarayanaTransactionIntegration
implements TransactionIntegration {
    private static final ConcurrentMap<TransactionIntegration.ResourceRecoveryFactory, XAResourceRecovery> resourceRecoveryCache = new ConcurrentHashMap<TransactionIntegration.ResourceRecoveryFactory, XAResourceRecovery>();
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final String jndiName;
    private final boolean connectable;
    private final boolean firstResource;
    private final XAResourceRecoveryRegistry recoveryRegistry;
    private final UUID key = UUID.randomUUID();

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this(transactionManager, transactionSynchronizationRegistry, null, false);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName) {
        this(transactionManager, transactionSynchronizationRegistry, jndiName, false);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName, boolean connectable) {
        this(transactionManager, transactionSynchronizationRegistry, jndiName, connectable, null);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName, boolean connectable, XAResourceRecoveryRegistry recoveryRegistry) {
        this(transactionManager, transactionSynchronizationRegistry, jndiName, connectable, false, recoveryRegistry);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName, boolean connectable, boolean firstResource) {
        this(transactionManager, transactionSynchronizationRegistry, jndiName, connectable, firstResource, null);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName, boolean connectable, boolean firstResource, XAResourceRecoveryRegistry recoveryRegistry) {
        if (connectable && firstResource) {
            throw new IllegalArgumentException("Setting both connectable and firstResource is not allowed");
        }
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.jndiName = jndiName;
        this.connectable = connectable;
        this.firstResource = firstResource;
        this.recoveryRegistry = recoveryRegistry;
    }

    public TransactionAware getTransactionAware() throws SQLException {
        TransactionPhase phase = this.getTransactionPhase();
        if (phase == TransactionPhase.TRANSACTION_ACTIVE) {
            return (TransactionAware)this.transactionSynchronizationRegistry.getResource((Object)this.key);
        }
        if (phase == TransactionPhase.TRANSACTION_ROLLED_BACK) {
            throw new SQLException("The transaction has rolled back");
        }
        return null;
    }

    private XAResource createXaResource(TransactionAware transactionAware, XAResource xaResource) {
        if (xaResource != null) {
            if (this.firstResource) {
                return new FirstResourceBaseXAResource(transactionAware, xaResource, this.jndiName);
            }
            return new BaseXAResource(transactionAware, xaResource, this.jndiName);
        }
        if (this.connectable) {
            return new ConnectableLocalXAResource(transactionAware, this.jndiName);
        }
        return new LocalXAResource(transactionAware, this.jndiName);
    }

    public void associate(TransactionAware transactionAware, XAResource xaResource) throws SQLException {
        try {
            TransactionPhase phase = this.getTransactionPhase();
            if (phase == TransactionPhase.TRANSACTION_ACTIVE) {
                if (this.transactionSynchronizationRegistry.getResource((Object)this.key) == null) {
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)new InterposedSynchronization(transactionAware));
                    this.transactionSynchronizationRegistry.putResource((Object)this.key, (Object)transactionAware);
                    if (!this.transactionManager.getTransaction().enlistResource(this.createXaResource(transactionAware, xaResource))) {
                        throw new SQLException(xaResource == null && !this.connectable ? "Failed to enlist. Check if a connection from another datasource is already enlisted to the same transaction" : "Unable to enlist connection to existing transaction");
                    }
                } else {
                    transactionAware.transactionStart();
                }
            }
            transactionAware.transactionCheckCallback(phase == TransactionPhase.TRANSACTION_COMPLETING ? this.getChangeStateCallback() : this::transactionRunning);
        }
        catch (Exception e) {
            throw new SQLException("Exception in association of connection to existing transaction", e);
        }
    }

    public boolean disassociate(TransactionAware connection) throws SQLException {
        if (this.getTransactionPhase() == TransactionPhase.TRANSACTION_ACTIVE) {
            this.transactionSynchronizationRegistry.putResource((Object)this.key, null);
        }
        return true;
    }

    private boolean transactionRunning() throws SQLException {
        TransactionPhase phase = this.getTransactionPhase();
        return phase == TransactionPhase.TRANSACTION_ACTIVE || phase == TransactionPhase.TRANSACTION_COMPLETING;
    }

    private TransactionPhase getTransactionPhase() throws SQLException {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                return TxUtils.isTransactionManagerTimeoutThread() ? TransactionPhase.TRANSACTION_COMPLETING : TransactionPhase.TRANSACTION_NONE;
            }
            switch (transaction.getStatus()) {
                case 0: 
                case 1: {
                    return TransactionPhase.TRANSACTION_ACTIVE;
                }
                case 2: 
                case 7: 
                case 8: 
                case 9: {
                    return TransactionPhase.TRANSACTION_COMPLETING;
                }
                case 3: {
                    return TransactionPhase.TRANSACTION_COMMITED;
                }
                case 4: {
                    return TransactionPhase.TRANSACTION_ROLLED_BACK;
                }
            }
            return TransactionPhase.TRANSACTION_NONE;
        }
        catch (Exception e) {
            throw new SQLException("Exception in retrieving existing transaction", e);
        }
    }

    private TransactionAware.SQLCallable<Boolean> getChangeStateCallback() throws SQLException {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                throw new SQLException("Expecting existing transaction");
            }
            int status = transaction.getStatus();
            return () -> {
                try {
                    return this.transactionManager.getTransaction().getStatus() != status;
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            };
        }
        catch (Exception e) {
            throw new SQLException("Exception in retrieving existing transaction", e);
        }
    }

    public void addResourceRecoveryFactory(TransactionIntegration.ResourceRecoveryFactory factory) {
        if (this.recoveryRegistry != null) {
            this.recoveryRegistry.addXAResourceRecovery(resourceRecoveryCache.computeIfAbsent(factory, f -> new AgroalXAResourceRecovery((TransactionIntegration.ResourceRecoveryFactory)f, this.jndiName)));
        }
    }

    public void removeResourceRecoveryFactory(TransactionIntegration.ResourceRecoveryFactory factory) {
        if (this.recoveryRegistry != null) {
            this.recoveryRegistry.removeXAResourceRecovery((XAResourceRecovery)resourceRecoveryCache.remove(factory));
        }
    }

    public static enum TransactionPhase {
        TRANSACTION_NONE,
        TRANSACTION_ACTIVE,
        TRANSACTION_COMPLETING,
        TRANSACTION_COMMITED,
        TRANSACTION_ROLLED_BACK;

    }

    private static class InterposedSynchronization
    implements Synchronization {
        private final TransactionAware transactionAware;

        InterposedSynchronization(TransactionAware transactionAware) {
            this.transactionAware = transactionAware;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.transactionAware.transactionEnd();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class AgroalXAResourceRecovery
    implements XAResourceRecovery {
        private static final XAResource[] EMPTY_RESOURCES = new XAResource[0];
        private final TransactionIntegration.ResourceRecoveryFactory connectionFactory;
        private final String name;

        AgroalXAResourceRecovery(TransactionIntegration.ResourceRecoveryFactory factory, String jndiName) {
            this.connectionFactory = factory;
            this.name = jndiName;
        }

        public XAResource[] getXAResources() {
            try {
                XAResource[] xAResourceArray;
                if (this.connectionFactory.isRecoverable()) {
                    XAResource[] xAResourceArray2 = new XAResource[1];
                    xAResourceArray = xAResourceArray2;
                    xAResourceArray2[0] = new RecoveryXAResource(this.connectionFactory, this.name);
                } else {
                    xAResourceArray = EMPTY_RESOURCES;
                }
                return xAResourceArray;
            }
            catch (SQLException e) {
                return new XAResource[]{new ErrorConditionXAResource(e, this.name)};
            }
        }
    }
}

