/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import org.hibernate.models.internal.AbstractTypeDescriptor;
import org.hibernate.models.rendering.spi.Renderer;
import org.hibernate.models.rendering.spi.RenderingTarget;
import org.hibernate.models.spi.ModelsContext;

public class LongTypeDescriptor
extends AbstractTypeDescriptor<Long> {
    public static final LongTypeDescriptor LONG_TYPE_DESCRIPTOR = new LongTypeDescriptor();

    @Override
    public Class<Long> getValueType() {
        return Long.class;
    }

    @Override
    public Object unwrap(Long value) {
        return value;
    }

    @Override
    public void render(String name, Object attributeValue, RenderingTarget target, Renderer renderer, ModelsContext modelContext) {
        target.addLine("%s = %sL", name, attributeValue);
    }

    @Override
    public void render(Object attributeValue, RenderingTarget target, Renderer renderer, ModelsContext modelContext) {
        target.addLine("%sL", attributeValue);
    }

    public Long[] makeArray(int size, ModelsContext modelContext) {
        return new Long[size];
    }
}

