/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public abstract class AbstractInternalCacheEntry
implements InternalCacheEntry {
    protected final Object key;
    protected Object value;
    protected PrivateMetadata internalMetadata;

    protected AbstractInternalCacheEntry(Object key, Object value, PrivateMetadata internalMetadata) {
        this.key = key;
        this.value = value;
        this.internalMetadata = internalMetadata;
    }

    @Override
    public final void commit(DataContainer container) {
    }

    @Override
    public void setChanged(boolean changed) {
    }

    @Override
    public final void setCreated(boolean created) {
    }

    @Override
    public final void setRemoved(boolean removed) {
    }

    @Override
    public final void setEvicted(boolean evicted) {
    }

    @Override
    public void setSkipLookup(boolean skipLookup) {
    }

    @Override
    public void setInvalidated(boolean invalidated) {
    }

    @Override
    public final boolean isNull() {
        return false;
    }

    @Override
    public final boolean isChanged() {
        return false;
    }

    @Override
    public final boolean isCreated() {
        return false;
    }

    @Override
    public final boolean isRemoved() {
        return false;
    }

    @Override
    public final boolean isEvicted() {
        return true;
    }

    @Override
    public boolean skipLookup() {
        return true;
    }

    @Override
    public boolean isInvalidated() {
        return false;
    }

    @Override
    public Metadata getMetadata() {
        return null;
    }

    @Override
    public void setMetadata(Metadata metadata) {
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public final Object getValue() {
        return this.value;
    }

    @Override
    public final Object setValue(Object value) {
        Object old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public boolean isL1Entry() {
        return false;
    }

    @Override
    public final PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public final void setInternalMetadata(PrivateMetadata metadata) {
        this.internalMetadata = metadata;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('{');
        this.appendFieldsToString(sb);
        return sb.append('}').toString();
    }

    @Override
    public AbstractInternalCacheEntry clone() {
        try {
            return (AbstractInternalCacheEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen!", e);
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry that = (Map.Entry)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
    }

    @Override
    public final int hashCode() {
        return 31 * Objects.hashCode(this.getKey()) + Objects.hashCode(this.getValue());
    }

    protected void appendFieldsToString(StringBuilder builder) {
        builder.append("key=").append(Util.toStr((Object)this.key));
        builder.append(", value=").append(Util.toStr((Object)this.value));
        builder.append(", internalMetadata=").append(this.internalMetadata);
    }
}

