/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import net.sf.juife.wizard.UserInputPage;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.task.Global;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.MidiInstrumentInfo;
import org.linuxsampler.lscp.Parser;
import org.linuxsampler.lscp.SamplerEngine;

class ManualSelectWizardPage
extends UserInputPage {
    private final JLabel lFilename = new JLabel(StdI18n.i18n.getLabel("ManualSelectWizardPage.lFilename"));
    private final JLabel lIndex = new JLabel(StdI18n.i18n.getLabel("ManualSelectWizardPage.lIndex"));
    private final JLabel lEngine = new JLabel(StdI18n.i18n.getLabel("ManualSelectWizardPage.lEngine"));
    private final JLabel lLoadMode = new JLabel(StdI18n.i18n.getLabel("ManualSelectWizardPage.lLoadMode"));
    private final JComboBox cbFilename = new JComboBox();
    private final JComboBox cbIndex = new JComboBox();
    private final JButton btnBrowse;
    private final JComboBox cbEngine = new JComboBox();
    private final JComboBox cbLoadMode = new JComboBox();
    private final Handler eventHandler = new Handler();

    ManualSelectWizardPage(ImageIcon imageIcon) {
        super(StdI18n.i18n.getLabel("ManualSelectWizardPage.subtitle"));
        this.setMainInstructions(StdI18n.i18n.getLabel("ManualSelectWizardPage.mainInstructions"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lFilename, gridBagConstraints);
        jPanel.add(this.lFilename);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lIndex, gridBagConstraints);
        jPanel.add(this.lIndex);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 3, 3, 3);
        gridBagLayout.setConstraints(this.lEngine, gridBagConstraints);
        jPanel.add(this.lEngine);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lLoadMode, gridBagConstraints);
        jPanel.add(this.lLoadMode);
        this.btnBrowse = new JButton(imageIcon);
        this.btnBrowse.setMargin(new Insets(0, 0, 0, 0));
        this.btnBrowse.setToolTipText(StdI18n.i18n.getLabel("ManualSelectWizardPage.btnBrowse"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.btnBrowse, gridBagConstraints);
        jPanel.add(this.btnBrowse);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cbFilename, gridBagConstraints);
        jPanel.add(this.cbFilename);
        for (int i = 0; i < 101; ++i) {
            this.cbIndex.addItem(i);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.cbIndex, gridBagConstraints);
        jPanel.add(this.cbIndex);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 3, 3, 64);
        gridBagLayout.setConstraints(this.cbEngine, gridBagConstraints);
        jPanel.add(this.cbEngine);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 64);
        gridBagLayout.setConstraints(this.cbLoadMode, gridBagConstraints);
        jPanel.add(this.cbLoadMode);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.setMainPane(jPanel);
        this.cbFilename.setEditable(true);
        String[] stringArray = this.preferences().getStringListProperty("recentInstrumentFiles");
        for (String object : stringArray) {
            this.cbFilename.addItem(object);
        }
        this.cbFilename.setSelectedItem(null);
        this.cbFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManualSelectWizardPage.this.updateState();
                ManualSelectWizardPage.this.updateFileInstruments();
            }
        });
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManualSelectWizardPage.this.onBrowse();
            }
        });
        for (SamplerEngine samplerEngine : CC.getSamplerModel().getEngines()) {
            this.cbEngine.addItem(samplerEngine);
        }
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.DEFAULT);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.ON_DEMAND);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.ON_DEMAND_HOLD);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.PERSISTENT);
        int n = this.preferences().getIntProperty("std.midiInstrument.loadMode", 0);
        if (this.cbLoadMode.getItemCount() > n) {
            this.cbLoadMode.setSelectedIndex(n);
        }
        this.cbLoadMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ManualSelectWizardPage.this.cbLoadMode.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                ManualSelectWizardPage.this.preferences().setIntProperty("std.midiInstrument.loadMode", n);
            }
        });
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private void onBrowse() {
        File file = StdUtils.showOpenInstrumentFileChooser(this.getWizardDialog());
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.replace('\\', '/');
        }
        this.cbFilename.setSelectedItem(Parser.toEscapedString(string));
    }

    private void updateState() {
        boolean bl = false;
        Object object = this.cbFilename.getSelectedItem();
        bl = object == null ? false : object.toString().length() > 0;
        object = this.cbIndex.getSelectedItem();
        if (object == null || object.toString().length() == 0) {
            bl = false;
        }
        this.getWizard().enableNextButton(bl);
    }

    private void updateFileInstruments() {
        Object object = this.cbFilename.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString();
        final Global.GetFileInstruments getFileInstruments = new Global.GetFileInstruments(string);
        getFileInstruments.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                Instrument[] instrumentArray = (Instrument[])getFileInstruments.getResult();
                if (instrumentArray == null) {
                    ManualSelectWizardPage.this.cbIndex.removeAllItems();
                    for (int i = 0; i < 101; ++i) {
                        ManualSelectWizardPage.this.cbIndex.addItem(i);
                    }
                    return;
                }
                ManualSelectWizardPage.this.cbIndex.removeAllItems();
                for (int i = 0; i < instrumentArray.length; ++i) {
                    ManualSelectWizardPage.this.cbIndex.addItem(i + " - " + instrumentArray[i].getName());
                }
            }
        });
        CC.getTaskQueue().add(getFileInstruments);
    }

    public String getInstrumentName() {
        if (this.cbIndex.getSelectedItem() == null) {
            return null;
        }
        String string = this.cbIndex.getSelectedItem().toString();
        int n = string.indexOf(" - ");
        if (n == -1) {
            return null;
        }
        return string.substring(n + 3);
    }

    @Override
    public void postinitPage() {
        this.updateState();
    }

    public String getSelectedFile() {
        return this.cbFilename.getSelectedItem().toString();
    }

    public int getInstrumentIndex() {
        return this.cbIndex.getSelectedIndex();
    }

    public String getEngine() {
        return ((SamplerEngine)this.cbEngine.getSelectedItem()).getName();
    }

    public MidiInstrumentInfo.LoadMode getLoadMode() {
        return (MidiInstrumentInfo.LoadMode)((Object)this.cbLoadMode.getSelectedItem());
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ManualSelectWizardPage.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ManualSelectWizardPage.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ManualSelectWizardPage.this.updateState();
        }
    }
}

