/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the inverse cosine of each pixel.


This filter is templated over the pixel type of the input image and
the pixel type of the output image.

The filter walks over all the pixels in the input image, and for each
pixel does do the following:


cast the pixel value to double ,

apply the std::acos() function to the double value

cast the double value resulting from std::acos() to the pixel type of
the output image

store the casted value into the output image.
 The filter expects both images to have the same dimension (e.g. both
2D, or both 3D, or both ND).
See:
 itk::simple::Acos for the procedural interface

 itk::AcosImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAcosImageFilter.h
*/
public class AcosImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AcosImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AcosImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AcosImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AcosImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AcosImageFilter::~AcosImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AcosImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AcosImageFilter::AcosImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AcosImageFilter() {
    this(SimpleITKJNI.new_AcosImageFilter(), true);
  }

  /**
std::string itk::simple::AcosImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AcosImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AcosImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AcosImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AcosImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.AcosImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
