/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSerializationSettings;
import org.jetbrains.kotlin.builtins.FunctionInterfacePackageFragment;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.library.SerializedIrFile;
import org.jetbrains.kotlin.library.SerializedIrModule;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer;", "Serializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "", "settings", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;)V", "getSettings", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;", "getDiagnosticReporter", "()Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "createSerializerForFile", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "backendSpecificFileFilter", "", "globalDeclarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "serializeIrFile", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "serializedIrModule", "Lorg/jetbrains/kotlin/library/SerializedIrModule;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrModuleSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrModuleSerializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n774#2:48\n865#2,2:49\n774#2:51\n865#2,2:52\n1563#2:54\n1634#2,3:55\n*S KotlinDebug\n*F\n+ 1 IrModuleSerializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer\n*L\n39#1:48\n39#1:49,2\n40#1:51\n40#1:52,2\n41#1:54\n41#1:55,3\n*E\n"})
public abstract class IrModuleSerializer<Serializer extends IrFileSerializer> {
    @NotNull
    private final IrSerializationSettings settings;
    @NotNull
    private final IrDiagnosticReporter diagnosticReporter;

    public IrModuleSerializer(@NotNull IrSerializationSettings settings, @NotNull IrDiagnosticReporter diagnosticReporter) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        this.settings = settings;
        this.diagnosticReporter = diagnosticReporter;
    }

    @NotNull
    protected final IrSerializationSettings getSettings() {
        return this.settings;
    }

    @NotNull
    protected final IrDiagnosticReporter getDiagnosticReporter() {
        return this.diagnosticReporter;
    }

    @NotNull
    public abstract Serializer createSerializerForFile(@NotNull IrFile var1);

    protected boolean backendSpecificFileFilter(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @NotNull
    protected abstract GlobalDeclarationTable getGlobalDeclarationTable();

    private final SerializedIrFile serializeIrFile(IrFile file) {
        Serializer fileSerializer = this.createSerializerForFile(file);
        return ((IrFileSerializer)fileSerializer).serializeIrFile(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SerializedIrModule serializedIrModule(@NotNull IrModuleFragment module2) {
        void $this$mapTo$iv$iv;
        IrFile p0;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Iterable $this$filter$iv = module2.getFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFile it = (IrFile)element$iv$iv;
            boolean bl = false;
            if (!(!(IrPackageFragmentsKt.getPackageFragmentDescriptor(it) instanceof FunctionInterfacePackageFragment))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (IrFile)element$iv$iv;
            boolean bl = false;
            if (!this.backendSpecificFileFilter(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (IrFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.serializeIrFile(p0));
        }
        List serializedFiles = (List)destination$iv$iv;
        if (this.settings.getShouldCheckSignaturesOnUniqueness()) {
            this.getGlobalDeclarationTable().getClashDetector$ir_serialization_common().reportErrorsTo(this.diagnosticReporter);
        }
        return new SerializedIrModule(serializedFiles);
    }
}

