/*
 * Decompiled with CFR 0.152.
 */
package com.pywebview;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.pywebview.EventCallbackWrapper;
import com.pywebview.WebViewRequestInterceptor;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class PyWebViewClient
extends WebViewClient {
    private volatile EventCallbackWrapper callback;
    private boolean ignoreSslErrors = false;
    private volatile WebViewRequestInterceptor requestInterceptor;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private volatile boolean isDestroyed = false;

    public void setCallback(EventCallbackWrapper callback, boolean ignoreSslErrors) {
        this.callback = callback;
        this.ignoreSslErrors = ignoreSslErrors;
    }

    public void setRequestInterceptor(WebViewRequestInterceptor interceptor) {
        this.requestInterceptor = interceptor;
    }

    public void destroy() {
        this.isDestroyed = true;
        this.callback = null;
        this.requestInterceptor = null;
    }

    private void safeCallback(String event, String data) {
        if (this.isDestroyed) {
            Log.d((String)"python", (String)("Callback skipped - client destroyed: " + event));
            return;
        }
        EventCallbackWrapper currentCallback = this.callback;
        if (currentCallback == null) {
            Log.d((String)"python", (String)("Callback skipped - no callback set: " + event));
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            try {
                currentCallback.callback(event, data);
            }
            catch (Exception e) {
                Log.e((String)"python", (String)("Error in callback: " + event), (Throwable)e);
                if (this.isJniError(e)) {
                    Log.w((String)"python", (String)"JNI error detected, clearing callback to prevent crashes");
                    this.callback = null;
                }
            }
        } else {
            this.mainHandler.post(() -> {
                block4: {
                    if (this.isDestroyed) {
                        return;
                    }
                    EventCallbackWrapper cb = this.callback;
                    if (cb == null) {
                        return;
                    }
                    try {
                        cb.callback(event, data);
                    }
                    catch (Exception e) {
                        Log.e((String)"python", (String)("Error in callback: " + event), (Throwable)e);
                        if (!this.isJniError(e)) break block4;
                        Log.w((String)"python", (String)"JNI error detected, clearing callback to prevent crashes");
                        this.callback = null;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String safeOnRequest(String url, String method, String headersJson) {
        if (this.isDestroyed) {
            return null;
        }
        WebViewRequestInterceptor currentInterceptor = this.requestInterceptor;
        if (currentInterceptor == null) {
            return null;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            try {
                return currentInterceptor.onRequest(url, method, headersJson);
            }
            catch (Exception e) {
                Log.e((String)"python", (String)"Error in onRequest", (Throwable)e);
                if (this.isJniError(e)) {
                    Log.w((String)"python", (String)"JNI error detected, clearing request interceptor to prevent crashes");
                    this.requestInterceptor = null;
                }
                return null;
            }
        }
        String[] result = new String[1];
        Object lock = new Object();
        this.mainHandler.post(() -> {
            Object object = lock;
            synchronized (object) {
                if (this.isDestroyed) {
                    result[0] = null;
                    lock.notify();
                    return;
                }
                WebViewRequestInterceptor interceptor = this.requestInterceptor;
                if (interceptor == null) {
                    result[0] = null;
                    lock.notify();
                    return;
                }
                try {
                    result[0] = interceptor.onRequest(url, method, headersJson);
                }
                catch (Exception e) {
                    Log.e((String)"python", (String)"Error in onRequest", (Throwable)e);
                    if (this.isJniError(e)) {
                        Log.w((String)"python", (String)"JNI error detected, clearing request interceptor to prevent crashes");
                        this.requestInterceptor = null;
                    }
                    result[0] = null;
                }
                lock.notify();
            }
        });
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(5000L);
            }
            catch (InterruptedException e) {
                Log.e((String)"python", (String)"Interrupted while waiting for onRequest", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return result[0];
    }

    private void safeOnResponse(String url, int statusCode, String headersJson) {
        if (this.isDestroyed) {
            return;
        }
        WebViewRequestInterceptor currentInterceptor = this.requestInterceptor;
        if (currentInterceptor == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            try {
                currentInterceptor.onResponse(url, statusCode, headersJson);
            }
            catch (Exception e) {
                Log.e((String)"python", (String)"Error in onResponse", (Throwable)e);
                if (this.isJniError(e)) {
                    Log.w((String)"python", (String)"JNI error detected, clearing request interceptor to prevent crashes");
                    this.requestInterceptor = null;
                }
            }
        } else {
            this.mainHandler.post(() -> {
                block4: {
                    if (this.isDestroyed) {
                        return;
                    }
                    WebViewRequestInterceptor interceptor = this.requestInterceptor;
                    if (interceptor == null) {
                        return;
                    }
                    try {
                        interceptor.onResponse(url, statusCode, headersJson);
                    }
                    catch (Exception e) {
                        Log.e((String)"python", (String)"Error in onResponse", (Throwable)e);
                        if (!this.isJniError(e)) break block4;
                        Log.w((String)"python", (String)"JNI error detected, clearing request interceptor to prevent crashes");
                        this.requestInterceptor = null;
                    }
                }
            });
        }
    }

    private boolean isJniError(Exception e) {
        String message = e.getMessage();
        return message != null && (message.contains("JNI") || message.contains("global reference") || message.contains("stale reference") || message.contains("invalid") || e instanceof IllegalStateException || e instanceof IllegalArgumentException);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.safeCallback("onPageStarted", url);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.safeCallback("onPageFinished", url);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String errorMsg = "SSL Error for URL: " + error.getUrl() + " - ";
        switch (error.getPrimaryError()) {
            case 3: {
                errorMsg = errorMsg + "Certificate authority is not trusted";
                break;
            }
            case 1: {
                errorMsg = errorMsg + "Certificate has expired";
                break;
            }
            case 2: {
                errorMsg = errorMsg + "Certificate hostname mismatch";
                break;
            }
            case 0: {
                errorMsg = errorMsg + "Certificate is not yet valid";
                break;
            }
            case 4: {
                errorMsg = errorMsg + "Certificate date is invalid";
                break;
            }
            case 5: {
                errorMsg = errorMsg + "Generic certificate error";
                break;
            }
            default: {
                errorMsg = errorMsg + "Unknown SSL error: " + error.getPrimaryError();
            }
        }
        if (this.ignoreSslErrors) {
            Log.d((String)"python", (String)(errorMsg + " (proceeding due to ignoreSslErrors=true)"));
            handler.proceed();
        } else {
            Log.e((String)"python", (String)(errorMsg + " (cancelling - ignoreSslErrors=false)"));
            handler.cancel();
        }
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        String url = request.getUrl().toString();
        String method = request.getMethod();
        HashMap headers = new HashMap();
        if (Build.VERSION.SDK_INT >= 21 && request.getRequestHeaders() != null) {
            headers.putAll(request.getRequestHeaders());
        }
        try {
            String newHeaders;
            String headersJson;
            String finalHeaders = headersJson = new JSONObject(headers).toString();
            if (this.requestInterceptor != null && (newHeaders = this.safeOnRequest(url, method, headersJson)) != null) {
                finalHeaders = newHeaders;
            }
            if (url.startsWith("http://") && (url.contains("127.0.0.1") || url.contains("localhost"))) {
                Log.w((String)"python", (String)("Skipping custom request for localhost HTTP URL to avoid Network Security Policy issues: " + url));
                return super.shouldInterceptRequest(view, request);
            }
            return this.performCustomRequest(url, method, finalHeaders);
        }
        catch (Exception e) {
            Log.e((String)"python", (String)"Error processing request", (Throwable)e);
            if (this.requestInterceptor != null) {
                this.notifyInterceptorOfError(url, e);
            }
            return super.shouldInterceptRequest(view, request);
        }
    }

    private void processCookies(String url, Map<String, String> responseHeaders) {
        try {
            ArrayList<String> setCookieHeaders = new ArrayList<String>();
            for (Map.Entry<String, String> entry : responseHeaders.entrySet()) {
                if (!"Set-Cookie".equalsIgnoreCase(entry.getKey())) continue;
                setCookieHeaders.add(entry.getValue());
            }
            if (!setCookieHeaders.isEmpty()) {
                try {
                    JSONObject cookieData = new JSONObject();
                    cookieData.put("url", (Object)url);
                    JSONArray cookieArray = new JSONArray();
                    for (String cookieHeader : setCookieHeaders) {
                        String cleanCookie = cookieHeader.replaceFirst("^Set-Cookie:\\s*", "");
                        cookieArray.put((Object)cleanCookie);
                    }
                    cookieData.put("cookies", (Object)cookieArray);
                    this.safeCallback("onCookiesReceived", cookieData.toString());
                }
                catch (Exception jsonEx) {
                    Log.e((String)"python", (String)"Error creating JSON for cookies", (Throwable)jsonEx);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"python", (String)"Error processing cookies", (Throwable)e);
        }
    }

    private WebResourceResponse performCustomRequest(String url, String method, String headersJson) throws Exception {
        InputStream inputStream;
        String reasonPhrase;
        int statusCode;
        String contentType;
        if (url.startsWith("data:") || url.startsWith("file:") || url.startsWith("android_asset:") || url.startsWith("android_res:")) {
            Log.d((String)"python", (String)("Skipping custom request for protocol: " + url));
            throw new Exception("Protocol not supported for custom requests");
        }
        JSONObject headersObj = new JSONObject(headersJson);
        URL urlObj = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        if (connection instanceof HttpsURLConnection && this.ignoreSslErrors) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sslContext = null;
                try {
                    sslContext = SSLContext.getInstance("TLS");
                }
                catch (Exception e) {
                    try {
                        sslContext = SSLContext.getInstance("SSL");
                    }
                    catch (Exception e2) {
                        sslContext = SSLContext.getInstance("TLSv1");
                    }
                }
                sslContext.init(null, trustAllCerts, new SecureRandom());
                httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (Exception sslEx) {
                Log.e((String)"python", (String)("Failed to configure SSL context for self-signed cert: " + sslEx.getMessage()), (Throwable)sslEx);
            }
        }
        connection.setRequestMethod(method);
        Iterator keys = headersObj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            connection.setRequestProperty(key, headersObj.getString(key));
        }
        try {
            connection.connect();
        }
        catch (SSLHandshakeException sslEx) {
            Log.e((String)"python", (String)("SSL handshake failed for URL: " + url + " - " + sslEx.getMessage()));
            if (this.ignoreSslErrors) {
                Log.w((String)"python", (String)"SSL error occurred despite ignoreSslErrors=true. Check SSL configuration.");
            }
            throw sslEx;
        }
        String mimeType = contentType = connection.getContentType();
        String encoding = connection.getContentEncoding();
        if (contentType != null && contentType.contains(";")) {
            mimeType = contentType.split(";")[0].trim();
            if (encoding == null && contentType.toLowerCase().contains("charset=")) {
                for (String part : contentType.split(";")) {
                    if (!part.toLowerCase().contains("charset=")) continue;
                    encoding = part.split("=")[1].trim();
                    break;
                }
            }
        }
        try {
            statusCode = connection.getResponseCode();
            reasonPhrase = connection.getResponseMessage();
            if (statusCode >= 200 && statusCode < 300) {
                inputStream = connection.getInputStream();
            } else {
                inputStream = connection.getErrorStream();
                if (inputStream == null) {
                    inputStream = connection.getInputStream();
                }
            }
        }
        catch (SSLHandshakeException sslEx) {
            Log.e((String)"python", (String)("SSL handshake failed while reading response from: " + url));
            if (this.ignoreSslErrors) {
                Log.w((String)"python", (String)"SSL error occurred despite ignoreSslErrors=true. Check SSL configuration.");
            }
            throw sslEx;
        }
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            if (entry.getKey() == null || entry.getValue().isEmpty()) continue;
            responseHeaders.put(entry.getKey(), entry.getValue().get(0));
        }
        this.safeOnResponse(url, statusCode, new JSONObject(responseHeaders).toString());
        this.processCookies(url, responseHeaders);
        if (Build.VERSION.SDK_INT >= 21) {
            return new WebResourceResponse(mimeType, encoding, statusCode, reasonPhrase, responseHeaders, inputStream);
        }
        return new WebResourceResponse(mimeType, encoding, inputStream);
    }

    private void notifyInterceptorOfError(String url, Exception e) {
        if (this.isDestroyed) {
            return;
        }
        try {
            JSONObject errorInfo = new JSONObject();
            errorInfo.put("error", (Object)e.getMessage());
            this.safeOnResponse(url, 0, errorInfo.toString());
        }
        catch (Exception jsonEx) {
            Log.e((String)"python", (String)"Error creating JSON for error response", (Throwable)jsonEx);
        }
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        super.onReceivedHttpError(view, request, errorResponse);
        if (this.isDestroyed) {
            return;
        }
        WebViewRequestInterceptor currentInterceptor = this.requestInterceptor;
        if (currentInterceptor != null && Build.VERSION.SDK_INT >= 21) {
            String url = request.getUrl().toString();
            int statusCode = errorResponse.getStatusCode();
            HashMap headers = new HashMap();
            if (errorResponse.getResponseHeaders() != null) {
                headers.putAll(errorResponse.getResponseHeaders());
            }
            JSONObject headersJson = new JSONObject(headers);
            String headersJsonString = headersJson.toString();
            this.safeOnResponse(url, statusCode, headersJsonString);
        }
        try {
            JSONObject data = new JSONObject();
            data.put("url", (Object)request.getUrl().toString());
            data.put("statusCode", errorResponse.getStatusCode());
            if (Build.VERSION.SDK_INT >= 21 && errorResponse.getResponseHeaders() != null) {
                JSONObject headers = new JSONObject();
                for (Map.Entry entry : errorResponse.getResponseHeaders().entrySet()) {
                    headers.put((String)entry.getKey(), entry.getValue());
                }
                data.put("headers", (Object)headers);
            }
            this.safeCallback("onReceivedHttpError", data.toString());
        }
        catch (Exception e) {
            Log.e((String)"python", (String)"Error creating JSON", (Throwable)e);
        }
    }
}

